/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.TypeContainerFilter;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.resource.ExplorerArb;
import oracle.javatools.db.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFilter
extends TypeContainerFilter {
    private static final Element LABEL_ELEMENT = new DefaultElement(){
        private String _label = ExplorerArb.getString((int)8);
        private Icon _icon = null;

        public String getShortLabel() {
            return this._label;
        }

        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = ExplorerArb.getIcon((int)6);
            }
            return this._icon;
        }
    };

    @Override
    protected Object getKey(Object object) {
        return null;
    }

    @Override
    protected boolean loadInThread() {
        return true;
    }

    @Override
    protected List<Element> loadChildrenImpl() throws IOException {
        ArrayList<Element> arrayList;
        block21: {
            AbstractConnectionNode abstractConnectionNode = (AbstractConnectionNode)this.getOwner().getData();
            arrayList = new ArrayList<Element>();
            try {
                abstractConnectionNode.open();
                Connection connection = abstractConnectionNode.getConnection();
                ObjectFactory objectFactory = null;
                try {
                    objectFactory = ObjectFactory.getFactory(abstractConnectionNode.getQualifiedConnectionName(), connection);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (objectFactory == null) break block21;
                if (objectFactory.isSupportsCatalog()) {
                    DBCatalogsInstance dBCatalogsInstance = objectFactory.getCatalogsInstance();
                    try {
                        this.fillInInitialProperties(dBCatalogsInstance);
                        for (DBChildInstance dBChildInstance : dBCatalogsInstance.listChildren()) {
                            DBCatalogInstance dBCatalogInstance = (DBCatalogInstance)dBChildInstance;
                            CatalogFolder catalogFolder = new CatalogFolder(DBURLFormatHelper.getURL(this.getURLProtocol(), abstractConnectionNode.getQualifiedConnectionName(), (String)dBCatalogInstance.getProperty("CATALOG"), null, null), dBCatalogInstance);
                            arrayList.add(catalogFolder);
                        }
                        break block21;
                    }
                    catch (SQLException sQLException) {
                        ExceptionHandler.handleException((Exception)sQLException);
                        break block21;
                    }
                    catch (AbortException abortException) {
                        arrayList.clear();
                        break block21;
                    }
                }
                if (objectFactory.isShowAllSchemasAtTopLevel()) {
                    DBSchemasInstance dBSchemasInstance = objectFactory.getSchemasInstance(null);
                    try {
                        this.fillInInitialProperties(dBSchemasInstance);
                        for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                            DBSchemaInstance dBSchemaInstance = (DBSchemaInstance)dBChildInstance;
                            SchemaFolder schemaFolder = new SchemaFolder(DBURLFormatHelper.getURL(this.getURLProtocol(), abstractConnectionNode.getQualifiedConnectionName(), null, (String)dBSchemaInstance.getProperty("SCHEMA"), null), dBSchemaInstance, (String)dBSchemasInstance.getProperty("ConnectionType"));
                            schemaFolder.setProperty("ConnectionType", dBSchemasInstance.getProperty("ConnectionType"));
                            arrayList.add(schemaFolder);
                        }
                        break block21;
                    }
                    catch (SQLException sQLException) {
                        ExceptionHandler.handleException((Exception)sQLException);
                        break block21;
                    }
                    catch (AbortException abortException) {
                        arrayList.clear();
                        break block21;
                    }
                }
                String string = abstractConnectionNode.getQualifiedConnectionName();
                String string2 = objectFactory.getSchema();
                DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(string2);
                this.fillInInitialProperties(dBSchemaInstance);
                arrayList.addAll(this.loadTypeFolders(dBSchemaInstance, string, null, string2));
                if (objectFactory.isShowOtherSchemas()) {
                    DBSchemasInstance dBSchemasInstance = objectFactory.getSchemasInstance(null);
                    URL uRL = DBURLFormatHelper.getURL(this.getURLProtocol(), string, null, null, "Schemas");
                    arrayList.add((Element)new OtherSchemasFolder(uRL, dBSchemasInstance));
                }
            }
            catch (IOException iOException) {
                Throwable throwable = iOException;
                if (iOException instanceof AbstractConnectionNode.ExceptionWrapper) {
                    throwable = iOException.getCause();
                }
                if (!(throwable instanceof ConnectionCanceledException)) {
                    TypeContainerFilter.ExceptionDialogRunnable exceptionDialogRunnable = new TypeContainerFilter.ExceptionDialogRunnable("Could not connect: {0}", throwable);
                    if (SwingUtilities.isEventDispatchThread()) {
                        exceptionDialogRunnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(exceptionDialogRunnable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                throw iOException;
            }
        }
        return arrayList;
    }

    protected void fillInInitialProperties(DBItemInstance dBItemInstance) {
    }
}

