/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.javatools.db.DBException;

public final class DatabaseConnection
extends AbstractConnectionNode
implements DatabaseNode {
    private Icon m_icon;
    private String m_type;

    public DatabaseConnection() {
        Attributes attributes = this.getAttributes();
        attributes.clear();
        attributes.set(ElementAttributes.CLOSEABLE | ElementAttributes.NAVIGABLE);
    }

    public DatabaseConnection(String string) {
        this();
        this.setURL(DBURLFormatHelper.getURL("sqldev.nav", string));
    }

    protected void closeConnection() {
        Connections.getInstance().closeConnection(this.getQualifiedConnectionName());
    }

    protected Connection openConnection() throws IOException {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            if (connection == null) {
                throw new AbstractConnectionNode.ExceptionWrapper((Throwable)new ConnectionCanceledException());
            }
        }
        catch (DBException dBException) {
            throw new AbstractConnectionNode.ExceptionWrapper(dBException);
        }
        catch (RuntimeException runtimeException) {
            throw new AbstractConnectionNode.ExceptionWrapper(runtimeException);
        }
        return connection;
    }

    public String getQualifiedConnectionName() {
        return DBURLFormatHelper.getConnectionName(this.getURL());
    }

    public String getConnectionName() {
        return Connections.getConnectionName(this.getQualifiedConnectionName());
    }

    public String getStoreName() {
        return Connections.getStoreName(this.getQualifiedConnectionName());
    }

    public String getShortLabel() {
        return this.getConnectionName();
    }

    public Icon getIcon() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.getQualifiedConnectionName());
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("RaptorConnectionType");
        if (this.m_type == null || !this.m_type.equals(string) || this.m_icon == null) {
            this.m_icon = DatabaseConnection.loadIcon(this.getQualifiedConnectionName());
            this.m_type = properties.getProperty("RaptorConnectionType");
        }
        return this.m_icon;
    }

    public static Icon loadIcon(String string) {
        ConnectionType connectionType;
        String string2;
        Icon icon = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null && (string2 = properties.getProperty("RaptorConnectionType")) != null && (connectionType = NavigatorHook.getConnectionType(string2)) != null) {
            icon = connectionType.getIcon();
        }
        if (icon == null) {
            icon = RaptorImage.getIcon((String)"db.png");
        }
        return icon;
    }

    public String getToolTipText() {
        boolean bl = Connections.getInstance().isConnectionOpen(this.getQualifiedConnectionName());
        String string = this.getShortLabel() + " " + (bl ? "Connected" : "");
        return string;
    }

    public String getLongLabel() {
        String string = this.getQualifiedConnectionName();
        return Connections.getDisplayName(string);
    }

    public String getMetaData(String string) {
        try {
            String string2 = null;
            Connection connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            string2 = databaseMetaData.getDatabaseProductName();
            string2 = string2 + " " + databaseMetaData.getDatabaseMajorVersion();
            string2 = string2 + "." + databaseMetaData.getDatabaseMinorVersion();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

