/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavActionListener
implements IObjectActionListener {
    private NavigatorManager _navigator;

    public NavActionListener(NavigatorManager navigatorManager) {
        this._navigator = navigatorManager;
    }

    @Override
    public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
    }

    @Override
    public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        this.getTree().refresh(this.getTnode(dBObject, this.getTree()));
    }

    @Override
    public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        this.getTree().refresh(this.getParentTNode(this.getTnode(dBObject, this.getTree())));
    }

    @Override
    public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        this.getTree().refresh(this.getParentTNode(this.getTnode(dBObject, this.getTree())));
        List list2 = EditorManager.getEditorManager().getAllEditors();
        Editor editor = null;
        Node node = null;
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        for (int i = 0; i < list2.size(); ++i) {
            editor = (Editor)list2.get(i);
            node = editor.getContext().getNode();
            if (node instanceof IViewerNode) {
                node = ((IViewerNode)node).getBaseNode();
            }
            if (node != dBObject.getNode()) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    private TreeExplorer getTree() {
        TreeExplorer treeExplorer = null;
        DockableView dockableView = DatabaseNavigatorManager.getInstance().getLastView();
        if (dockableView instanceof NavigatorWindow) {
            treeExplorer = ((NavigatorWindow)dockableView).getTreeExplorer();
        }
        return treeExplorer;
    }

    private TNode getTnode(DBObject dBObject, TreeExplorer treeExplorer) {
        return treeExplorer.searchTNodeBreadthFirst(dBObject.getElement(), treeExplorer.getRoot());
    }

    private TNode getParentTNode(TNode tNode) {
        return tNode.getAncestorTNode(ObjectFolder.class, false);
    }
}

