/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.net.URL;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.util.PropertyAccess;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class NavWindow
extends DefaultNavigatorWindow {
    private String m_title;
    private Controller m_controller;
    private URL _lastSaveAsLocation;

    protected NavWindow(Context context, String string, String string2) {
        super(context, string);
        this.m_title = string2;
    }

    public String getTitleName() {
        return this.m_title;
    }

    public String getTabName() {
        return this.m_title;
    }

    protected Controller createController(Controller controller) {
        return new DatabaseNavigatorController(controller);
    }

    public Controller getController() {
        if (this.m_controller == null) {
            this.m_controller = this.createController(super.getController());
        }
        return this.m_controller;
    }

    public Context getContext(EventObject eventObject) {
        String string;
        Context context = super.getContext(eventObject);
        Node node = context.getNode();
        if (node != null && node.getURL() != null && (string = DBURLFormatHelper.getName(node.getURL())) != null) {
            try {
                if (this._lastSaveAsLocation == null) {
                    this._lastSaveAsLocation = URLFactory.newFileURL((String)System.getProperty("user.home"));
                }
                URL uRL = URLFactory.newURL((URL)this._lastSaveAsLocation, (String)(string + ".sql"));
                context.setProperty("selectedURL", (Object)uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return context;
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        super.loadLayout(propertyAccess);
        final TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExplorerContext.restoreExpansionState((TNode)treeExplorer.getRoot(), (TreeExplorer)treeExplorer, null);
                }
            });
        }
    }
}

