/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigator.NavigatorConstants;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.jdeveloper.JDeveloperMenuConstants;

class NavigatorMenuListener
implements ContextMenuListener {
    private JMenuItem m_NewConn;
    private JMenuItem m_import;
    private JMenuItem m_export;
    private JMenuItem m_connect;
    private JMenuItem m_disconnect;
    private JMenuItem m_delete;
    private JMenuItem m_editConnection;
    private JMenuItem m_refresh;
    private JMenuItem m_filter;
    private JMenuItem m_clearFilter;
    private JMenuItem m_newObject;
    private JMenuItem m_editObject;

    NavigatorMenuListener() {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (DatabaseNavigatorManager.isDatabaseNavigatorContext(context)) {
            NavigatorConstants.removeNewMenuItem((ContextMenu)contextMenu);
            Element[] elementArray = context.getSelection();
            if (elementArray.length == 0) {
                return;
            }
            boolean bl = elementArray.length > 1;
            Element element = elementArray[0];
            this.buildMenus((MenuManager)contextMenu);
            if (element instanceof Databases) {
                contextMenu.add((Component)this.m_NewConn, 1.0f);
                contextMenu.add((Component)this.m_import, 1.0f);
                contextMenu.add((Component)this.m_export, 1.0f);
            } else if (!bl && element instanceof DatabaseConnection) {
                contextMenu.add((Component)this.m_connect, 1.0f);
                contextMenu.add((Component)this.m_disconnect, 1.0f);
                contextMenu.add((Component)this.m_delete, 1.0f);
                contextMenu.add((Component)this.m_editConnection, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            } else if (!bl && element instanceof ObjectFolder) {
                DBEditorFactory dBEditorFactory;
                AbstractButton abstractButton = null;
                ObjectFolder objectFolder = (ObjectFolder)element;
                DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
                String string = dBFolderInstance.getType();
                Database database = DatabaseNavigatorController.getDatabase(objectFolder.getConnectionName());
                if (database != null && (dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, (String)string)) != null) {
                    String string2 = dBEditorFactory.getCreateLabel(string);
                    abstractButton = this.m_newObject;
                    Action action = abstractButton.getAction();
                    action.putValue("Name", StringUtils.stripMnemonic((String)string2));
                    action.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
                    action.putValue("SmallIcon", DBTypeDisplayRegistry.getNodeIcon((String)string));
                    action.putValue("DBObjectType", string);
                    action.putValue("Database", database);
                    action.putValue("DBEditorFactory", dBEditorFactory);
                }
                if (abstractButton != null) {
                    contextMenu.add(abstractButton, 1.0f);
                    ((IdeAction)abstractButton.getAction()).updateAction(contextMenu.getContext());
                }
                contextMenu.add((Component)this.m_refresh, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                contextMenu.add((Component)this.m_filter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                contextMenu.add((Component)this.m_clearFilter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            } else if (element instanceof OtherSchemasFolder) {
                contextMenu.add((Component)this.m_refresh, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                contextMenu.add((Component)this.m_filter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                contextMenu.add((Component)this.m_clearFilter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            } else {
                JMenuItem jMenuItem = null;
                if (!bl && element instanceof TextNode && !((DatabaseNode)element).getObjectType().equals("XML SCHEMA")) {
                    jMenuItem = this.m_editObject;
                } else if (!bl && element instanceof DatabaseNode) {
                    DatabaseNode databaseNode = (DatabaseNode)element;
                    String string = (String)databaseNode.getProperty("ConnectionName");
                    String string3 = (String)databaseNode.getProperty("TYPE");
                    Database database = DatabaseNavigatorController.getDatabase(string);
                    if (database != null && DatabaseNavigatorController.canEditObject(databaseNode)) {
                        jMenuItem = this.m_editObject;
                        Action action = jMenuItem.getAction();
                        action.putValue("DBObjectType", string3);
                        action.putValue("Database", database);
                        action.putValue("URL", databaseNode.getURL());
                    }
                }
                if (jMenuItem != null) {
                    contextMenu.add(jMenuItem, element instanceof TextNode ? 1.0f : JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element;
        boolean bl = false;
        NavigationPoint navigationPoint = null;
        if (DatabaseNavigatorManager.isDatabaseNavigatorContext(context)) {
            TNode tNode;
            element = context.getElement();
            if (element instanceof ChildObjectElement) {
                RunnableSourceNode runnableSourceNode;
                tNode = ExplorerContext.getSingleTNode((Context)context);
                if (tNode != null && (runnableSourceNode = (RunnableSourceNode)tNode.getAncestor(RunnableSourceNode.class, true)) != null) {
                    navigationPoint = runnableSourceNode.getNavigationPoint((ChildObjectElement)element);
                }
                bl = true;
            } else if (element instanceof DatabaseSourceNode) {
                tNode = ExplorerContext.getFirstTNode((Context)context);
                TreeExplorer treeExplorer = tNode.getOwner();
                treeExplorer.expand(tNode, false);
                bl = false;
            }
        }
        if (navigationPoint != null) {
            element = NavigationManager.getNavigationManager();
            try {
                if (element != null) {
                    element.navigateTo(navigationPoint);
                } else {
                    navigationPoint.navigate();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return bl;
    }

    private void buildMenus(MenuManager menuManager) {
        if (this.m_NewConn == null) {
            this.m_NewConn = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_NEW_CONN);
            this.m_import = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_IMP_CONN);
            this.m_export = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_EXP_CONN);
            this.m_connect = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_CONNECT, 1.0f);
            this.m_disconnect = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_DISCONNECT, 1.1f);
            this.m_refresh = this.createMenu(menuManager, 51);
            this.m_delete = this.createMenu(menuManager, 20);
            this.m_editConnection = this.createMenu(menuManager, 56);
            this.m_filter = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_FILTER);
            this.m_clearFilter = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_CLEAR_FILTER);
            this.m_newObject = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_NEWOBJECT);
            this.m_editObject = menuManager.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_EDITOBJECT);
        }
    }

    private JMenuItem createMenu(MenuManager menuManager, int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        return ideAction != null ? menuManager.createMenuItem((ToggleAction)ideAction) : null;
    }
}

