/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.navigator.AbstractDatabaseFilter;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class ObjectFilter
extends AbstractDatabaseFilter {
    private List<Element> m_children;
    private boolean _working;
    private IndeterminateProgressMonitor _monitor;
    private JScrollPane _detailPane;
    private Document _detailDoc;
    private ExplorerNode _loading;

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
        }
        if (this._monitor != null) {
            this._monitor.close();
            this._monitor = null;
        }
        Ide.getWaitCursor().hide();
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            TNode tNode2 = this.lookup(element);
            if (tNode2 == null) continue;
            treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
            this.uncache(tNode2);
        }
        return tNode;
    }

    public void closeChildren() {
        if (this.m_children != null) {
            this.m_children = null;
        }
    }

    public Iterator getChildren() {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Element>();
            class Loader
            extends ProgressRunnable {
                private boolean _canceled;

                Loader() {
                }

                protected Object doWork() throws IOException {
                    ObjectFolder objectFolder = (ObjectFolder)ObjectFilter.this.getOwner().getData();
                    URL uRL = objectFolder.getURL();
                    DBContainerInstance dBContainerInstance = ObjectFilter.this.getFolderInstance();
                    QueryProgressListener queryProgressListener = new QueryProgressListener(){
                        int i = 0;

                        public void rsClosed() {
                        }

                        public void rsOpened() {
                        }

                        public void rsRowFetched() {
                        }
                    };
                    ArrayList<DatabaseNode> arrayList = new ArrayList<DatabaseNode>();
                    try {
                        for (DBChildInstance dBChildInstance : dBContainerInstance.listChildren(queryProgressListener)) {
                            DBObjectInstance dBObjectInstance = (DBObjectInstance)dBChildInstance;
                            DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL, dBObjectInstance);
                            if (databaseNode == null) continue;
                            arrayList.add(databaseNode);
                        }
                    }
                    catch (SQLException sQLException) {
                        ExceptionHandler.handleException((Exception)sQLException);
                    }
                    catch (AbortException abortException) {
                        arrayList.clear();
                    }
                    return arrayList;
                }

                protected void finish(Object object) {
                    if (object instanceof List) {
                        ObjectFilter.this.m_children.addAll((List)object);
                    }
                }

                protected void doCancel() {
                    super.doCancel();
                    this._canceled = true;
                }

                public boolean isCanceled() {
                    return this._canceled;
                }
            }
            Loader loader = new Loader();
            loader.setTitle(DatabaseNavigatorResources.getString(12));
            loader.setMessage(DatabaseNavigatorResources.format(11, this.getOwner().getData().getShortLabel()));
            try {
                loader.start(true);
            }
            catch (ProgressException progressException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, progressException.getStackTrace()[0].toString(), progressException);
            }
        }
        return this.m_children.iterator();
    }

    public DBContainerInstance getFolderInstance() {
        ObjectFolder objectFolder = (ObjectFolder)this.getOwner().getData();
        return objectFolder.getFolderInstance();
    }

    protected Object getKey(Object object) {
        if (object instanceof ObjectFolder) {
            return ((ObjectFolder)object).getURL();
        }
        return object != null ? object.toString() : null;
    }

    public boolean canRefresh(TNode[] tNodeArray) {
        return true;
    }

    public void refresh(TNode[] tNodeArray) {
        if (this.m_children != null) {
            this.m_children = null;
        }
    }
}

