/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.db.ConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeContainerFilter
extends BaseRaptorFilter {
    private Comparator m_comp;
    private List m_children;

    protected TypeContainerFilter() {
    }

    public Iterator getChildren() {
        block3: {
            if (this.m_children == null) {
                this.m_children = new ArrayList();
                final Element element = this.getOwner().getData();
                try {
                    this.m_children.addAll(this.loadChildrenImpl());
                }
                catch (IOException iOException) {
                    if (!(element instanceof Node)) break block3;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Node node = (Node)element;
                            try {
                                node.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }
        return this.m_children.iterator();
    }

    protected abstract List<Element> loadChildrenImpl() throws IOException;

    protected void addChild(Element element) {
        this.m_children.add(element);
    }

    protected boolean loadInThread() {
        return false;
    }

    public void closeChildren() {
        if (this.m_children != null) {
            this.m_children.clear();
            this.m_children = null;
        }
        this.m_comp = null;
        this.clearCache();
    }

    public Comparator getComparator() {
        if (this.m_comp == null) {
            this.m_comp = new C();
        }
        return this.m_comp;
    }

    protected List<Element> loadTypeFolders(DBSchemaInstance dBSchemaInstance, String string, String string2, String string3) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (DBFolderInstance dBFolderInstance : dBSchemaInstance.listTypeFolders()) {
            URL uRL = DBURLFormatHelper.getURL(this.getURLProtocol(), string, string2, string3, dBFolderInstance.getType());
            Element element = this.createTypeFolder(dBFolderInstance, uRL);
            arrayList.add(element);
        }
        return arrayList;
    }

    private Element createTypeFolder(DBFolderInstance dBFolderInstance, URL uRL) {
        return DatabaseNavigatorElementFactory.getTypeFolder(uRL, dBFolderInstance);
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            TNode tNode2 = this.lookup(element);
            if (tNode2 == null) {
                tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)e, tNode);
            }
            if (tNode2 == null) continue;
            treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
            this.uncache(tNode2);
        }
        return tNode;
    }

    public boolean canRefresh(TNode[] tNodeArray) {
        return super.canRefresh(tNodeArray);
    }

    public boolean canUpdate(TNode tNode, UpdateMessage updateMessage) {
        return super.canUpdate(tNode, updateMessage);
    }

    public void refresh(TNode[] tNodeArray) {
        super.refresh(tNodeArray);
    }

    protected static class ExceptionDialogRunnable
    implements Runnable {
        Throwable m_ex;
        String m_msg;

        ExceptionDialogRunnable(String string, Throwable throwable) {
            Throwable throwable2;
            while ((throwable instanceof ConnectionException || throwable instanceof DBException) && (throwable2 = throwable.getCause()) instanceof Exception) {
                throwable = throwable2;
            }
            this.m_ex = throwable;
            this.m_msg = string;
        }

        public void run() {
            String string = CommonArb.getString(10);
            Frame frame = IdeUtil.getMainWindow();
            if (this.m_ex instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((Component)frame, (String)string, (SQLException)((SQLException)this.m_ex));
            } else {
                String string2 = this.m_ex instanceof ConnectionException ? MessageFormat.format(this.m_msg, this.m_ex.getLocalizedMessage()) : this.m_ex.getLocalizedMessage();
                ExceptionDialog.showExceptionDialog((Component)frame, (Throwable)this.m_ex, (String)string, (String)string2, null);
            }
        }
    }

    private static class C
    implements Comparator {
        private C() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            return this.compareTNodes((TNode)object, (TNode)object2);
        }

        private int compareTNodes(TNode tNode, TNode tNode2) {
            Element element = tNode.getData();
            Element element2 = tNode2.getData();
            if (element instanceof OtherSchemasFolder) {
                return 1;
            }
            if (element2 instanceof OtherSchemasFolder) {
                return -1;
            }
            if (element instanceof ObjectFolder && element2 instanceof ObjectFolder) {
                return this.compareObjectFolders((ObjectFolder)element, (ObjectFolder)element2);
            }
            return element.toString().compareTo(element2.toString());
        }

        private int compareObjectFolders(ObjectFolder objectFolder, ObjectFolder objectFolder2) {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            DBFolderInstance dBFolderInstance2 = objectFolder2.getFolderInstance();
            DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
            DatabaseFolder databaseFolder2 = (DatabaseFolder)dBFolderInstance2.getDescriptor();
            double d = databaseFolder.getWeight() - databaseFolder2.getWeight();
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return dBFolderInstance.getType().compareTo(dBFolderInstance2.getType());
        }
    }
}

