/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.QuickParser;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.xml.AbstractChildInstance;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlArguments
implements FilterChildProvider {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Set<ReadTextBuffer> m_buffers = new HashSet<ReadTextBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<DBChildInstance> listChildren(DatabaseNode databaseNode, String string) throws AbortException, SQLException {
        ArrayList<DBChildInstance> arrayList;
        block28: {
            DBObjectInstance dBObjectInstance;
            DatabaseObject databaseObject;
            DatabaseItem databaseItem;
            arrayList = new ArrayList<DBChildInstance>();
            if ("ARGS".equals(string) && (databaseItem = (databaseObject = (DatabaseObject)(dBObjectInstance = databaseNode.getNodeInstance()).getDescriptor()).getChildType(string)) != null) {
                TextBuffer textBuffer = ((PlSqlNode)databaseNode).acquireTextBuffer();
                this.m_buffers.add((ReadTextBuffer)textBuffer);
                String string2 = databaseObject.getType();
                ObjectFactory objectFactory = dBObjectInstance.getObjectFactory();
                if ("PROCEDURE".equals(string2) || "FUNCTION".equals(string2)) {
                    SQLException sQLException2222;
                    ResultSet resultSet;
                    PreparedStatement preparedStatement;
                    block26: {
                        Connection connection = objectFactory.getConnection();
                        preparedStatement = null;
                        resultSet = null;
                        preparedStatement = connection.prepareStatement("SELECT data_type, argument_name name \nFROM all_arguments \nWHERE \targument_name is not null \nand object_name=? and owner=? and package_name is NULL \norder by position");
                        Object object = databaseNode.getProperty("NAME");
                        Object object2 = databaseNode.getProperty("SCHEMA");
                        preparedStatement.setObject(1, object);
                        preparedStatement.setObject(2, object2);
                        resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            ArgChildInstance argChildInstance = new ArgChildInstance(objectFactory);
                            argChildInstance.setDescriptor(databaseItem);
                            argChildInstance.setProperty("NAME", resultSet.getString("name"));
                            argChildInstance.setProperty("CODE_OFFSET", -1);
                            String string3 = resultSet.getString("data_type");
                            if ("DATE".equalsIgnoreCase(string3) || "TIME".equalsIgnoreCase(string3) || "TIMESTAMP".equalsIgnoreCase(string3)) {
                                argChildInstance.setProperty("MEMBER_TYPE", "DATE");
                            } else if (string3.toUpperCase().contains("CHAR")) {
                                argChildInstance.setProperty("MEMBER_TYPE", "STRING");
                            } else if (string3.toUpperCase().contains("EXCEPTION")) {
                                argChildInstance.setProperty("MEMBER_TYPE", "EXCEPTION");
                            } else {
                                argChildInstance.setProperty("MEMBER_TYPE", string3);
                            }
                            argChildInstance.setProperty("TOOLTIP", resultSet.getString("name") + " " + string3);
                            arrayList.add(argChildInstance);
                        }
                        Object var19_21 = null;
                        if (resultSet == null) break block26;
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2222) {
                            // empty catch block
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException2222) {
                            // empty catch block
                        }
                    }
                    ((PlSqlNode)databaseNode).releaseTextBuffer();
                    {
                        break block28;
                        catch (SQLException sQLException3) {
                            SQLException sQLException42222;
                            this.logger.severe("SELECT data_type, argument_name name \nFROM all_arguments \nWHERE \targument_name is not null \nand object_name=? and owner=? and package_name is NULL \norder by position".toString());
                            this.logger.severe(sQLException3.getMessage());
                            Object var19_22 = null;
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (SQLException sQLException42222) {
                                    // empty catch block
                                }
                            }
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (SQLException sQLException42222) {
                                    // empty catch block
                                }
                            }
                            ((PlSqlNode)databaseNode).releaseTextBuffer();
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException sQLException52222;
                        Object var19_23 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException52222) {
                                // empty catch block
                            }
                        }
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException sQLException52222) {
                                // empty catch block
                            }
                        }
                        ((PlSqlNode)databaseNode).releaseTextBuffer();
                        throw throwable;
                    }
                }
                String string4 = textBuffer.getString(0, textBuffer.getLength());
                ((PlSqlNode)databaseNode).releaseTextBuffer();
                LinkedList<LexerToken> linkedList = LexerToken.parse(string4, false);
                boolean bl = "PACKAGE BODY".equals(string2);
                PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser(databaseItem, objectFactory);
                plsqlStructureParser.parse(linkedList);
                arrayList.addAll(plsqlStructureParser.children);
            }
        }
        return arrayList;
    }

    private static class ArgChildInstance
    extends AbstractChildInstance
    implements Comparable {
        private ArgChildInstance(ObjectFactory objectFactory) {
            super(objectFactory);
        }

        protected void setDescriptor(DatabaseItem databaseItem) {
            super.setDescriptor(databaseItem);
        }

        public int compareTo(Object object) {
            String string = (String)this.getProperty("NAME");
            String string2 = (String)((ArgChildInstance)object).getProperty("NAME");
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlsqlStructureParser
    extends QuickParser {
        Set<ArgChildInstance> children = new TreeSet<ArgChildInstance>();
        DatabaseItem child;
        ObjectFactory objFact;

        public PlsqlStructureParser(DatabaseItem databaseItem, ObjectFactory objectFactory) {
            this.child = databaseItem;
            this.objFact = objectFactory;
        }

        @Override
        public void pop(List<LexerToken> list, LinkedList<Integer> linkedList, int n) {
            if (linkedList.size() != 1) {
                return;
            }
            int n2 = linkedList.getLast();
            String string = list.get((int)n2).content;
            ArgChildInstance argChildInstance = new ArgChildInstance(this.objFact);
            argChildInstance.setDescriptor(this.child);
            argChildInstance.setProperty("NAME", list.get((int)(n2 + 1)).content);
            argChildInstance.setProperty("CODE_OFFSET", list.get((int)(n2 + 1)).begin);
            if ("procedure".equalsIgnoreCase(string)) {
                argChildInstance.setProperty("MEMBER_TYPE", "PROCEDURE");
            } else if ("function".equalsIgnoreCase(string)) {
                argChildInstance.setProperty("MEMBER_TYPE", "FUNCTION");
            } else {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i <= n2 + 20 && i < list.size(); ++i) {
                stringBuffer.append(list.get((int)i).content + " ");
                if (")".equals(list.get((int)i).content) || ";".equals(list.get((int)i).content)) break;
            }
            argChildInstance.setProperty("TOOLTIP", stringBuffer.toString());
            this.children.add(argChildInstance);
        }

        @Override
        public void call(List<LexerToken> list, LinkedList<Integer> linkedList, int n) {
            String string = list.get((int)n).content;
            if (linkedList.size() == 0 && ("type".equalsIgnoreCase(string) || "subtype".equalsIgnoreCase(string)) && !"%".equalsIgnoreCase(list.get((int)(n - 1)).content) && Character.isLetter(list.get((int)(n + 1)).content.charAt(0))) {
                ArgChildInstance argChildInstance = new ArgChildInstance(this.objFact);
                argChildInstance.setDescriptor(this.child);
                argChildInstance.setProperty("NAME", list.get((int)(n + 1)).content);
                argChildInstance.setProperty("CODE_OFFSET", list.get((int)(n + 1)).begin);
                argChildInstance.setProperty("MEMBER_TYPE", "TYPE");
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = n;
                while (true) {
                    stringBuffer.append(list.get((int)n2).content + " ");
                    if (";".equals(list.get((int)n2).content) || n2 > n + 20 || n2 >= list.size()) break;
                    ++n2;
                }
                n = n2;
                argChildInstance.setProperty("TOOLTIP", stringBuffer.toString());
                this.children.add(argChildInstance);
            } else if (linkedList.size() == 0 && "cursor".equalsIgnoreCase(string) && Character.isLetter(list.get((int)(n + 1)).content.charAt(0))) {
                ArgChildInstance argChildInstance = new ArgChildInstance(this.objFact);
                argChildInstance.setDescriptor(this.child);
                argChildInstance.setProperty("NAME", list.get((int)(n + 1)).content);
                argChildInstance.setProperty("CODE_OFFSET", list.get((int)(n + 1)).begin);
                argChildInstance.setProperty("MEMBER_TYPE", "CURSOR");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = n; i <= n + 20 && i < list.size(); ++i) {
                    stringBuffer.append(list.get((int)i).content + " ");
                    if (")".equals(list.get((int)i).content) || "is".equalsIgnoreCase(list.get((int)i).content)) break;
                }
                argChildInstance.setProperty("TOOLTIP", stringBuffer.toString());
                this.children.add(argChildInstance);
            } else if (linkedList.size() == 0 && ("number".equalsIgnoreCase(string) || "varchar2".equalsIgnoreCase(string) || "date".equalsIgnoreCase(string) || "boolean".equalsIgnoreCase(string) || ("type".equalsIgnoreCase(string) || "rowtype".equalsIgnoreCase(string)) && "%".equalsIgnoreCase(list.get((int)(n - 1)).content))) {
                ArgChildInstance argChildInstance = new ArgChildInstance(this.objFact);
                argChildInstance.setDescriptor(this.child);
                int n3 = n - 1;
                String string2 = list.get((int)n3).content;
                if ("CONSTANT".equalsIgnoreCase(string2)) {
                    string2 = list.get((int)(--n3)).content;
                } else if ("%".equalsIgnoreCase(string2) && ".".equalsIgnoreCase(string2 = list.get((int)(n3 -= 2)).content)) {
                    string2 = list.get((int)(n3 -= 2)).content;
                }
                if ("IS".equalsIgnoreCase(string2) || "OF".equalsIgnoreCase(string2)) {
                    return;
                }
                argChildInstance.setProperty("NAME", string2);
                argChildInstance.setProperty("CODE_OFFSET", list.get((int)n3).begin);
                if ("varchar2".equalsIgnoreCase(string)) {
                    string = "STRING";
                }
                argChildInstance.setProperty("MEMBER_TYPE", string.toUpperCase());
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = n3 + 1; i <= n + 20 && i < list.size() && !";".equals(list.get((int)i).content); ++i) {
                    stringBuffer.append(list.get((int)i).content + " ");
                }
                argChildInstance.setProperty("TOOLTIP", stringBuffer.toString());
                this.children.add(argChildInstance);
            }
        }
    }
}

