/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-navigator";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-navigator", "sqldev-navigator-hook");
    private static List<String> s_classes = new ArrayList<String>();
    private static List<String> s_pkgs = new ArrayList<String>();
    private static List<NavigatorDescriptor> s_descriptors;

    public static synchronized void registerDescriptor(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                Logger.getLogger(NavigatorHook.class.getClass().getName()).log(Level.WARNING, malformedURLException2.getStackTrace()[0].toString(), malformedURLException2);
            }
        }
        if (uRL != null) {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            try {
                dOMParser.parse(uRL.openStream());
                s_descriptors.add(new NavigatorDescriptor(dOMParser.getDocument()));
            }
            catch (XMLParseException xMLParseException) {
                System.err.println("Could not add Actions:" + string + "\n" + xMLParseException.getMessage());
            }
            catch (SAXException sAXException) {
                System.err.println("Could not add Actions:" + string + "\n" + sAXException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println("Could not add Actions:" + string + "\n" + iOException.getMessage());
            }
        } else {
            System.err.println("Could not add Actions:" + string);
        }
    }

    public static Iterator<NavigatorDescriptor> getNavigatorDescriptors() {
        NavigatorHook.initDescriptors();
        return s_descriptors.iterator();
    }

    public static Iterator<ConnectionType> getConnectionTypes() {
        Set<ConnectionType> set = NavigatorHook.fetchConnectionTypes();
        return set.iterator();
    }

    public static ConnectionType getConnectionType(ConnectionInfo connectionInfo) {
        String string = connectionInfo.getConnectionType();
        Version version = connectionInfo.getVersion();
        return NavigatorHook.getConnectionType(string, version);
    }

    public static ConnectionType getConnectionType(String string) {
        return NavigatorHook.getConnectionType(string, null);
    }

    private static ConnectionType getConnectionType(String string, Version version) {
        Set<ConnectionType> set = NavigatorHook.fetchConnectionTypes();
        for (ConnectionType connectionType : set) {
            if (!ModelUtil.areEqual((Object)connectionType.getType(), (Object)string)) continue;
            ConnectionTypeDetails connectionTypeDetails = connectionType.getImpl();
            Version version2 = connectionTypeDetails.getMinimumVersion();
            Version version3 = connectionTypeDetails.getMaximumVersion();
            if (version != null && (version2 != null && version2.compareTo((Object)version) > 0 || version3 != null && version3.compareTo((Object)version) < 0)) continue;
            return connectionType;
        }
        return null;
    }

    private static Set<ConnectionType> fetchConnectionTypes() {
        TreeSet<ConnectionType> treeSet = new TreeSet<ConnectionType>(new TypeComparator());
        Iterator<NavigatorDescriptor> iterator = NavigatorHook.getNavigatorDescriptors();
        while (iterator.hasNext()) {
            NavigatorDescriptor navigatorDescriptor = iterator.next();
            Iterator<ConnectionType> iterator2 = navigatorDescriptor.getConnectionTypes();
            while (iterator2.hasNext()) {
                treeSet.add(iterator2.next());
            }
        }
        return treeSet;
    }

    private static void initDescriptors() {
        if (s_descriptors == null) {
            Object object;
            URL uRL;
            s_descriptors = new ArrayList<NavigatorDescriptor>();
            for (String string : s_pkgs) {
                uRL = NavigatorHook.class.getResource(string);
                if (uRL == null) continue;
                for (URL uRL2 : object = URLFileSystem.list((URL)uRL, (URLFilenameFilter)NavigatorDescriptorFilenameFilter.INSTANCE)) {
                    NavigatorDescriptor navigatorDescriptor = NavigatorHook.createDescriptor(uRL2);
                    if (navigatorDescriptor == null) continue;
                    s_descriptors.add(navigatorDescriptor);
                }
            }
            for (String string : s_classes) {
                uRL = NavigatorHook.class.getResource(string);
                if (uRL == null || (object = NavigatorHook.createDescriptor(uRL)) == null) continue;
                s_descriptors.add((NavigatorDescriptor)object);
            }
            for (String string : DBConfig.getInstance().getExtensions("NAVIGATOR")) {
                NavigatorHook.registerDescriptor(string);
            }
        }
    }

    private static NavigatorDescriptor createDescriptor(URL uRL) {
        NavigatorDescriptor navigatorDescriptor = null;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            dOMParser.parse(uRL);
            XMLDocument xMLDocument = dOMParser.getDocument();
            if (xMLDocument != null) {
                navigatorDescriptor = new NavigatorDescriptor(xMLDocument);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(NavigatorHook.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return navigatorDescriptor;
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(new ElementName(NS, "descriptor"), (ElementVisitor)new DescriptorVisitor());
        elementStartContext.registerChildVisitor(new ElementName(NS, "descriptorPkg"), (ElementVisitor)new DescriptorPkgVisitor());
    }

    private static class NavigatorDescriptorFilenameFilter
    implements URLFilenameFilter {
        private static final NavigatorDescriptorFilenameFilter INSTANCE = new NavigatorDescriptorFilenameFilter();

        private NavigatorDescriptorFilenameFilter() {
        }

        public boolean accept(URL uRL, String string) {
            return string.toLowerCase().endsWith(".xml");
        }
    }

    private class DescriptorPkgVisitor
    extends ElementVisitor {
        private DescriptorPkgVisitor() {
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            if (string != null) {
                string = string.trim();
            }
            if (ModelUtil.hasLength((String)string)) {
                s_pkgs.add(string);
            }
        }
    }

    private class DescriptorVisitor
    extends ElementVisitor {
        private DescriptorVisitor() {
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            if (string != null) {
                string = string.trim();
            }
            if (ModelUtil.hasLength((String)string)) {
                s_classes.add(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeComparator
    implements Comparator<ConnectionType> {
        private TypeComparator() {
        }

        @Override
        public int compare(ConnectionType connectionType, ConnectionType connectionType2) {
            return connectionType == connectionType2 ? 0 : connectionType.getType().compareTo(connectionType2.getType());
        }
    }
}

