/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Predicate {
    EQ("="),
    NOT_EQ("<>"),
    LIKE("LIKE"),
    NOT_LIKE("NOT LIKE"),
    LT("<"),
    GT(">"),
    LT_EQ("<="),
    GT_EQ(">="),
    BETWEEN("BETWEEN"){

        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_BETWEEN;
        }

        public int getArgCount() {
            return 2;
        }
    }
    ,
    NOT_BETWEEN("NOT BETWEEN"){

        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_BETWEEN;
        }

        public int getArgCount() {
            return 2;
        }
    }
    ,
    IN("IN"),
    NOT_IN("NOT_IN"),
    NULL("IS NULL"){

        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_NULL;
        }

        public int getArgCount() {
            return 0;
        }
    }
    ,
    NOT_NULL("IS NOT NULL"){

        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_NULL;
        }

        public int getArgCount() {
            return 0;
        }
    };

    private String _label;
    private static final String PATTERN_STANDARD = "{0} {1} :{2}";
    private static final String PATTERN_STANDARD_INSENSITIVE = "UPPER({0}) {1} UPPER(:{2})";
    private static final String PATTERN_BETWEEN = "{0} {1} :{2}_0 AND :{2}_1";
    private static final String PATTERN_NULL = "{0} {1}";
    public static final Set<Predicate> NUMBER_PREDICATES;
    public static final Set<Predicate> CHAR_PREDICATES;
    public static final Set<Predicate> DATE_PREDICATES;

    private Predicate(String string2) {
        this._label = string2;
    }

    public String toString() {
        return this._label;
    }

    protected String getFragmentFormat(boolean bl) {
        return bl ? PATTERN_STANDARD_INSENSITIVE : PATTERN_STANDARD;
    }

    public String getSQLFragment(String string, String string2) {
        return this.getSQLFragment(string, string2, false);
    }

    public String getSQLFragment(String string, String string2, boolean bl) {
        return MessageFormat.format(this.getFragmentFormat(bl), string, this._label, string2);
    }

    public String getDateSQLFragment(String string, String string2) {
        String string3 = "TO_CHAR(" + string + ")";
        if (this._label.equals(Predicate.BETWEEN._label) || this._label.equals(Predicate.NOT_BETWEEN._label)) {
            return this.getSQLFragment(string, string2, false);
        }
        return MessageFormat.format(this.getFragmentFormat(false), string3, this._label, string2);
    }

    public int getArgCount() {
        return 1;
    }

    static {
        NUMBER_PREDICATES = EnumSet.of(EQ, new Predicate[]{NOT_EQ, LT, GT, LT_EQ, GT_EQ, BETWEEN, NOT_BETWEEN});
        CHAR_PREDICATES = EnumSet.of(EQ, NOT_EQ, LIKE, NOT_LIKE);
        DATE_PREDICATES = EnumSet.copyOf(NUMBER_PREDICATES);
    }
}

