/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.model.Catalogs;
import oracle.dbtools.raptor.navigator.model.DBSchemas;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.AbstractObjectType;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.xml.XmlObjectType;
import oracle.dbtools.raptor.navigator.xml.XmlSchemasImpl;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;

public final class QueryFactory
implements NavigatorXmlElements {
    private static final Map<String, QueryFactory> s_factories = new HashMap<String, QueryFactory>();
    private String m_dbType;
    private List<ObjectType> m_types = new ArrayList<ObjectType>();
    private XmlSchemasImpl m_schemas;
    private XmlCatalogsImpl m_catalogs;

    public static synchronized QueryFactory getFactory(String string) {
        QueryFactory queryFactory = s_factories.get(string);
        if (queryFactory == null) {
            queryFactory = QueryFactory.createFactory(string);
            s_factories.put(string, queryFactory);
        }
        return queryFactory;
    }

    private static QueryFactory createFactory(String string) {
        return new QueryFactory(string);
    }

    private QueryFactory(String string) {
        this.m_dbType = string;
        String string2 = MessageFormat.format("/navigator/objectType[@connType=\"{0}\"]", this.m_dbType);
        Iterator<NavigatorDescriptor> iterator = NavigatorHook.getNavigatorDescriptors();
        while (iterator.hasNext()) {
            NavigatorDescriptor navigatorDescriptor = iterator.next();
            try {
                XMLDocument xMLDocument = navigatorDescriptor.getDocument();
                for (XMLNode xMLNode : XmlNavigatorUtils.getElements(string2, (XMLNode)xMLDocument)) {
                    String string3 = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode);
                    if (string3 == null) continue;
                    if ("SCHEMAS".equals(string3)) {
                        this.m_schemas = new XmlSchemasImpl(string, navigatorDescriptor, xMLNode);
                        continue;
                    }
                    if ("CATALOGS".equals(string3)) {
                        this.m_catalogs = new XmlCatalogsImpl(string, navigatorDescriptor, xMLNode);
                        continue;
                    }
                    ObjectType objectType = this.createObjectType(string, string3, navigatorDescriptor, xMLNode);
                    this.m_types.add(objectType);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private ObjectType createObjectType(String string, String string2, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        ObjectType objectType = new XmlObjectType(string, string2, navigatorDescriptor, xMLNode);
        String string3 = XmlNavigatorUtils.getAttributeValue("", "implementationClass", xMLNode);
        if (string3 != null) {
            try {
                Class<?> clazz = Class.forName(string3);
                assert (AbstractObjectType.class.isAssignableFrom(clazz));
                AbstractObjectType abstractObjectType = (AbstractObjectType)clazz.newInstance();
                abstractObjectType.setDelegate((XmlObjectType)objectType);
                objectType = abstractObjectType;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectType;
    }

    public ObjectType[] listTypes() {
        return this.m_types.toArray(new ObjectType[0]);
    }

    public ObjectType getObjectType(String string) {
        for (ObjectType objectType : this.m_types) {
            if (!ModelUtil.areEqual((Object)objectType.getType(), (Object)string)) continue;
            return objectType;
        }
        return null;
    }

    DBSchemas getSchemas() {
        return this.m_schemas;
    }

    Catalogs getCatalogs() {
        return this.m_catalogs;
    }
}

