/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.AbstractNodeImpl;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.xml.XmlFolderImpl;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.xml.XmlNodeImpl;
import oracle.xml.parser.v2.XMLNode;

public class XmlObjectType
implements NavigatorXmlElements,
ObjectType {
    private String m_type;
    private String m_dbType;
    private XMLNode m_node;
    private double m_weight = 100.0;
    private boolean m_includesSyns;
    private NavigatorDescriptor m_desc;
    private List<XmlFolderImpl> m_folders;
    private DatabaseObject m_nodeImpl;

    public XmlObjectType(String string, String string2, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        this.m_dbType = string;
        this.m_type = string2;
        this.m_desc = navigatorDescriptor;
        this.m_node = xMLNode;
        this.initFolders();
        this.initNode();
        String string3 = XmlNavigatorUtils.getAttributeValue("", "weight", xMLNode);
        if (string3 != null) {
            try {
                this.m_weight = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_includesSyns = Boolean.valueOf(XmlNavigatorUtils.getAttributeValue("", "includesSyns", xMLNode));
    }

    public String getType() {
        return this.m_type;
    }

    public String getDBType() {
        return this.m_dbType;
    }

    public double getWeight() {
        return this.m_weight;
    }

    public DatabaseFolder[] getFolders() {
        return this.m_folders.toArray(new XmlFolderImpl[0]);
    }

    NavigatorDescriptor getNavigatorDescriptor() {
        return this.m_desc;
    }

    private void initFolders() {
        if (this.m_folders == null) {
            this.m_folders = new ArrayList<XmlFolderImpl>();
            for (XMLNode xMLNode : XmlNavigatorUtils.getElements("folder", this.m_node)) {
                this.m_folders.add(new XmlFolderImpl(this, this.m_desc, xMLNode));
            }
        }
    }

    public DatabaseObject getNode() {
        return this.m_nodeImpl;
    }

    private void initNode() {
        XMLNode xMLNode = XmlNavigatorUtils.getSingleElement("node", this.m_node);
        if (xMLNode != null) {
            XmlNodeImpl xmlNodeImpl = new XmlNodeImpl(this, this.m_desc, xMLNode);
            Class clazz = xmlNodeImpl.getDBObjectImplementationClass();
            if (clazz != null) {
                assert (AbstractNodeImpl.class.isAssignableFrom(clazz));
                try {
                    AbstractNodeImpl abstractNodeImpl = (AbstractNodeImpl)clazz.newInstance();
                    abstractNodeImpl.setItemDelegate(xmlNodeImpl);
                    this.m_nodeImpl = abstractNodeImpl;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.m_nodeImpl = xmlNodeImpl;
                }
            } else {
                this.m_nodeImpl = xmlNodeImpl;
            }
        }
    }

    boolean isIncludesSynonyms() {
        return this.m_includesSyns;
    }
}

