/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.folding;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.editor.language.NumberRange;

public class PlSqlFoldingModel
extends DefaultCodeFoldingModel
implements ParserEventListener {
    BackgroundParser parser;
    final int basic_decl_item = BackgroundParser.translateSymbol("basic_decl_item");
    final int compilation = BackgroundParser.translateSymbol("compilation_unit");
    final int body = BackgroundParser.translateSymbol("body");
    final int stmt = BackgroundParser.translateSymbol("stmt");

    public PlSqlFoldingModel(BasicDocument basicDocument, BackgroundParser backgroundParser) {
        super(basicDocument);
        this.parser = backgroundParser;
        this.parser.addParserEventListener(this);
        BasicDocument basicDocument2 = this.getDocument();
        TextBuffer textBuffer = basicDocument2.getTextBuffer();
        textBuffer.readLock();
        this.setRoot(new TypedFoldingBlock(0, textBuffer.getLength(), "", -1));
        textBuffer.readUnlock();
    }

    public void reload(int n, int n2) {
        if (this.parser.output == null) {
            return;
        }
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        PlSqlFoldingModel.updateFoldingBlock(typedFoldingBlock, n, n2);
        super.reload();
    }

    public static void updateFoldingBlock(TypedFoldingBlock typedFoldingBlock, int n, int n2) {
        if (typedFoldingBlock.getStartOffset() >= n) {
            typedFoldingBlock.setStartOffset(typedFoldingBlock.getStartOffset() + n2);
        }
        if (typedFoldingBlock.getEndOffset() >= n) {
            typedFoldingBlock.setEndOffset(typedFoldingBlock.getEndOffset() + n2);
        }
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock2 = (TypedFoldingBlock)iterator.next();
            PlSqlFoldingModel.updateFoldingBlock(typedFoldingBlock2, n, n2);
        }
    }

    void walkParseTree(String string, LineMap lineMap, ParseNode parseNode, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2) {
        int n;
        TypedFoldingBlock typedFoldingBlock3 = typedFoldingBlock;
        int n2 = -1;
        if (parseNode == null) {
            return;
        }
        Object object = parseNode.content().iterator();
        while (object.hasNext()) {
            n = object.next();
            if (n == this.basic_decl_item) {
                n2 = n;
                continue;
            }
            if (n == this.compilation) {
                n2 = n;
                continue;
            }
            if (n == this.body) {
                n2 = n;
                continue;
            }
            if (n != this.stmt) continue;
            n2 = n;
        }
        if (n2 >= 0) {
            int n3;
            object = this.parser.src.get(parseNode.from);
            int n4 = n = ((LexerToken)object).begin;
            object = this.parser.src.get(parseNode.to - 1);
            int n5 = n3 = ((LexerToken)object).end;
            for (NumberRange numberRange : this.parser.increments) {
                if (n4 >= numberRange.start) {
                    n4 += numberRange.end - numberRange.start;
                }
                if (n5 < numberRange.start) continue;
                n5 += numberRange.end - numberRange.start;
            }
            int n6 = this.lineDiff(lineMap, n4, n5);
            if (n6 > 2) {
                TypedFoldingBlock typedFoldingBlock4;
                object = this.parser.src.get(parseNode.from + 1);
                int n7 = ((LexerToken)object).end;
                typedFoldingBlock3 = new TypedFoldingBlock(n4, n5, string.substring(n, n7) + "...", n2);
                typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
                if (typedFoldingBlock2 != null && (typedFoldingBlock4 = PlSqlFoldingModel.searchShiftedBlock(typedFoldingBlock2, typedFoldingBlock3, n4 - n)) != null) {
                    typedFoldingBlock3.setExpanded(typedFoldingBlock4.isExpanded());
                }
            }
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            this.walkParseTree(string, lineMap, parseNode2, typedFoldingBlock3, typedFoldingBlock2);
        }
    }

    void foldComments(String string, LineMap lineMap, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2) {
        TypedFoldingBlock typedFoldingBlock3 = typedFoldingBlock;
        int n = 0;
        for (LexerToken lexerToken : this.parser.src) {
            int n2;
            Object object2;
            int n3;
            if (lexerToken.begin < n + 30) {
                n = lexerToken.end;
                continue;
            }
            int n4 = n3 = n;
            int n5 = lexerToken.begin;
            for (NumberRange numberRange : this.parser.increments) {
                if (n4 >= numberRange.start) {
                    n4 += numberRange.end - numberRange.start;
                }
                if (n5 < numberRange.start) continue;
                n5 += numberRange.end - numberRange.start;
            }
            n = lexerToken.end;
            String string2 = string.substring(n4, n5);
            LinkedList<LexerToken> object22 = LexerToken.parse(string2, true);
            LexerToken lexerToken2 = null;
            LexerToken lexerToken3 = null;
            for (Object object2 : object22) {
                int n6;
                int n7;
                if (((LexerToken)object2).type != Token.COMMENT && ((LexerToken)object2).type != Token.LINE_COMMENT) continue;
                lexerToken3 = object2;
                if (lexerToken2 != null || (n7 = lineMap.getLineStartOffset(n6 = lineMap.getLineFromOffset(n4 + ((LexerToken)object2).begin))) != n4 + ((LexerToken)object2).begin) continue;
                lexerToken2 = object2;
            }
            if (lexerToken2 == null || (n2 = this.lineDiff(lineMap, n4 += lexerToken2.begin, n5 = n4 + lexerToken3.end)) <= 2) continue;
            typedFoldingBlock3 = new TypedFoldingBlock(n4, n5, lexerToken2.content, -1000);
            typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
            if (typedFoldingBlock2 == null || (object2 = PlSqlFoldingModel.searchShiftedBlock(typedFoldingBlock2, typedFoldingBlock3, n4 - n3)) == null) continue;
            typedFoldingBlock3.setExpanded(object2.isExpanded());
        }
    }

    private int lineDiff(LineMap lineMap, int n, int n2) {
        int n3 = lineMap.getLineFromOffset(n);
        int n4 = lineMap.getLineFromOffset(n2);
        return n4 - n3;
    }

    public static void print(DefaultFoldingBlock defaultFoldingBlock, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println("[" + defaultFoldingBlock.getStartOffset() + "," + defaultFoldingBlock.getEndOffset() + ") " + defaultFoldingBlock.getClass().getName());
        Iterator iterator = defaultFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            PlSqlFoldingModel.print((TypedFoldingBlock)iterator.next(), n + 1);
        }
    }

    public static boolean isShifted(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == n && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == n) {
            return true;
        }
        return typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == 0 && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == 0;
    }

    public static TypedFoldingBlock searchShiftedBlock(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (PlSqlFoldingModel.isShifted(typedFoldingBlock, typedFoldingBlock2, n)) {
            return typedFoldingBlock;
        }
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock3 = (TypedFoldingBlock)iterator.next();
            TypedFoldingBlock typedFoldingBlock4 = PlSqlFoldingModel.searchShiftedBlock(typedFoldingBlock3, typedFoldingBlock2, n);
            if (typedFoldingBlock4 == null) continue;
            return typedFoldingBlock4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(BackgroundParser backgroundParser) {
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        TypedFoldingBlock typedFoldingBlock2 = new TypedFoldingBlock(0, this.parser.text != null ? this.parser.text.length() : 0, "", -1);
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.readLock();
        LineMap lineMap = null;
        try {
            try {
                lineMap = textBuffer.getLineMap();
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                Object var9_8 = null;
                textBuffer.readUnlock();
                return;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            textBuffer.readUnlock();
            throw throwable;
        }
        textBuffer.readUnlock();
        this.walkParseTree(this.parser.text, lineMap, this.parser.output, typedFoldingBlock2, typedFoldingBlock);
        this.setRoot(typedFoldingBlock2);
        PlSqlFoldingModel.super.reload();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypedFoldingBlock
    extends DefaultFoldingBlock
    implements Comparable {
        int type;

        public TypedFoldingBlock(int n, int n2, String string, int n3) {
            super(n, n2, string, true);
            this.type = n3;
        }

        public TypedFoldingBlock(int n, int n2, String string, boolean bl, int n3) {
            super(n, n2, string, bl);
            this.type = n3;
        }

        public List<TypedFoldingBlock> descendants() {
            LinkedList<TypedFoldingBlock> linkedList = new LinkedList<TypedFoldingBlock>();
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)iterator.next();
                linkedList.addAll(typedFoldingBlock.descendants());
            }
            linkedList.add(this);
            return linkedList;
        }

        public String toString() {
            return "[" + this.getStartOffset() + "," + this.getEndOffset() + ") " + this.getReplacementText();
        }

        public int compareTo(Object object) {
            TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)object;
            if (this.getStartOffset() != typedFoldingBlock.getStartOffset()) {
                return this.getStartOffset() - typedFoldingBlock.getStartOffset();
            }
            if (this.getStartOffset() != typedFoldingBlock.getStartOffset()) {
                return this.getEndOffset() - typedFoldingBlock.getEndOffset();
            }
            return 0;
        }
    }
}

