/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.util.LinkedList;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.ide.Context;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;

public class CaseConverter {
    private CASE state = CASE.UPPER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean convert(Context context) {
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode) {
            TextNode textNode = (TextNode)node;
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            if (textBuffer.getLength() == 0) {
                return false;
            }
            BasicEditorPane basicEditorPane = (BasicEditorPane)view.getGUI();
            int n = basicEditorPane.getSelectionStart();
            int n2 = basicEditorPane.getSelectionEnd();
            if (n2 == 0 || n == n2) {
                return false;
            }
            if (!textBuffer.tryWriteLock()) {
                return false;
            }
            try {
                String string = textBuffer.getString(n, n2 - n);
                string = this.state.convert(string);
                textBuffer.remove(n, n2 - n);
                textBuffer.insert(n, string.toCharArray());
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                textBuffer.writeUnlock();
                throw throwable;
            }
            textBuffer.writeUnlock();
            textNode.markDirty(true);
            textNode.releaseTextBuffer();
            basicEditorPane.setSelectionStart(n);
            basicEditorPane.setSelectionEnd(n2);
        } else if (view instanceof FindableEditor) {
            BasicEditorPane basicEditorPane = ((FindableEditor)view).getFocusedEditorPane();
            int n = basicEditorPane.getSelectionStart();
            int n3 = basicEditorPane.getSelectionEnd();
            if (n3 == 0 || n == n3) {
                return false;
            }
            try {
                String string = basicEditorPane.getText(n, n3 - n);
                string = this.state.convert(string);
                basicEditorPane.replaceSelection(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            basicEditorPane.setSelectionStart(n);
            basicEditorPane.setSelectionEnd(n3);
        }
        this.state = this.state.rotate();
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CASE {
        UPPER{

            String convert(String string) {
                LinkedList<LexerToken> linkedList = LexerToken.parse(string, true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : linkedList) {
                    if (lexerToken.type == Token.IDENTIFIER) {
                        String string2 = lexerToken.content.toUpperCase();
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            CASE rotate() {
                return LOWER;
            }
        }
        ,
        LOWER{

            String convert(String string) {
                LinkedList<LexerToken> linkedList = LexerToken.parse(string, true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : linkedList) {
                    if (lexerToken.type == Token.IDENTIFIER) {
                        String string2 = lexerToken.content.toLowerCase();
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            CASE rotate() {
                return INITCAP;
            }
        }
        ,
        INITCAP{

            String convert(String string) {
                LinkedList<LexerToken> linkedList = LexerToken.parse(string, true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : linkedList) {
                    if (lexerToken.type == Token.IDENTIFIER) {
                        String string2 = lexerToken.content.substring(0, 1).toUpperCase() + lexerToken.content.substring(1).toLowerCase();
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            CASE rotate() {
                return UPPER;
            }
        };


        abstract String convert(String var1);

        abstract CASE rotate();
    }
}

