/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.dbtools.raptor.refactor.ProcedureExtractor;
import oracle.dbtools.raptor.refactor.Renamer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class RefactorMenu
implements Controller,
ContextMenuListener {
    private static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/refactor/accelerators.xml";
    private static RefactorMenu _instance;
    public static String UPPER_LOWER_INITCAP;
    public static String EXTRACT_PROCEDURE;
    public static String RENAME;
    private static int _cmdULI;
    private static int _cmdEP;
    private static int _cmdRN;
    private IdeAction actionUpperLowerInitcap = null;
    private IdeAction actionExtractProcedure = null;
    private IdeAction actionRename = null;
    private static JMenu menuRefactor;
    private CaseConverter caseConverter = new CaseConverter();
    private ProcedureExtractor procExtractor = new ProcedureExtractor();
    private Renamer renamer = new Renamer();

    public static RefactorMenu getInstance() {
        if (_instance == null) {
            _instance = new RefactorMenu();
        }
        return _instance;
    }

    public void initAction() {
        String string = UPPER_LOWER_INITCAP;
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionUpperLowerInitcap == null) {
            this.actionUpperLowerInitcap = IdeAction.get((int)_cmdULI, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionUpperLowerInitcap.setEnabled(true);
        }
        string = EXTRACT_PROCEDURE;
        string2 = StringUtils.stripMnemonic((String)string);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionExtractProcedure == null) {
            this.actionExtractProcedure = IdeAction.get((int)_cmdEP, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionExtractProcedure.setEnabled(true);
        }
        string = RENAME;
        string2 = StringUtils.stripMnemonic((String)string);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionRename == null) {
            this.actionRename = IdeAction.get((int)_cmdRN, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionRename.setEnabled(true);
        }
    }

    public static void init() {
        RefactorMenu.getInstance().initAction();
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)RefactorMenu.getInstance());
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(RefactorMenu.getInstance().getClass().getClassLoader(), ACCELERATOR_FILE);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (_cmdULI == n) {
            this.caseConverter.convert(context);
            return true;
        }
        if (_cmdEP == n) {
            this.procExtractor.extract(context);
            return true;
        }
        if (_cmdRN == n) {
            this.renamer.rename(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
        if (context == null) {
            return;
        }
        if (RefactorMenu.isMenuAvailable(context)) {
            String string = "Refactoring";
            menuRefactor = contextMenu.createMenu(string, Integer.valueOf(StringUtils.getMnemonicKeyCode((String)string)));
            menuRefactor.add(contextMenu.createMenuItem((ToggleAction)this.actionUpperLowerInitcap));
            menuRefactor.add(contextMenu.createMenuItem((ToggleAction)this.actionExtractProcedure));
            menuRefactor.add(contextMenu.createMenuItem((ToggleAction)this.actionRename));
            menuRefactor.setSelected(false);
            this.actionUpperLowerInitcap.addController((Controller)this);
            this.actionUpperLowerInitcap.setEnabled(true);
            this.actionExtractProcedure.addController((Controller)this);
            this.actionExtractProcedure.setEnabled(true);
            this.actionRename.addController((Controller)this);
            this.actionRename.setEnabled(true);
            contextMenu.add((Component)menuRefactor);
        }
    }

    private static boolean isMenuAvailable(Context context) {
        Node node = context.getNode();
        View view = context.getView();
        return (node.getClass().getName().endsWith("sqlview.SqlEditorNode") || node.getClass().getName().endsWith("PlSqlNode") || node.getClass().getName().endsWith("PlSqlBaseNode") || node.getClass().getName().endsWith("TriggerNode") || view.getClass().getName().endsWith("SqlEditor")) && context.getEvent().getSource() instanceof JTextComponent;
    }

    static {
        UPPER_LOWER_INITCAP = "To Upper/Lower/Initcap";
        EXTRACT_PROCEDURE = "Extract Procedure...";
        RENAME = "Rename Local Variable...";
        _cmdULI = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.CASE_ID");
        _cmdEP = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.EXTR_PROC_ID");
        _cmdRN = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.RENAME_ID");
        menuRefactor = null;
    }
}

