/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.insight.IdentifiersDb;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.ParseRunnable;
import oracle.dbtools.util.Util;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class Renamer {
    List<LexerToken> src;
    ParseNode root;
    int offset;
    String newName;
    BasicEditorPane p;

    public boolean rename(Context context) {
        Object object;
        Node node = context.getNode();
        View view = context.getView();
        this.p = null;
        this.newName = null;
        if (node instanceof PlSqlNode) {
            this.p = (BasicEditorPane)view.getGUI();
            PlSqlNode plSqlNode = (PlSqlNode)node;
            this.src = plSqlNode.parser.src;
        } else if (view instanceof FindableEditor) {
            this.p = ((FindableEditor)view).getFocusedEditorPane();
            try {
                this.src = LexerToken.parse(this.p.getText(0, this.p.getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)badLocationException.getMessage(), null, null);
                return false;
            }
            if (this.src.size() > 32766) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Source is bigger than 32766 tokens. Good luck", null, null);
                return false;
            }
        }
        int n = this.p.getCaretPosition();
        this.offset = -1;
        for (LexerToken lexerToken : this.src) {
            ++this.offset;
            if (lexerToken.begin > n) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"No identifier selected", null, null);
                return false;
            }
            if (lexerToken.begin > n || n > lexerToken.end) continue;
            if (lexerToken.type == Token.IDENTIFIER) break;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"The selected token is not an identifier", null, null);
            return false;
        }
        this.newName = this.askForNewName(this.src.get((int)this.offset).content);
        if (this.newName == null) {
            return false;
        }
        if (node instanceof PlSqlNode) {
            object = (PlSqlNode)node;
            this.root = ((PlSqlNode)object).parser.output;
            if (((PlSqlNode)object).parser.isParsing) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Parser is busy", null, null);
                return false;
            }
            if (this.root == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Internal error: root==null", null, null);
                return false;
            }
        } else if (view instanceof FindableEditor) {
            try {
                object = new ParseRunnable(){

                    void finish() {
                        Renamer.this.finishRename();
                    }

                    void outputRoot(ParseNode parseNode) {
                        Renamer.this.root = parseNode;
                    }
                };
                ((ParseRunnable)((Object)object)).src = this.src;
                object.start(true);
                return true;
            }
            catch (ProgressException progressException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)progressException.getMessage(), null, null);
                return false;
            }
        }
        this.finishRename();
        return true;
    }

    private String askForNewName(String string) {
        JPanel jPanel = new JPanel(new FlowLayout());
        JTextField jTextField = new JTextField(30);
        jPanel.add(new JLabel("New Name:"));
        jPanel.add(jTextField);
        if (!OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)("Rename Local Variable " + string))) {
            return null;
        }
        return jTextField.getText();
    }

    void finishRename() {
        String string = this.src.get((int)this.offset).content;
        int n = this.newName.length() - string.length();
        Map<ParseNode, Integer> map = IdentifiersDb.instance.collectIdentifiers(this.root);
        for (ParseNode parseNode : map.keySet()) {
            Integer n2;
            if (!this.src.get((int)(parseNode.to - 1)).content.equals(string) || Util.X((int)(n2 = map.get(parseNode))) > this.offset || this.offset >= Util.Y((int)n2)) continue;
            int n3 = 0;
            for (int i = Util.X((int)n2); i < Util.Y((int)n2); ++i) {
                if (!this.src.get((int)i).content.equals(string)) continue;
                this.p.setSelectionStart(this.src.get((int)i).begin + n3 * n);
                this.p.setSelectionEnd(this.src.get((int)i).end + n3 * n);
                this.p.replaceSelection(this.newName);
                ++n3;
            }
            return;
        }
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(string + " appears to be not a local variable"), null, null);
    }
}

