/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class CopyWizDBSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton jBCreate = new JRadioButton();
    private JRadioButton jBTruncate = new JRadioButton();
    private JRadioButton jBDrop = new JRadioButton();
    private OracleConnectionComboBox sourceConnSelector = new OracleConnectionComboBox();
    private OracleConnectionComboBox destConnSelector = new OracleConnectionComboBox();

    public CopyWizDBSelector() {
        this.sourceConnSelector.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    CopyWizDBSelector.this.sourceConnSelector.getCurrentDatabase();
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    CopyWizDBSelector.this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Exception)exception2);
                }
            }
        });
        this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
        this.destConnSelector.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    CopyWizDBSelector.this.destConnSelector.getCurrentDatabase();
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    CopyWizDBSelector.this.destConnSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Exception)exception2);
                }
            }
        });
        this.destConnSelector.getJComboBox().setSelectedIndex(-1);
        this.jBCreate.setText(CopyPanelArb.getString(10));
        this.jBCreate.setMnemonic('C');
        this.jBCreate.setSelected(true);
        this.jBDrop.setText(CopyPanelArb.getString(9));
        this.jBDrop.setMnemonic('D');
        this.jBTruncate.setText(CopyPanelArb.getString(11));
        this.jBTruncate.setMnemonic('T');
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jBCreate);
        buttonGroup.add(this.jBTruncate);
        buttonGroup.add(this.jBDrop);
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(CopyWizArb.getString(0));
        jLabel.setDisplayedMnemonic('S');
        jLabel.setLabelFor(this.sourceConnSelector.getJComboBox());
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.sourceConnSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        JLabel jLabel2 = new JLabel(CopyWizArb.getString(1));
        jLabel2.setDisplayedMnemonic('e');
        jLabel2.setLabelFor(this.destConnSelector.getJComboBox());
        this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.destConnSelector.getJComboBox(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jBCreate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 0), 0, 0));
        this.add(this.jBTruncate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jBDrop, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getAction() {
        if (this.jBTruncate.isSelected()) {
            return "TRUNC";
        }
        if (this.jBDrop.isSelected()) {
            return "DROP";
        }
        return "CREATE";
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        try {
            if (this.sourceConnSelector.getCurrentDatabase() == null) {
                throw new TraversalException(CopyWizArb.getString(2));
            }
        }
        catch (DBException dBException) {
            this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            throw new TraversalException(CopyWizArb.getString(2));
        }
        try {
            if (this.destConnSelector.getCurrentDatabase() == null) {
                throw new TraversalException(CopyWizArb.getString(3));
            }
        }
        catch (DBException dBException) {
            this.destConnSelector.getJComboBox().setSelectedIndex(-1);
            throw new TraversalException(CopyWizArb.getString(3));
        }
        try {
            if (this.sourceConnSelector.getCurrentDatabase() == this.destConnSelector.getCurrentDatabase()) {
                throw new TraversalException(CopyWizArb.getString(4));
            }
        }
        catch (DBException dBException) {
            this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            throw new TraversalException(CopyWizArb.getString(5));
        }
        traversableContext.put("SOURCE_CONNECTION", (Object)this.sourceConnSelector.getCurrentConnection());
        traversableContext.put("SOURCE_CONNECTION_NAME", (Object)this.sourceConnSelector.getCurrentConnectionName());
        traversableContext.put("DEST_CONNECTION", (Object)this.destConnSelector.getCurrentConnection());
        traversableContext.put("DEST_CONNECTION_NAME", (Object)this.destConnSelector.getCurrentConnectionName());
        traversableContext.put("COPY_ACTION", (Object)this.getAction());
    }

    public Object getExitTransition() {
        return "Fin";
    }
}

