/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.InputStream;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractFolderedXml {
    private Logger logger = Logger.getLogger(AbstractFolderedXml.class.getName());
    private XMLDocument _document;

    public abstract void openFolder(String var1, String var2, String var3, Node var4);

    public abstract void closeFolder();

    public abstract void newItem(Node var1);

    public void newNode(Node node) {
    }

    private void processFolder(Node node) {
        String string = XMLHelper.getNodeValue((Node)node, (String)"name");
        String string2 = XMLHelper.getNodeValue((Node)node, (String)"description");
        String string3 = XMLHelper.getNodeValue((Node)node, (String)"tip");
        this.openFolder(string, string2, string3, node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string4 = node2.getNodeName();
            if (string4.equalsIgnoreCase("folder")) {
                this.processFolder(node2);
                continue;
            }
            if (string4.equalsIgnoreCase("item")) {
                this.newItem(node2);
                continue;
            }
            if (string4.equalsIgnoreCase("description") || string4.equalsIgnoreCase("name") || string4 == null) continue;
            this.logger.finer("Folder:Unsupported node in xml:" + string4);
        }
    }

    private void processNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("folder")) {
                this.processFolder(node2);
                this.closeFolder();
                continue;
            }
            if (string.equalsIgnoreCase("item")) {
                this.newItem(node2);
                continue;
            }
            if (string.equalsIgnoreCase("#comment")) continue;
            this.newNode(node2);
        }
    }

    public void processXML(InputStream inputStream) throws Exception {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        dOMParser.parse(inputStream);
        this._document = dOMParser.getDocument();
        NodeList nodeList = this._document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.processNode(nodeList.item(i));
        }
    }

    public Document getDocument() {
        return this._document;
    }

    public static void main(String[] stringArray) {
    }
}

