/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.dbtools.raptor.utils.Translate;
import oracle.javatools.db.DBException;

public class ClosedConnectionListener
implements SQLExceptionListener {
    public boolean handleSQLError(final String string, final SQLException sQLException) {
        int n = sQLException.getErrorCode();
        switch (n) {
            case 1012: 
            case 2396: 
            case 2399: 
            case 17008: {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ClosedConnectionListener.this.reconnect(string, sQLException);
                    }
                });
                return true;
            }
        }
        return false;
    }

    public void reconnect(String string, SQLException sQLException) {
        String string2 = "ORA-" + sQLException.getErrorCode() + Translate.translate((String)": Want to Reconnect?");
        Connection connection = null;
        if (ExceptionHandler.handleExceptionWithAction((Exception)sQLException, (String)string2, (String)Translate.translate((String)"Reconnect"), null)) {
            Connections.getInstance().closeConnection(string);
            try {
                connection = Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
    }
}

