/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.CanceledException;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.StoreListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connections
implements ConnectionResolver {
    private static Connections s_connections;
    private Map<Connection, ReentrantLock> m_locks = new HashMap<Connection, ReentrantLock>();
    private static Logger logger;
    private Map<Connection, Map<String, Object>> m_connProperties = new HashMap<Connection, Map<String, Object>>();
    private static final Object LOCK;
    public static final String DBNAME_KEY = "Connections.db_name";
    private CopyOnWriteArrayList<ConnectionListener> m_listeners;
    private DatabaseConnectionStores m_dbStores = DatabaseConnectionStores.getInstance();
    private Map<String, L> m_stores = new HashMap<String, L>();
    private Map<ConnectionKey, ConnectionInfo> m_conns;
    private static final Pattern SERVICE_FORMAT;
    private static final Pattern SID_FORMAT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connections getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (s_connections == null) {
                s_connections = new Connections();
            }
        }
        return s_connections;
    }

    private Connections() {
    }

    public static String getStoreName(String string) {
        return ConnectionKey.createConnectionKey(string).getStoreName();
    }

    public static String getConnectionName(String string) {
        return ConnectionKey.createConnectionKey(string).getConnectionName();
    }

    public static String getDisplayName(String string) {
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        String string2 = connectionKey.getStoreName();
        return !ModelUtil.hasLength((String)string2) || "IdeConnections".equals(string2) ? connectionKey.getConnectionName() : MessageFormat.format(UtilsResources.get("QUALIFIED_CONN_NAME_FORMAT"), connectionKey.getConnectionName(), DatabaseConnectionStores.getInstance().getShortLabel(string2));
    }

    private synchronized Map<ConnectionKey, ConnectionInfo> getConnections() {
        if (this.m_conns == null) {
            this.m_conns = new HashMap<ConnectionKey, ConnectionInfo>();
            for (String string : this.m_dbStores.listStores()) {
                this.registerConnectionStore(string);
            }
            this.m_dbStores.addStoreListener(new StoreListener(){

                public void storeAdded(String string) {
                    Connections.this.registerConnectionStore(string);
                }

                public void storeRemoved(String string) {
                    Connections.this.unregisterConnectionStore(string);
                }
            });
        }
        return this.m_conns;
    }

    private void registerConnectionStore(String string) {
        long l = System.currentTimeMillis();
        DatabaseConnections databaseConnections = this.m_dbStores.getStore(string);
        L l2 = new L(string, databaseConnections);
        l2.register();
        this.m_stores.put(string, l2);
        Collection collection = databaseConnections.listConnections();
        logger.info("CA took:" + (System.currentTimeMillis() - l));
        for (String string2 : databaseConnections.listConnections()) {
            ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string, string2);
            this.m_conns.put(connectionKey, new ConnectionInfo(connectionKey, databaseConnections));
            this.fireConnectionEvent(new ConnectionEvent(2, connectionKey.getQualifiedName()), true);
        }
    }

    private void unregisterConnectionStore(String string) {
        Set<ConnectionKey> set = this.m_conns.keySet();
        Object object = set.iterator();
        while (object.hasNext()) {
            ConnectionKey connectionKey = object.next();
            if (!ModelUtil.areEqual((Object)string, (Object)connectionKey.getStoreName())) continue;
            object.remove();
            this.fireConnectionEvent(new ConnectionEvent(3, connectionKey.getQualifiedName()), true);
        }
        object = this.m_stores.remove(string);
        if (object != null) {
            ((L)object).unregister();
        }
    }

    public ReentrantLock getLock(Connection connection) {
        if (this.m_locks.get(connection) == null) {
            this.m_locks.put(connection, new ReentrantLock());
        }
        return this.m_locks.get(connection);
    }

    public ReentrantLock getLock(String string) {
        try {
            return this.getLock(s_connections.getConnection(string));
        }
        catch (DBException dBException) {
            logger.severe("Could not get connection");
            return null;
        }
    }

    public void unlock(String string) {
        ReentrantLock reentrantLock = this.getLock(string);
        this.unlock(reentrantLock);
    }

    private void unlock(ReentrantLock reentrantLock) {
        if (reentrantLock.isHeldByCurrentThread()) {
            reentrantLock.unlock();
        } else {
            logger.info("Trying to unlock another thread's lock");
        }
    }

    public void unlock(Connection connection) {
        ReentrantLock reentrantLock = this.getLock(connection);
        reentrantLock.unlock();
    }

    public boolean lock(String string) {
        ReentrantLock reentrantLock = this.getLock(string);
        return this.lock(reentrantLock);
    }

    public boolean lock(Connection connection) {
        ReentrantLock reentrantLock = this.getLock(connection);
        return this.lock(reentrantLock);
    }

    private boolean lock(ReentrantLock reentrantLock) {
        boolean bl = false;
        do {
            try {
                if (!reentrantLock.tryLock(500L, TimeUnit.MILLISECONDS)) continue;
                bl = true;
                break;
            }
            catch (InterruptedException interruptedException) {
                logger.fine("Interrupted while trying to get a lock");
            }
        } while (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)"Connection currrently busy.  Try again?", (String)"Connection busy", null, (boolean)false, (String)"Try Again", (String)"Abort"));
        return bl;
    }

    public void closeConnection(String string) {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        if (connectionInfo != null) {
            connectionInfo.closeConnection();
        }
    }

    private ConnectionInfo findConnectionInfo(String string) {
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        return connectionKey != null ? this.getConnections().get(connectionKey) : null;
    }

    public Database getDatabase(Connection connection, boolean bl) {
        Database database = null;
        for (ConnectionInfo connectionInfo : this.getConnections().values()) {
            try {
                Database database2 = connectionInfo.getDatabase(false);
                if (database2 == null || connection != database2.getConnection()) continue;
                database = database2;
                break;
            }
            catch (DBException dBException) {
            }
        }
        if (database == null && bl) {
            try {
                database = DatabaseFactory.findOrCreateDatabase(null, (Connection)connection);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return database;
    }

    public Database getDatabase(Connection connection) {
        return this.getDatabase(connection, true);
    }

    public Database getDatabase(String string) throws DBException {
        return this.getDatabase(string, true);
    }

    public Database getDatabase(String string, boolean bl) throws DBException {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        return connectionInfo != null ? connectionInfo.getDatabase(bl) : null;
    }

    public Connection getConnection(String string) throws DBException {
        Connection connection = this.getConnection(string, false);
        if (connection == null) {
            connection = this.getConnection(string, true);
        }
        if (connection == null) {
            return null;
        }
        if (!this.lock(connection)) {
            throw new CanceledException();
        }
        this.unlock(connection);
        return connection;
    }

    Connection getConnection(String string, boolean bl) throws DBException {
        Database database;
        Connection connection = null;
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        if (connectionInfo != null && (database = connectionInfo.getDatabase(bl)) != null) {
            connection = database.getConnection(bl);
        }
        return connection;
    }

    public Connection getUniqueConnection(String string) throws ConnectionException {
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        DatabaseConnections databaseConnections = this.m_dbStores.getStore(connectionKey.getStoreName());
        return databaseConnections != null ? databaseConnections.getUniqueConnection(connectionKey.getConnectionName()) : null;
    }

    public Connection cloneConnection(Connection connection) throws ConnectionException {
        Connection connection2 = null;
        String string = this.getConnectionName(connection);
        if (string != null) {
            connection2 = this.getUniqueConnection(string);
        }
        return connection2;
    }

    public Connection cloneConnection(String string) throws ConnectionException {
        Connection connection = null;
        if (string != null) {
            connection = this.getUniqueConnection(string);
        }
        return connection;
    }

    public boolean isOracle(Connection connection) {
        return connection instanceof OracleConnection;
    }

    public boolean isTimesTen(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            if (string.indexOf("TimesTen") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isOracle(String string) {
        if (string != null) {
            DatabaseConnections databaseConnections;
            ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
            String string2 = connectionKey.getStoreName();
            if (!ModelUtil.hasLength((String)string2)) {
                string2 = "IdeConnections";
            }
            if ((databaseConnections = this.m_dbStores.getStore(string2)) != null) {
                return databaseConnections.listConnections(true).contains(connectionKey.getConnectionName());
            }
        }
        return false;
    }

    public boolean isAccess(String string) {
        Properties properties;
        boolean bl = false;
        if (string != null && (properties = this.getConnectionInfo(string)) != null) {
            String string2 = properties.getProperty("driver");
            bl = ModelUtil.areEqual((Object)string2, (Object)"sun.jdbc.odbc.JdbcOdbcDriver");
        }
        return bl;
    }

    public boolean isTimesTen(String string) {
        Properties properties;
        boolean bl = false;
        if (string != null && (properties = this.getConnectionInfo(string)) != null) {
            String string2 = properties.getProperty("driver");
            bl = ModelUtil.areEqual((Object)string2, (Object)"com.timesten.jdbc.TimesTenDriver") || ModelUtil.areEqual((Object)string2, (Object)"com.timesten.jdbc.TimesTenClientDriver");
        }
        return bl;
    }

    public boolean isConnectionOpen(String string) {
        boolean bl = false;
        try {
            ConnectionInfo connectionInfo = this.findConnectionInfo(string);
            bl = connectionInfo != null && connectionInfo.getDatabase(false) != null;
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return bl;
    }

    public Properties getConnectionInfo(String string) {
        ConnectionKey connectionKey = new ConnectionKey(string);
        return this.getConnectionInfo(connectionKey);
    }

    public Properties getConnectionInfo(String string, String string2) {
        return this.getConnectionInfo(ConnectionKey.createConnectionKey(string, string2));
    }

    private Properties getConnectionInfo(ConnectionKey connectionKey) {
        ConnectionInfo connectionInfo = this.getConnections().get(connectionKey);
        if (connectionInfo != null) {
            return connectionInfo.getConnectionProperties();
        }
        return null;
    }

    public String getConnectionName(Connection connection) {
        String string = null;
        if (connection != null) {
            for (ConnectionInfo connectionInfo : this.getConnections().values()) {
                try {
                    Database database = connectionInfo.getDatabase(false);
                    if (database == null || database.getConnection(false) != connection) continue;
                    string = connectionInfo.m_key.getQualifiedName();
                    break;
                }
                catch (DBException dBException) {
                }
            }
        }
        return string;
    }

    public String getConnectionName(Database database) {
        String string = null;
        if (database != null) {
            for (ConnectionInfo connectionInfo : this.getConnections().values()) {
                try {
                    if (database != connectionInfo.getDatabase(false)) continue;
                    string = connectionInfo.m_key.getQualifiedName();
                    break;
                }
                catch (DBException dBException) {
                }
            }
        }
        return string;
    }

    public String[] getConnNames() {
        return this.getConnNames((NameFilter)null);
    }

    private String[] getConnNames(NameFilter nameFilter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<ConnectionKey, ConnectionInfo> map = this.getConnections();
        Set<ConnectionKey> set = map.keySet();
        for (ConnectionKey connectionKey : set) {
            if (nameFilter != null && !nameFilter.accept(connectionKey)) continue;
            arrayList.add(connectionKey.getQualifiedName());
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getConnNames(final String string) {
        return this.getConnNames(new NameFilter(){

            public boolean accept(ConnectionKey connectionKey) {
                return ModelUtil.areEqual((Object)connectionKey.getStoreName(), (Object)string);
            }
        });
    }

    public String[] getConnNames(final String[] stringArray) {
        NameFilter nameFilter = stringArray != null && stringArray.length > 0 ? new NameFilter(){

            public boolean accept(ConnectionKey connectionKey) {
                Properties properties = Connections.this.getConnectionInfo(connectionKey);
                return Arrays.binarySearch(stringArray, properties.getProperty("subtype")) >= 0;
            }
        } : null;
        return this.getConnNames(nameFilter);
    }

    public static String getConnName(URL uRL) {
        String string = "";
        if (uRL.getPath().indexOf("/") > 0) {
            string = uRL.getPath().substring(uRL.getPath().indexOf("/") + 1);
        }
        return string;
    }

    public Connection getTestConnection(String string) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        String string2 = System.getProperty("sdev.testConnectionFile");
        if (string2 == null && Connections.class.getResource("testConnections.xml") != null) {
            string2 = Connections.class.getResource("testConnections.xml").getFile();
        }
        if (string2 == null) {
            File file = new File(System.getProperty("user.home") + File.separator + "testConnections.xml");
            string2 = file.getAbsolutePath();
        }
        System.out.println("Using:" + string2);
        return null;
    }

    public ArrayList<String> getTestConnectionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("10.2");
        arrayList.add("9.2");
        arrayList.add("8");
        return arrayList;
    }

    public String resovleTNS2JDBCURL(String string) {
        String string2 = string;
        string2 = TNSHelper.getEntry((String)string).getJDBCUrl();
        return string2;
    }

    public static void safePropertySetter(Properties properties, String string, Object object) {
        if (object == null) {
            properties.remove(string);
        } else {
            properties.put(string, object);
        }
    }

    public static void populateConnectionInfo(Properties properties) {
        if (properties == null) {
            return;
        }
        String string = properties.getProperty("customUrl");
        if (ModelUtil.hasLength((String)string)) {
            if (!string.startsWith("jdbc")) {
                TCPTNSEntry tCPTNSEntry = TNSHelper.getEntry((String)string);
                if (tCPTNSEntry == null) {
                    return;
                }
                Connections.safePropertySetter(properties, "customUrl", tCPTNSEntry.getJDBCUrl());
                Connections.safePropertySetter(properties, "hostname", tCPTNSEntry.getHostname());
                Connections.safePropertySetter(properties, "port", tCPTNSEntry.getPortno());
                Connections.safePropertySetter(properties, "sid", tCPTNSEntry.getSid());
                Connections.safePropertySetter(properties, "serviceName", tCPTNSEntry.getServicename());
            } else {
                int n;
                String string2 = properties.getProperty("hostname");
                String string3 = properties.getProperty("sid");
                String string4 = properties.getProperty("serviceName");
                if ((!ModelUtil.hasLength((String)string2) || !ModelUtil.hasLength((String)string3) && !ModelUtil.hasLength((String)string4)) && string.startsWith("jdbc:oracle:") && (n = string.indexOf("@")) != -1) {
                    String string5 = string.substring(n + 1);
                    Matcher matcher = SERVICE_FORMAT.matcher(string5);
                    if (matcher.matches()) {
                        Connections.safePropertySetter(properties, "hostname", matcher.group(1));
                        Connections.safePropertySetter(properties, "port", matcher.group(2));
                        Connections.safePropertySetter(properties, "serviceName", matcher.group(3));
                    } else {
                        matcher = SID_FORMAT.matcher(string5);
                        if (matcher.matches()) {
                            Connections.safePropertySetter(properties, "hostname", matcher.group(1));
                            Connections.safePropertySetter(properties, "port", matcher.group(2));
                            Connections.safePropertySetter(properties, "sid", matcher.group(3));
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "select product,version from PRODUCT_COMPONENT_VERSION";
        Connection connection = Connections.getInstance().getTestConnection("8");
        ResultSet resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
        connection = Connections.getInstance().getTestConnection("9.2");
        resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
        connection = Connections.getInstance().getTestConnection("10.2");
        resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new CopyOnWriteArrayList();
        }
        this.m_listeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(connectionListener);
            if (this.m_listeners.size() == 0) {
                this.m_listeners = null;
            }
        }
    }

    private void fireConnectionEvent(final ConnectionEvent connectionEvent, boolean bl) {
        if (this.m_listeners != null) {
            connectionEvent.setSelectorOpened(ConnectionSelectorUI.SELECTOR_ACTIVE);
            Runnable runnable = new Runnable(){

                public void run() {
                    switch (connectionEvent.getID()) {
                        case 2: {
                            for (ConnectionListener connectionListener : Connections.this.m_listeners) {
                                connectionListener.connectionAdded(connectionEvent);
                            }
                            break;
                        }
                        case 3: {
                            for (ConnectionListener connectionListener : Connections.this.m_listeners) {
                                connectionListener.connectionRemoved(connectionEvent);
                            }
                            break;
                        }
                        case 5: {
                            for (ConnectionListener connectionListener : Connections.this.m_listeners) {
                                connectionListener.connectionModified(connectionEvent);
                            }
                            break;
                        }
                        case 0: {
                            for (ConnectionListener connectionListener : Connections.this.m_listeners) {
                                connectionListener.connectionOpened(connectionEvent);
                            }
                            break;
                        }
                        case 1: {
                            for (ConnectionListener connectionListener : Connections.this.m_listeners) {
                                connectionListener.connectionClosed(connectionEvent);
                            }
                            break;
                        }
                    }
                }
            };
            if (bl) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOCIDriverAvailable() {
        boolean bl = false;
        Connection connection = null;
        String string = "jdbc:oracle:oci:@localhost:1521:XE";
        try {
            connection = DriverManager.getConnection(string, "123", "123");
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(Connection connection, String string, Object object) {
        Map<Connection, Map<String, Object>> map = this.m_connProperties;
        synchronized (map) {
            if (this.m_connProperties.get(connection) == null) {
                this.m_connProperties.put(connection, new HashMap());
            }
            this.m_connProperties.get(connection).put(string, object);
        }
    }

    public Object getProperty(Connection connection, String string) {
        return this.m_connProperties.get(connection) != null ? this.m_connProperties.get(connection).get(string) : null;
    }

    public static boolean isUnsharedWorksheetConnection(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        return properties != null && Boolean.valueOf(properties.getProperty("MultipleUnsharedWorksheetConnection")) != false;
    }

    static {
        logger = Logger.getLogger(Connections.class.getName());
        LOCK = new Object();
        SERVICE_FORMAT = Pattern.compile("/*([^:]+):([^:]+)/([^:]+)");
        SID_FORMAT = Pattern.compile("([^:]+):([^:]+):([^:]+)");
    }

    private class ConnectionInfo {
        private ConnectionKey m_key;
        private Database m_db;
        private DatabaseConnections m_conns;
        private Properties m_props;

        ConnectionInfo(ConnectionKey connectionKey, DatabaseConnections databaseConnections) {
            this.m_key = connectionKey;
            this.m_conns = databaseConnections;
        }

        synchronized Database getDatabase(boolean bl) throws DBException {
            if (this.m_db == null && bl) {
                ConnectRunnable connectRunnable = new ConnectRunnable();
                connectRunnable.setTitle("Connecting to " + this.m_key.getConnectionName());
                try {
                    connectRunnable.start(true);
                }
                catch (ProgressException progressException) {
                    Throwable throwable = progressException.getCause();
                    if (throwable instanceof DBException) {
                        Throwable throwable2 = throwable.getCause();
                        if (!(throwable2 instanceof ConnectionCanceledException)) {
                            throw (DBException)throwable;
                        }
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
            }
            return this.m_db;
        }

        Database getDatabase() throws DBException {
            return this.getDatabase(true);
        }

        Properties getConnectionProperties() {
            if (this.m_props == null) {
                try {
                    this.m_props = this.m_conns.getProperties(this.m_key.getConnectionName());
                    Connections.populateConnectionInfo(this.m_props);
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
            return this.m_props;
        }

        void closeConnection() {
            boolean bl = false;
            if (this.m_db != null) {
                try {
                    bl = this.m_conns.disconnect(this.m_key.getConnectionName(), false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl) {
                    this.m_db = null;
                    Connections.this.fireConnectionEvent(new ConnectionEvent(1, this.m_key.getQualifiedName()), true);
                }
            }
            if (bl) {
                this.m_props = null;
            }
        }

        private class ConnectRunnable
        extends ProgressRunnable {
            boolean m_canceled;

            private ConnectRunnable() {
            }

            protected Object doWork() throws DBException {
                Connection connection;
                Database database;
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                if ((database = ConnectionInfo.this.m_conns.getDatabase(ConnectionInfo.this.m_key.getConnectionName())) != null && (connection = database.getConnection()) == null) {
                    return null;
                }
                return database;
            }

            protected void finish(Object object) {
                if (object instanceof Database) {
                    ConnectionInfo.this.m_db = (Database)object;
                    Connections.this.fireConnectionEvent(new ConnectionEvent(0, ConnectionInfo.this.m_key.getQualifiedName()), true);
                }
            }

            protected void doCancel() {
                super.doCancel();
                this.m_canceled = true;
            }

            boolean isCanceled() {
                return this.m_canceled;
            }
        }
    }

    private static interface NameFilter {
        public boolean accept(ConnectionKey var1);
    }

    public static class ConnectionKey {
        private String m_store;
        private String m_name;
        private String m_qual;

        public static ConnectionKey createConnectionKey(String string, String string2) {
            return string2 != null ? new ConnectionKey(string, string2) : null;
        }

        private static ConnectionKey createConnectionKey(String string) {
            return string != null ? new ConnectionKey(string) : null;
        }

        private ConnectionKey(String string, String string2) {
            this.m_store = ModelUtil.hasLength((String)string) ? string : null;
            this.m_name = string2;
            try {
                String string3 = this.m_store != null ? this.m_store + "#" + this.m_name : this.m_name;
                this.m_qual = URLEncoder.encode(string3, "utf-8");
            }
            catch (Exception exception) {
                logger.severe(exception.getMessage());
            }
        }

        private ConnectionKey(String string) {
            this.m_qual = string;
            try {
                String string2 = URLDecoder.decode(string, "utf-8");
                int n = string2.indexOf(35);
                if (n != -1) {
                    this.m_store = string2.substring(0, n);
                    this.m_name = string2.substring(n + 1);
                } else {
                    this.m_store = "";
                    this.m_name = string2;
                }
            }
            catch (Exception exception) {
                logger.severe(exception.getMessage());
            }
        }

        public String getQualifiedName() {
            return this.m_qual;
        }

        public String getStoreName() {
            return this.m_store;
        }

        public String getConnectionName() {
            return this.m_name;
        }

        public String toString() {
            return this.getQualifiedName();
        }

        public int hashCode() {
            return this.getQualifiedName().hashCode();
        }

        public boolean equals(Object object) {
            return object == this || object instanceof ConnectionKey && ModelUtil.areEqual((Object)this.m_store, (Object)((ConnectionKey)object).m_store) && ModelUtil.areEqual((Object)this.m_name, (Object)((ConnectionKey)object).m_name);
        }
    }

    private class L
    implements ConnectionsListener {
        private String m_id;
        private DatabaseConnections m_dbs;

        L(String string, DatabaseConnections databaseConnections) {
            this.m_id = string;
            this.m_dbs = databaseConnections;
        }

        private void register() {
            this.m_dbs.addListener((ConnectionsListener)this);
        }

        private void unregister() {
            this.m_dbs.removeListener((ConnectionsListener)this);
        }

        public void connectionAdded(ConnectionsEvent connectionsEvent) {
            String string = connectionsEvent.getName();
            ConnectionKey connectionKey = ConnectionKey.createConnectionKey(this.m_id, string);
            Connections.this.m_conns.put(connectionKey, new ConnectionInfo(connectionKey, this.m_dbs));
            Connections.this.fireConnectionEvent(new ConnectionEvent(2, connectionKey.getQualifiedName()), true);
        }

        public void connectionRemoved(ConnectionsEvent connectionsEvent) {
            String string = connectionsEvent.getName();
            ConnectionKey connectionKey = ConnectionKey.createConnectionKey(this.m_id, string);
            ConnectionInfo connectionInfo = (ConnectionInfo)Connections.this.m_conns.remove(connectionKey);
            if (connectionInfo != null) {
                connectionInfo.closeConnection();
            }
            Connections.this.fireConnectionEvent(new ConnectionEvent(3, connectionKey.getQualifiedName()), true);
        }

        public void connectionUpdated(ConnectionsEvent connectionsEvent) {
            String string = connectionsEvent.getOriginalName();
            String string2 = connectionsEvent.getName();
            ConnectionKey connectionKey = ConnectionKey.createConnectionKey(this.m_id, string);
            ConnectionInfo connectionInfo = (ConnectionInfo)Connections.this.m_conns.get(connectionKey);
            if (connectionInfo != null) {
                connectionInfo.closeConnection();
            }
            ConnectionKey connectionKey2 = ConnectionKey.createConnectionKey(this.m_id, string2);
            if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                Connections.this.m_conns.remove(connectionKey);
                Connections.this.m_conns.put(connectionKey2, new ConnectionInfo(connectionKey2, this.m_dbs));
            }
            Connections.this.fireConnectionEvent(new ConnectionEvent(5, connectionKey2.getQualifiedName(), connectionKey.getQualifiedName()), true);
        }
    }
}

