/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.Reader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.metadata.MetaData;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;

public class MetaDataDDLGenerator {
    private static Boolean _usePrefs = false;
    private static final String META_SQL = "SELECT DBMS_METADATA.GET_DDL(:TYPE,:NAME,:OWNER) SQL FROM SYS.DUAL";
    private static final String USER_META_SQL = "SELECT DBMS_METADATA.GET_DDL(:TYPE,:NAME) SQL FROM SYS.DUAL";
    private static final String TABLE_SQL = "declare   owner  varchar2(2000) := ?;    object varchar2(2000) := ?;    h  number;    h2 number; begin    h := dbms_metadata.open('TABLE');    dbms_metadata.set_filter(h,'SCHEMA',owner);    dbms_metadata.set_filter(h,'NAME',object);    dbms_metadata.set_filter(h,'EXCLUDE_PATH_EXPR','in (''TABLE_DATA'',''STATISTICS'',''POST_INSTANCE'',''INSTANCE_CALLOUT'',''PROCACT_INSTANCE'',''PRE_TABLE_ACTION'',''POST_TABLE_ACTION'')');    h2 := DBMS_METADATA.ADD_TRANSFORM(h,'DDL');    dbms_metadata.set_transform_param(h2,'SQLTERMINATOR',true);   ? := h;end;";
    private static final String TABLE_SQL_CLOB = "begin  ? := dbms_metadata.fetch_clob(?); end;";

    public static String getDDLFromGenerator(DBObject dBObject) {
        Database database = dBObject.getDatabase();
        String string = null;
        if (database != null) {
            OracleDDLGenerator oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database);
            Ddl ddl = oracleDDLGenerator.getCreateDDL(dBObject.getSchemaObject(), false, false);
            string = ddl.getDdl();
        }
        return string;
    }

    public static String getDDL(DBObject dBObject, Boolean bl) {
        _usePrefs = bl;
        return MetaDataDDLGenerator.getDDL(dBObject);
    }

    public static String getDDL(DBObject dBObject) {
        String string = MetaData.getDDL(dBObject, _usePrefs);
        if ((string == null || string.equals("")) && dBObject.getObjectType().equals("TABLE")) {
            string = MetaDataDDLGenerator.getTableMetaData(dBObject);
        } else if ((string == null || string.equals("")) && dBObject.getObjectType().equals("USER")) {
            string = MetaDataDDLGenerator.getUserFromMeta(dBObject);
        } else if (string == null || string.equals("")) {
            string = MetaDataDDLGenerator.getDDLFromMeta(dBObject);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getUserFromMeta(DBObject dBObject) {
        String string;
        block20: {
            ResultSet resultSet;
            block18: {
                string = null;
                DBUtil dBUtil = new DBUtil();
                dBUtil.setRaiseError(false);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TYPE", dBObject.getObjectType().replace(" ", "_"));
                hashMap.put("NAME", dBObject.getObjectName());
                resultSet = dBUtil.executeQuery(dBObject.getConnectionName(), USER_META_SQL, hashMap);
                if (!resultSet.next()) break block18;
                string = resultSet.getString(1);
            }
            Object var8_5 = null;
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block20;
            }
            catch (SQLException sQLException) {}
            break block20;
            {
                catch (Exception exception) {
                    String string2 = "-- DBMS_METADATA was unable to generate SQL. Now using internal DDL generator\n-- To Test DBMS_METADATA : select dbms_metadata.get_ddl('TABLE','DUAL','SYS') from dual;\n" + MetaDataDDLGenerator.getDDLFromGenerator(dBObject);
                    Object var8_6 = null;
                    try {
                        if (resultSet != null && resultSet.getStatement() != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return string2;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getDDLFromMeta(DBObject dBObject) {
        String string;
        block22: {
            ResultSet resultSet;
            block20: {
                string = null;
                DBUtil dBUtil = new DBUtil();
                dBUtil.setRaiseError(false);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (dBObject.getObjectType().equals("DATABASE LINK")) {
                    hashMap.put("TYPE", "DB_LINK");
                } else {
                    hashMap.put("TYPE", dBObject.getObjectType().replace(" ", "_"));
                }
                hashMap.put("NAME", dBObject.getObjectName());
                hashMap.put("OWNER", dBObject.getSchemaName());
                resultSet = dBUtil.executeQuery(dBObject.getConnectionName(), META_SQL, hashMap);
                if (!resultSet.next()) break block20;
                string = resultSet.getString(1);
            }
            Object var8_5 = null;
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block22;
            }
            catch (SQLException sQLException) {}
            break block22;
            {
                catch (Exception exception) {
                    String string2 = "-- DBMS_METADATA was unable to generate SQL. Now using internal DDL generator\n-- To Test DBMS_METADATA : select dbms_metadata.get_ddl('TABLE','DUAL','SYS') from dual;\n" + MetaDataDDLGenerator.getDDLFromGenerator(dBObject);
                    Object var8_6 = null;
                    try {
                        if (resultSet != null && resultSet.getStatement() != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return string2;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getTableMetaData(DBObject dBObject) {
        StringBuilder stringBuilder;
        block13: {
            int n;
            stringBuilder = new StringBuilder();
            OracleCallableStatement oracleCallableStatement = null;
            OracleCallableStatement oracleCallableStatement2 = null;
            PerformanceLogger.get().startTiming(MetaDataDDLGenerator.class.toString() + ".getTableMetaData");
            oracleCallableStatement = (OracleCallableStatement)dBObject.getConnection().prepareCall(TABLE_SQL);
            oracleCallableStatement.setString(1, dBObject.getSchemaName());
            oracleCallableStatement.setString(2, dBObject.getObjectName());
            oracleCallableStatement.registerOutParameter(3, 2);
            oracleCallableStatement.execute();
            BigDecimal bigDecimal = oracleCallableStatement.getBigDecimal(3);
            CLOB cLOB = null;
            oracleCallableStatement2 = (OracleCallableStatement)dBObject.getConnection().prepareCall(TABLE_SQL_CLOB);
            oracleCallableStatement2.registerOutParameter(1, 2005);
            oracleCallableStatement2.setBigDecimal(2, bigDecimal);
            oracleCallableStatement2.execute();
            cLOB = oracleCallableStatement2.getCLOB(1);
            Reader reader = cLOB.getCharacterStream();
            char[] cArray = new char[8192];
            while ((n = reader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            Object var10_11 = null;
            try {
                oracleCallableStatement.close();
            }
            catch (SQLException sQLException) {}
            break block13;
            {
                catch (Exception exception) {
                    if (stringBuilder.length() < 10) {
                        String string = "-- DBMS_METADATA was unable to use TABLE_EXPORT to generate sql.  Now trying to use TABLE.\n" + MetaDataDDLGenerator.getDDLFromMeta(dBObject);
                        Object var10_12 = null;
                        try {
                            oracleCallableStatement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        return string;
                    }
                    try {
                        Object var10_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        try {
                            oracleCallableStatement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        oracleCallableStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        PerformanceLogger.get().stopTiming(MetaDataDDLGenerator.class.toString() + ".getTableMetaData", "Got DDL");
        return stringBuilder.toString();
    }
}

