/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.objectpriv;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.objectpriv.DirectoryCheck;
import oracle.dbtools.util.objectpriv.IObjectCheck;
import oracle.dbtools.util.objectpriv.IndexCheck;
import oracle.dbtools.util.objectpriv.MatViewCheck;
import oracle.dbtools.util.objectpriv.MatViewLogCheck;
import oracle.dbtools.util.objectpriv.PlSqlCheck;
import oracle.dbtools.util.objectpriv.SequenceCheck;
import oracle.dbtools.util.objectpriv.SynonymCheck;
import oracle.dbtools.util.objectpriv.TableCheck;
import oracle.dbtools.util.objectpriv.TriggerCheck;
import oracle.dbtools.util.objectpriv.TypeCheck;
import oracle.dbtools.util.objectpriv.ViewCheck;
import oracle.dbtools.util.objectpriv.XmlSchemaCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionRegistry {
    private static Map<String, Class<? extends IObjectCheck>> _registry = new HashMap<String, Class<? extends IObjectCheck>>();

    public static synchronized void registerHandler(String string, String string2, Class<? extends IObjectCheck> clazz) {
        _registry.put(DBObject.getKey(string, string2), clazz);
    }

    public static synchronized void unregisterHandler(String string) {
        _registry.remove(string);
    }

    public static synchronized IObjectCheck getInstanceFor(DBObject dBObject) {
        String string = dBObject.getKey();
        if (string.lastIndexOf("_FOLDER") > 0) {
            string = string.substring(0, string.lastIndexOf("_FOLDER"));
        }
        Class<? extends IObjectCheck> clazz = _registry.get(string);
        try {
            if (clazz != null) {
                return clazz.newInstance();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(PermissionRegistry.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
        return null;
    }

    private static boolean isSYSDBA(DBObject dBObject) {
        Properties properties = Connections.getInstance().getConnectionInfo(dBObject.getConnectionName());
        return properties != null && "SYSDBA".equals(properties.getProperty("role"));
    }

    public static boolean canCreate(DBObject dBObject) {
        if (dBObject.isOracle() && PermissionRegistry.checkPrivs(dBObject)) {
            return true;
        }
        IObjectCheck iObjectCheck = PermissionRegistry.getInstanceFor(dBObject);
        return iObjectCheck != null && iObjectCheck.canCreate(dBObject);
    }

    public static boolean canAlter(DBObject dBObject) {
        if (dBObject.isOracle() && PermissionRegistry.checkPrivs(dBObject) && !dBObject.getObjectType().equals("XML SCHEMA")) {
            return true;
        }
        IObjectCheck iObjectCheck = PermissionRegistry.getInstanceFor(dBObject);
        return iObjectCheck != null && iObjectCheck.canAlter(dBObject);
    }

    public static boolean canDrop(DBObject dBObject) {
        if (dBObject.isOracle() && PermissionRegistry.checkPrivs(dBObject)) {
            return true;
        }
        IObjectCheck iObjectCheck = PermissionRegistry.getInstanceFor(dBObject);
        return iObjectCheck != null && iObjectCheck.canDrop(dBObject);
    }

    private static boolean checkPrivs(DBObject dBObject) {
        try {
            return PermissionRegistry.isOwnedObject(dBObject) || PermissionRegistry.isSYSDBA(dBObject);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(PermissionRegistry.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
    }

    private static boolean isOwnedObject(DBObject dBObject) throws SQLException {
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getConnection().getMetaData().getUserName();
        boolean bl = string2.equals(string);
        return bl;
    }

    static {
        PermissionRegistry.registerHandler("Oracle", "TABLE", TableCheck.class);
        PermissionRegistry.registerHandler("Oracle", "VIEW", ViewCheck.class);
        PermissionRegistry.registerHandler("Oracle", "INDEX", IndexCheck.class);
        PermissionRegistry.registerHandler("Oracle", "SEQUENCE", SequenceCheck.class);
        PermissionRegistry.registerHandler("Oracle", "PACKAGE", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "PACKAGE BODY", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "PROCEDURE", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "FUNCTION", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "TRIGGER", TriggerCheck.class);
        PermissionRegistry.registerHandler("Oracle", "TYPE", TypeCheck.class);
        PermissionRegistry.registerHandler("Oracle", "MATERIALIZED VIEW", MatViewCheck.class);
        PermissionRegistry.registerHandler("Oracle", "MATERIALIZED VIEW LOG", MatViewLogCheck.class);
        PermissionRegistry.registerHandler("Oracle", "SYNONYM", SynonymCheck.class);
        PermissionRegistry.registerHandler("Oracle", "DIRECTORY", DirectoryCheck.class);
        PermissionRegistry.registerHandler("Oracle", "XML SCHEMA", XmlSchemaCheck.class);
    }
}

