/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import oracle.ide.panels.Traversable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTypeUIRegistry {
    public static final String CONNECTIONS_INSTANCE_KEY = "ConnectionsInstanceKey";
    public static final String CONNECTION_NAME_KEY = "ConnectionNameKey";
    public static final String CONNECTION_ORIG_NAME_KEY = "ConnectionOrigNameKey";
    public static final String[] EDITABLE_SYSDBA_SYSOPER = new String[]{null, "SYSDBA", "SYSOPER"};
    public static final String[] FIXED_NONE_SYSDBA_SYSOPER = new String[]{"", "SYSDBA", "SYSOPER"};
    private static ArrayList<String> m_orderedList = new ArrayList();
    private static HashMap<String, RegistryEntry> m_registryEntries = new HashMap();

    public static void registerConnectionTypeUI(String connectionType, String displayName, String usernameKey, String roleKey, String[] preSetRoleList, String passwordKey, String savePasswordKey, String deployPasswordKey, AlwaysNeverAsk savePassword, AlwaysNeverAsk deployPassword, Class panelClass, ConnectionTooltipProvider tooltipProvider) {
        if (m_registryEntries.containsKey(connectionType)) {
            m_registryEntries.remove(connectionType);
            m_orderedList.remove(connectionType);
        }
        m_registryEntries.put(connectionType, new RegistryEntry(displayName, usernameKey, roleKey, preSetRoleList, passwordKey, savePasswordKey, deployPasswordKey, savePassword, deployPassword, panelClass, tooltipProvider));
        m_orderedList.add(connectionType);
    }

    public static Collection<String> getConnectionTypes() {
        return m_orderedList;
    }

    public static String getDisplayName(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_displayName(re);
    }

    public static String getUsernameKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_usernameKey(re);
    }

    public static String getRoleKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_roleKey(re);
    }

    public static String[] getPreSetRoleList(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_preSetRoleList(re);
    }

    public static String getPasswordKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_passwordKey(re);
    }

    public static String getSavePasswordKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_savePasswordKey(re);
    }

    public static String getDeployPasswordKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_deployPasswordKey(re);
    }

    public static AlwaysNeverAsk getSavePassword(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_savePassword(re);
    }

    public static AlwaysNeverAsk getDeployPassword(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_deployPassword(re);
    }

    public static Class getPanelClass(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_panelClass(re);
    }

    public static ConnectionTooltipProvider getTooltipProvider(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : RegistryEntry.ra$m_tooltipProvider(re);
    }

    public static String getSubTypeFromDisplayName(String displayName) {
        String connectionType = null;
        if (displayName != null) {
            for (String key : m_registryEntries.keySet()) {
                RegistryEntry re = m_registryEntries.get(key);
                if (!displayName.equals(RegistryEntry.ra$m_displayName(re))) continue;
                connectionType = key;
                break;
            }
        }
        return connectionType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AlwaysNeverAsk
    extends Enum<AlwaysNeverAsk> {
        private static final /* synthetic */ AlwaysNeverAsk[] $v;
        public static final /* enum */ AlwaysNeverAsk ALWAYS;
        public static final /* enum */ AlwaysNeverAsk NEVER;
        public static final /* enum */ AlwaysNeverAsk ASK;

        public static AlwaysNeverAsk valueOf(String string) {
            return Enum.valueOf(AlwaysNeverAsk.class, string);
        }

        public static final AlwaysNeverAsk[] values() {
            return (AlwaysNeverAsk[])$v.clone();
        }

        static {
            AlwaysNeverAsk[] alwaysNeverAskArray = new AlwaysNeverAsk[3];
            alwaysNeverAskArray[2] = ASK = new AlwaysNeverAsk("ASK", 2);
            alwaysNeverAskArray[1] = NEVER = new AlwaysNeverAsk("NEVER", 1);
            alwaysNeverAskArray[0] = ALWAYS = new AlwaysNeverAsk("ALWAYS", 0);
            $v = alwaysNeverAskArray;
        }

        private AlwaysNeverAsk(String string2, int n2) {
        }
    }

    public interface ConnectionTooltipProvider {
        public String getTooltip(Properties var1);
    }

    private static class RegistryEntry {
        private String m_displayName;
        private String m_usernameKey;
        private String m_roleKey;
        private String[] m_preSetRoleList;
        private String m_passwordKey;
        private String m_savePasswordKey;
        private String m_deployPasswordKey;
        private AlwaysNeverAsk m_savePassword;
        private AlwaysNeverAsk m_deployPassword;
        private Class m_panelClass;
        private ConnectionTooltipProvider m_tooltipProvider;

        public RegistryEntry(String displayName, String usernameKey, String roleKey, String[] preSetRoleList, String passwordKey, String savePasswordKey, String deployPasswordKey, AlwaysNeverAsk savePassword, AlwaysNeverAsk deployPassword, Class panelClass, ConnectionTooltipProvider tooltipProvider) {
            this.m_displayName = displayName;
            this.m_usernameKey = usernameKey;
            this.m_roleKey = roleKey;
            this.m_preSetRoleList = preSetRoleList;
            this.m_passwordKey = passwordKey;
            this.m_savePasswordKey = savePasswordKey;
            this.m_deployPasswordKey = deployPasswordKey;
            this.m_savePassword = savePassword;
            this.m_deployPassword = deployPassword;
            if (!Traversable.class.isAssignableFrom(panelClass)) {
                throw new ClassCastException(panelClass.toString() + " is not Traversable");
            }
            this.m_panelClass = panelClass;
            this.m_tooltipProvider = tooltipProvider;
        }

        static String ra$m_displayName(RegistryEntry registryEntry) {
            return registryEntry.m_displayName;
        }

        static ConnectionTooltipProvider ra$m_tooltipProvider(RegistryEntry registryEntry) {
            return registryEntry.m_tooltipProvider;
        }

        static Class ra$m_panelClass(RegistryEntry registryEntry) {
            return registryEntry.m_panelClass;
        }

        static AlwaysNeverAsk ra$m_deployPassword(RegistryEntry registryEntry) {
            return registryEntry.m_deployPassword;
        }

        static AlwaysNeverAsk ra$m_savePassword(RegistryEntry registryEntry) {
            return registryEntry.m_savePassword;
        }

        static String ra$m_deployPasswordKey(RegistryEntry registryEntry) {
            return registryEntry.m_deployPasswordKey;
        }

        static String ra$m_savePasswordKey(RegistryEntry registryEntry) {
            return registryEntry.m_savePasswordKey;
        }

        static String ra$m_passwordKey(RegistryEntry registryEntry) {
            return registryEntry.m_passwordKey;
        }

        static String[] ra$m_preSetRoleList(RegistryEntry registryEntry) {
            return registryEntry.m_preSetRoleList;
        }

        static String ra$m_roleKey(RegistryEntry registryEntry) {
            return registryEntry.m_roleKey;
        }

        static String ra$m_usernameKey(RegistryEntry registryEntry) {
            return registryEntry.m_usernameKey;
        }
    }
}

