/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.logging.Level;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBLog;
import oracle.jdevimpl.db.DefaultEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseConnectionEditor {
    private static Class<? extends ConnectionEditor> s_editor;

    private DatabaseConnectionEditor() {
    }

    public static void setEditor(Class<? extends ConnectionEditor> ed) {
        if (Product.isJDeveloper()) {
            DBLog.log((String)("Ignoring attempt to set database connection editor to " + ed.getName()), (Object[])new Object[0]);
        } else {
            s_editor = ed;
        }
    }

    private static ConnectionEditor getEditor() {
        if (s_editor != null) {
            try {
                ConnectionEditor connectionEditor = s_editor.newInstance();
                return connectionEditor;
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.SEVERE, "cannot create db connection editor", e);
            }
        }
        return DefaultEditor.createDefaultEditor();
    }

    public static String editConnection(String connName) {
        String store;
        ConnectionEditor ce = DatabaseConnectionEditor.getEditor();
        String string = store = connName == null ? null : DBObjectNodeUtil.decode((String)connName, (boolean)true);
        if (store != null) {
            return DatabaseConnectionEditor.editConnection(store, DBObjectNodeUtil.decode((String)connName, (boolean)false), true);
        }
        return ce.launchEditor(connName);
    }

    public static String editConnection(String storeName, String connName) {
        ConnectionEditor ce = DatabaseConnectionEditor.getEditor();
        return ce.launchEditor(storeName, connName);
    }

    public static String editConnection(String storeName, String connName, boolean allowAllStores) {
        ConnectionEditor ce = DatabaseConnectionEditor.getEditor();
        if (ce instanceof DefaultEditor) {
            ((DefaultEditor)ce).setStoreChoice(DefaultEditor.StoreChoice.ALL);
        }
        return ce.launchEditor(storeName, connName);
    }

    public static interface ConnectionEditor {
        public String launchEditor(String var1);

        public String launchEditor(String var1, String var2);
    }
}

