/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.StoreListener;
import oracle.jdeveloper.db.StoreProvider;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseConnectionStores {
    public static final String CENTRAL_STORE = "IdeConnections";
    private static DatabaseConnectionStores s_instance;
    private List<StoreProvider> m_providers;
    private Collection<StoreListener> m_listeners;

    public static final DatabaseConnectionStores getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseConnectionStores();
        }
        return s_instance;
    }

    private void $init$() {
        this.m_providers = new ArrayList<StoreProvider>();
        this.m_listeners = new HashSet<StoreListener>();
    }

    private DatabaseConnectionStores() {
        this.$init$();
        this.registerStoreProvider(new CentralStoreProvider(null));
    }

    private Collection<StoreListener> getListeners() {
        return Collections.unmodifiableCollection(new HashSet<StoreListener>(this.m_listeners));
    }

    void fireStoreAdded(String storeName) {
        for (StoreListener l : this.getListeners()) {
            try {
                l.storeAdded(storeName);
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", e);
            }
        }
        this.printStores();
    }

    void fireStoreRemoved(String storeName) {
        for (StoreListener l : this.getListeners()) {
            try {
                l.storeRemoved(storeName);
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", e);
            }
        }
        this.printStores();
    }

    public void addStoreListener(StoreListener l) {
        this.m_listeners.add(l);
    }

    public void removeStoreListener(StoreListener l) {
        this.m_listeners.remove(l);
    }

    public Collection<String> listStores() {
        ArrayList<String> retval = new ArrayList<String>();
        for (StoreProvider provider : this.m_providers) {
            retval.addAll(provider.listStores());
        }
        return retval;
    }

    public DatabaseConnections getCurrentStore() {
        if (Ide.isRunning()) {
            return this.getCurrentStore(Context.newIdeContext());
        }
        return DatabaseConnections.getInstance();
    }

    public DatabaseConnections getCurrentStore(Context ideContext) {
        for (StoreProvider provider : this.m_providers) {
            String storeName = provider.getCurrentStore(ideContext);
            if (!ModelUtil.hasLength((String)storeName)) continue;
            return this.getStore(storeName);
        }
        return DatabaseConnections.getInstance();
    }

    public String getCurrentConnection(Context ideContext) {
        if (ideContext != null) {
            for (StoreProvider provider : this.m_providers) {
                String storeName = provider.getCurrentStore(ideContext);
                if (!ModelUtil.hasLength((String)storeName)) continue;
                return provider.getCurrentConnection(ideContext);
            }
        }
        return null;
    }

    public Database getCurrentDatabase(Context ideContext) {
        if (ideContext != null) {
            for (StoreProvider provider : this.m_providers) {
                String storeName = provider.getCurrentStore(ideContext);
                DatabaseConnections store = this.getStore(storeName);
                if (store == null) continue;
                String connName = provider.getCurrentConnection(ideContext);
                try {
                    Database database = store.getDatabase(connName);
                    return database;
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.FINE, "failed to open database " + connName, dbe);
                }
            }
        }
        return null;
    }

    public DatabaseConnections getStore(String storeName) {
        if (storeName == null) {
            return null;
        }
        for (StoreProvider provider : this.m_providers) {
            DatabaseConnections store = provider.getStore(storeName);
            if (store == null) continue;
            return store;
        }
        return null;
    }

    public String getShortLabel(String storeName) {
        if (storeName == null) {
            return null;
        }
        for (StoreProvider provider : this.m_providers) {
            String shortLabel = provider.getShortLabel(storeName);
            if (shortLabel == null) continue;
            return shortLabel;
        }
        return null;
    }

    public Icon getIcon(String storeName) {
        if (storeName == null) {
            return null;
        }
        for (StoreProvider provider : this.m_providers) {
            Icon icon = provider.getIcon(storeName);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public String getToolTipText(String storeName) {
        if (storeName == null) {
            return null;
        }
        for (StoreProvider provider : this.m_providers) {
            String ttt = provider.getToolTipText(storeName);
            if (ttt == null) continue;
            return ttt;
        }
        return null;
    }

    public void registerStoreProvider(StoreProvider provider) {
        this.m_providers.add(0, provider);
        DBLog.getLogger().log(Level.FINE, "Registered new database connection store provider: " + provider.getClass().getName());
        this.printStores();
    }

    private void printStores() {
        Logger logger = DBLog.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            Collection<String> stores = this.listStores();
            if (stores.size() > 0) {
                StringBuilder buff = new StringBuilder();
                buff.append("Available database connection stores: \n");
                for (String name : stores) {
                    buff.append(name).append("\n");
                }
                logger.log(Level.FINE, buff.toString());
            } else {
                logger.log(Level.FINE, "There are no available database connection stores.");
            }
        }
    }

    public static DatabaseProvider getReferenceable(String storeName, String connName) {
        DatabaseConnections chosen;
        if (storeName != null && (chosen = DatabaseConnectionStores.getInstance().getStore(storeName)) != null) {
            try {
                DatabaseProvider databaseProvider = (DatabaseProvider)chosen.getReferenceable(connName);
                return databaseProvider;
            }
            catch (ConnectionException ce) {
                DBLog.getLogger().log(Level.WARNING, "cannot get connection " + connName + " from store " + storeName, ce);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CentralStoreProvider
    extends StoreProvider {
        @Override
        public DatabaseConnections getStore(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DatabaseConnections.getInstance();
            }
            return null;
        }

        @Override
        public String getShortLabel(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DBConnArb.getString(97);
            }
            return null;
        }

        @Override
        public Icon getIcon(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return OracleIcons.getIcon((String)"dbconn.png");
            }
            return null;
        }

        @Override
        public String getToolTipText(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DBConnArb.getString(28);
            }
            return null;
        }

        @Override
        public Collection<String> listStores() {
            return Arrays.asList(DatabaseConnectionStores.CENTRAL_STORE);
        }

        @Override
        protected String getCurrentStore(Context ideContext) {
            return DatabaseConnectionStores.CENTRAL_STORE;
        }

        private CentralStoreProvider() {
        }

        CentralStoreProvider(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

