/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import oracle.ide.Ide;
import oracle.ideri.util.Product;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DisconnectListener;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnAddin;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.adapter.CADatabaseFactory;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.DefaultContextWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnections
implements Connections {
    private static DatabaseConnections s_instance;
    private static Logger s_logger;
    private final Map<String, Collection<Connection>> m_extraConns;
    private final Collection<ConnectionsListener> m_lists;
    private final Collection<DisconnectListener> m_distlists;
    private DatabaseContextManager.ContextWrapper m_contextWrapper;
    private DatabaseFactory.ConnectionCreator m_connCreator;
    private String m_storeName;
    private ListenerBridge m_listBridge;
    private Lock m_lock;
    private boolean m_privateStore;

    private void $init$() {
        this.m_extraConns = new HashMap<String, Collection<Connection>>();
        this.m_lists = new HashSet<ConnectionsListener>();
        this.m_distlists = new HashSet<DisconnectListener>();
    }

    protected DatabaseConnections(String storeName, DatabaseContextManager.ContextWrapper contextWrapper, DatabaseFactory.ConnectionCreator connCreator) {
        this.$init$();
        this.m_storeName = storeName;
        this.m_contextWrapper = contextWrapper;
        this.m_connCreator = connCreator;
    }

    private synchronized Lock getLock() {
        if (this.m_lock == null) {
            this.m_lock = new ReentrantLock();
        }
        return this.m_lock;
    }

    private DatabaseContextManager.ContextWrapper getWrapper() {
        if (this.isCentralStore()) {
            if (Ide.isRunning() && DBConnAddin.isStarting()) {
                throw new IllegalStateException(DBConnArb.getString(69));
            }
            if (this.m_contextWrapper == null) {
                this.m_contextWrapper = DatabaseContextManager.getContextWrapper();
                this.m_connCreator = (CADatabaseFactory)DatabaseFactory.findConnectionCreator(CADatabaseFactory.class);
            }
        }
        if (this.m_contextWrapper == null) {
            throw new IllegalStateException(DBConnArb.getString(50));
        }
        Context connContext = this.m_contextWrapper.getDatabaseContext();
        if (connContext instanceof EventContext && this.m_listBridge == null) {
            this.m_listBridge = new ListenerBridge(null);
            try {
                ((EventContext)connContext).addNamingListener("", 0, (NamingListener)this.m_listBridge);
            }
            catch (NamingException nme) {
                DatabaseConnections.getLogger().warning("Couldn't register listener on context: " + nme);
                this.m_listBridge = null;
            }
        }
        return this.m_contextWrapper;
    }

    @Override
    public void addListener(ConnectionsListener l) {
        this.m_lists.add(l);
    }

    @Override
    public boolean removeListener(ConnectionsListener l) {
        return this.m_lists.remove(l);
    }

    protected Collection<ConnectionsListener> getListeners() {
        return Collections.unmodifiableCollection(new HashSet<ConnectionsListener>(this.m_lists));
    }

    @Override
    public void addDisconnectListener(DisconnectListener l) {
        this.m_distlists.add(l);
    }

    @Override
    public boolean removeDisconnectListener(DisconnectListener l) {
        return this.m_distlists.remove(l);
    }

    protected Collection<DisconnectListener> getDisconnectListeners() {
        return Collections.unmodifiableCollection(new HashSet<DisconnectListener>(this.m_distlists));
    }

    private void fireConnectionAdded(ConnectionsEvent ce) {
        for (ConnectionsListener l : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                try {
                    l.connectionAdded(ce);
                }
                catch (Exception e) {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
            }
            catch (Throwable throwable) {
                if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                    DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), " listener {0} took {1}ms for add connection", new Object[]{l.getClass().getName(), System.currentTimeMillis() - time});
                }
                throw throwable;
            }
            if (!DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) continue;
            DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), " listener {0} took {1}ms for add connection", new Object[]{l.getClass().getName(), System.currentTimeMillis() - time});
        }
    }

    private void fireConnectionRemoved(ConnectionsEvent ce) {
        for (ConnectionsListener l : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                try {
                    l.connectionRemoved(ce);
                }
                catch (Exception e) {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
            }
            catch (Throwable throwable) {
                if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                    DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), " listener {0} took {1}ms for remove connection", new Object[]{l.getClass().getName(), System.currentTimeMillis() - time});
                }
                throw throwable;
            }
            if (!DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) continue;
            DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), " listener {0} took {1}ms for remove connection", new Object[]{l.getClass().getName(), System.currentTimeMillis() - time});
        }
    }

    private void fireConnectionUpdated(ConnectionsEvent ce) {
        for (ConnectionsListener l : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                try {
                    l.connectionUpdated(ce);
                }
                catch (Exception e) {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
            }
            catch (Throwable throwable) {
                if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                    DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), " listener {0} took {1}ms for update connection", new Object[]{l.getClass().getName(), System.currentTimeMillis() - time});
                }
                throw throwable;
            }
            if (!DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) continue;
            DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), " listener {0} took {1}ms for update connection", new Object[]{l.getClass().getName(), System.currentTimeMillis() - time});
        }
    }

    private String getMessage(Throwable e) {
        Throwable t;
        String msg = e.getLocalizedMessage();
        if ((!ModelUtil.hasLength((String)msg) || msg.equals("null")) && (t = e.getCause()) != null && t != e) {
            msg = this.getMessage(t);
        }
        return msg;
    }

    @Override
    public final Collection<String> listConnections() {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Context c = this.getWrapper().getDatabaseContext();
            if (c == null) {
                DatabaseConnections.getLogger().log(this.m_privateStore ? Level.FINE : Level.SEVERE, "DatabaseConnections has no JNDI context so cannot list connections.");
            } else {
                NamingEnumeration<NameClassPair> nenum = c.list("");
                while (nenum.hasMoreElements()) {
                    NameClassPair pair = (NameClassPair)nenum.nextElement();
                    if (!pair.getClassName().equals(DatabaseProvider.class.getName())) continue;
                    retval.add(pair.getName());
                }
            }
        }
        catch (NamingException nme) {
            DatabaseConnections.getLogger().log(Level.SEVERE, DBConnArb.getString(82), nme);
        }
        return retval;
    }

    public final Collection<String> listConnections(boolean oracleOnly) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        return this.listConnections(stringArray);
    }

    public Collection<String> listConnections(String[] subTypes) {
        Collection<String> retval;
        if (subTypes != null) {
            Arrays.sort(subTypes);
        }
        if ((retval = this.listConnections()).size() > 0 && subTypes != null) {
            for (String name : new ArrayList<String>(retval)) {
                try {
                    Properties props = this.getProperties(name);
                    String subtype = props.getProperty("subtype");
                    if (subtype != null && Arrays.binarySearch(subTypes, subtype) >= 0) continue;
                    retval.remove(name);
                }
                catch (ConnectionException ce) {
                    DatabaseConnections.getLogger().log(Level.WARNING, ce.getMessage(), ce);
                    retval.remove(name);
                }
            }
        }
        return retval;
    }

    @Override
    public final Collection<String> listConnections(Properties filter) {
        Collection<String> allConns = this.listConnections();
        if (filter == null || filter.size() == 0) {
            return allConns;
        }
        ArrayList<String> retval = new ArrayList<String>();
        for (String name : allConns) {
            boolean add = false;
            try {
                Properties connProps = this.getProperties(name);
                add = true;
                for (Object key : filter.keySet()) {
                    String filterVal = filter.getProperty((String)key);
                    String connVal = connProps.getProperty((String)key);
                    if (!ModelUtil.areDifferent((Object)connVal, (Object)filterVal)) continue;
                    add = false;
                    break;
                }
            }
            catch (ConnectionException ce) {
                // empty catch block
            }
            if (!add) continue;
            retval.add(name);
        }
        return retval;
    }

    public final Connection getConnection(String connName) throws ConnectionException {
        try {
            Database db = this.getDatabase(connName);
            if (db == null) {
                throw new ConnectionException(DBConnArb.format(47, connName));
            }
            Connection connection = db.getConnection();
            return connection;
        }
        catch (DBException dbe) {
            Throwable t = dbe.getCause() == null ? dbe : dbe.getCause();
            throw new ConnectionException(DBConnArb.format(100, connName, this.getMessage(t)), t);
        }
    }

    public final Connection getUniqueConnection(String connName) throws ConnectionException {
        Referenceable ref = this.getReferenceable(connName);
        if (ref instanceof DatabaseProvider) {
            try {
                Connection conn = ((DatabaseProvider)ref).getConnection();
                Collection<Connection> extraConns = this.m_extraConns.get(connName);
                if (extraConns == null) {
                    extraConns = new ArrayList<Connection>();
                    this.m_extraConns.put(connName, extraConns);
                }
                extraConns.add(conn);
                Connection connection = conn;
                return connection;
            }
            catch (SQLException sqe) {
                throw new ConnectionException(DBConnArb.format(100, connName, this.getMessage(sqe)), sqe);
            }
        }
        throw new ConnectionException(DBConnArb.format(47, connName));
    }

    public final Connection getConnection(Properties props) throws ConnectionException {
        DatabaseProvider pro = this.newDatabaseProvider(null, props);
        try {
            Connection connection = pro.getConnection();
            return connection;
        }
        catch (SQLException sqe) {
            throw new ConnectionException(DBConnArb.format(4, this.getMessage(sqe)), sqe);
        }
    }

    public final Database getDatabase(String connName) throws DBException {
        return this.getDatabase(connName, true);
    }

    /*
     * Unable to fully structure code
     */
    public final Database getDatabase(String connName, boolean create) throws DBException {
        try {
            if (this.getReferenceable(connName) == null) {
                var8_3 = null;
                return var8_3;
            }
        }
        catch (ConnectionException var3_4) {
            // empty catch block
        }
        db = null;
        foundStore = false;
        if (this.m_connCreator != null) {
            foundStore = true;
            if (create) {
                lock = this.getLock();
                locked = false;
                try {
                    if (!lock.tryLock()) {
                        db = this.m_connCreator.findDatabase(connName);
                        if (db == null) {
                            lock.lock();
                            locked = true;
                        }
                    } else {
                        locked = true;
                    }
                    if (db != null || (db = this.m_connCreator.findDatabase(connName)) != null || !create) ** GOTO lbl31
                    db = DatabaseFactory.createDatabase((String)connName, (DatabaseFactory.ConnectionCreator)this.m_connCreator);
                }
                finally {
                    if (locked) {
                        lock.unlock();
                    }
                }
            } else {
                db = this.m_connCreator.findDatabase(connName);
            }
        }
lbl31:
        // 5 sources

        if (!foundStore && (db = (Database)DBObjectProviderFactory.findProvider((Object)connName)) == null && create) {
            db = (Database)DBObjectProviderFactory.findOrCreateProvider((Object)connName);
        }
        if (db != null) {
            db.getConnection(true);
        }
        return db;
    }

    @Override
    public Referenceable getReferenceable(String connName) throws ConnectionException {
        if (connName == null) {
            return null;
        }
        try {
            Context c = this.getWrapper().getDatabaseContext();
            long time = System.currentTimeMillis();
            Object obj = c.lookup(connName);
            if (obj instanceof DatabaseProvider) {
                if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                    DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "... lookup of Referenceable from CA took {0}ms", System.currentTimeMillis() - time);
                }
                DatabaseProvider databaseProvider = (DatabaseProvider)obj;
                return databaseProvider;
            }
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(24, connName, this.getMessage(nme)), nme);
        }
        return null;
    }

    @Override
    public final Properties getProperties(String connName) throws ConnectionException {
        DatabaseProvider connPro = (DatabaseProvider)this.getReferenceable(connName);
        if (connPro != null) {
            return connPro.getProperties();
        }
        return null;
    }

    private DatabaseProvider newDatabaseProvider(String connName, Properties props) {
        if (this.m_privateStore) {
            props.setProperty("INTERNAL_STRINGS_TO_FILE", "true");
        }
        return new DatabaseProvider(connName, props);
    }

    @Override
    public void addConnection(String connName, Properties props) throws ConnectionException {
        long time = System.currentTimeMillis();
        Referenceable ref = this.getReferenceable(connName);
        if (ref != null) {
            throw new ConnectionException(DBConnArb.format(57, connName));
        }
        DatabaseProvider connPro = this.newDatabaseProvider(connName, props);
        Context ctx = this.getWrapper().getDatabaseContext();
        try {
            long bindtime = System.currentTimeMillis();
            ctx.bind(connName, (Object)connPro);
            if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "... bind into CA took {0}ms", System.currentTimeMillis() - bindtime);
            }
            if (this.m_listBridge == null) {
                this.fireConnectionAdded(new ConnectionsEvent(connName, (Referenceable)connPro));
            }
        }
        catch (NameAlreadyBoundException nabe) {
            throw new ConnectionException(DBConnArb.format(99, nabe.getMessage()));
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(9, connName, this.getMessage(nme)), nme);
        }
        if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
            DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "Total time for addConnection {0}ms", System.currentTimeMillis() - time);
        }
    }

    @Override
    public boolean removeConnection(String connName) throws ConnectionException {
        long time = System.currentTimeMillis();
        Referenceable removing = this.getReferenceable(connName);
        if (removing == null) {
            return false;
        }
        Context ctx = this.getWrapper().getDatabaseContext();
        try {
            if (!this.disconnect(connName, false)) {
                boolean bl = false;
                return bl;
            }
            try {
                if (this.m_listBridge != null) {
                    ListenerBridge.wa$m_listening(this.m_listBridge, false);
                }
                long bindtime = System.currentTimeMillis();
                ctx.unbind(connName);
                if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                    DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "... unbind from CA took {0}ms", System.currentTimeMillis() - bindtime);
                }
                this.closeDatabase(connName, true, (DatabaseProvider)removing, true);
            }
            finally {
                if (this.m_listBridge != null) {
                    ListenerBridge.wa$m_listening(this.m_listBridge, true);
                }
            }
            if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "Total time for removeConnection {0}ms", System.currentTimeMillis() - time);
            }
            boolean bl = true;
            return bl;
        }
        catch (NameNotFoundException nnfe) {
            boolean bl = false;
            return bl;
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(41, connName, this.getMessage(nme)), nme);
        }
    }

    private void closeDatabase(String connName, boolean uncacheDatabase, DatabaseProvider ref, boolean fireRemoved) {
        Database db;
        Database db2;
        boolean found = false;
        if (this.m_connCreator != null && (db2 = this.m_connCreator.findDatabase(connName)) != null) {
            found = true;
            db2.close();
            if (uncacheDatabase) {
                this.m_connCreator.uncacheDatabase(connName);
            }
        }
        if (!found && (db = (Database)DBObjectProviderFactory.findProvider((Object)connName)) != null) {
            db.close();
            if (uncacheDatabase) {
                DBObjectProviderFactory.uncacheProvider((Object)connName);
            }
        }
        ref.disconnect();
        if (fireRemoved) {
            this.fireConnectionRemoved(new ConnectionsEvent(connName, (Referenceable)ref));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateConnection(String connName, String newName, Properties newProps) throws ConnectionException {
        long time;
        block22: {
            boolean propsChanged;
            DatabaseProvider oldConnPro;
            block21: {
                boolean bl;
                DatabaseProvider connPro;
                time = System.currentTimeMillis();
                oldConnPro = (DatabaseProvider)this.getReferenceable(connName);
                if (oldConnPro == null) {
                    throw new ConnectionException(DBConnArb.format(47, connName));
                }
                if (newProps == null) {
                    connPro = oldConnPro;
                    propsChanged = false;
                } else {
                    connPro = this.newDatabaseProvider(newName == null ? connName : newName, newProps);
                    propsChanged = connPro.equals((Object)oldConnPro) ^ true;
                }
                boolean rename = connName.equals(newName) ^ true;
                if (!propsChanged && !rename) break block22;
                Context ctx = this.getWrapper().getDatabaseContext();
                boolean removed = false;
                try {
                    if (propsChanged) {
                        if (!this.disconnect(connName, false)) {
                            bl = false;
                            return bl;
                        }
                    } else {
                        this.renameDatabase(connName, newName);
                    }
                    if (newName == null || newName.length() <= 0 || !rename) break block20;
                }
                catch (NamingException nme) {
                    if (!removed) throw new ConnectionException(DBConnArb.format(22, connName, this.getMessage(nme)), nme);
                    try {
                        ctx.bind(connName, (Object)oldConnPro);
                        throw new ConnectionException(DBConnArb.format(22, connName, this.getMessage(nme)), nme);
                    }
                    catch (NamingException e) {
                        DatabaseConnections.getLogger().log(Level.WARNING, "couldn't rollback remove of old connection", e);
                    }
                    throw new ConnectionException(DBConnArb.format(22, connName, this.getMessage(nme)), nme);
                }
                {
                    String name;
                    block23: {
                        block20: {
                            DatabaseProvider existing = (DatabaseProvider)this.getReferenceable(newName);
                            if (existing != null) {
                                throw new ConnectionException(DBConnArb.format(57, newName));
                            }
                            if (this.m_listBridge != null) {
                                ListenerBridge.wa$m_listening(this.m_listBridge, false);
                            }
                            long bindtime = System.currentTimeMillis();
                            ctx.unbind(connName);
                            removed = true;
                            ctx.bind(newName, (Object)connPro);
                            if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                                DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "... rebind (bind/unbind) to CA took {0}ms", System.currentTimeMillis() - bindtime);
                            }
                            name = newName;
                            break block23;
                        }
                        long bindtime = System.currentTimeMillis();
                        ctx.rebind(connName, (Object)connPro);
                        name = connName;
                        if (DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) {
                            DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "... rebind to CA took {0}ms", System.currentTimeMillis() - bindtime);
                        }
                    }
                    this.fireConnectionUpdated(new ConnectionsEvent(connName, name, (Referenceable)connPro));
                    break block21;
                }
                finally {
                    if (this.m_listBridge == null) return bl;
                    ListenerBridge.wa$m_listening(this.m_listBridge, true);
                }
            }
            if (propsChanged) {
                this.closeDatabase(connName, true, oldConnPro, false);
            }
        }
        if (!DatabaseConnections.getLogger().isLoggable(DBLog.getTimingLogLevel())) return true;
        DatabaseConnections.getLogger().log(DBLog.getTimingLogLevel(), "Total time for updateConnection {0}ms", System.currentTimeMillis() - time);
        return true;
    }

    private void renameDatabase(String oldName, String newName) {
        if (this.m_connCreator != null) {
            this.m_connCreator.renameDatabase(oldName, newName);
        } else {
            DatabaseFactory.ConnectionCreator cc;
            AbstractDatabase db = (AbstractDatabase)DBObjectProviderFactory.findProvider((Object)oldName);
            if (db != null && (cc = DatabaseFactory.findConnectionCreator((Database)db)) != null) {
                cc.renameDatabase(oldName, newName);
            }
        }
    }

    @Override
    public final void testConnection(Properties props) throws ConnectionException {
        DatabaseProvider connPro = this.newDatabaseProvider(null, props);
        Connection conn = null;
        try {
            try {
                conn = connPro.getConnection();
            }
            catch (Throwable e) {
                throw new ConnectionException(DBConnArb.format(38, this.getMessage(e)), e);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public final void disconnect(String connName) throws ConnectionException {
        this.disconnect(connName, false);
    }

    public final boolean disconnect(String connName, boolean force) throws ConnectionException {
        DatabaseProvider ref = (DatabaseProvider)this.getReferenceable(connName);
        if (ref != null) {
            return this.doDisconnect(connName, ref, force);
        }
        return false;
    }

    private boolean doDisconnect(String connName, DatabaseProvider ref, boolean force) throws ConnectionException {
        ConnectionsEvent ce = new ConnectionsEvent(connName, (Referenceable)ref);
        for (DisconnectListener l : this.getDisconnectListeners()) {
            try {
                if (l.canDisconnect(ce)) continue;
                if (force) {
                    DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(36, connName, l.getClass().getName()));
                    continue;
                }
                DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(35, connName, l.getClass().getName()));
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                DatabaseConnections.getLogger().log(Level.SEVERE, DBConnArb.format(59, l.getClass().getSimpleName()));
            }
        }
        this.closeDatabase(connName, false, ref, false);
        Collection<Connection> extraConns = this.m_extraConns.get(connName);
        if (extraConns != null) {
            Iterator<Connection> iter = extraConns.iterator();
            while (iter.hasNext()) {
                Connection conn = iter.next();
                try {
                    if (!conn.isClosed()) {
                        DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(96, connName));
                        conn.close();
                    }
                    iter.remove();
                }
                catch (SQLException e) {
                    DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(11, connName), e);
                }
            }
        }
        for (DisconnectListener l : this.getDisconnectListeners()) {
            try {
                l.connectionDisconnected(ce);
            }
            catch (Exception e) {
                DatabaseConnections.getLogger().log(Level.WARNING, DBConnArb.format(59, l.getClass().getSimpleName()));
            }
        }
        return true;
    }

    @Override
    public void saveConnections() throws ConnectionException {
        try {
            this.getWrapper().saveDatabaseContext();
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(90, this.getMessage(nme)), nme);
        }
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    public boolean isCentralStore() {
        return "IdeConnections".equals(this.m_storeName);
    }

    private static Logger getLogger() {
        if (s_logger == null) {
            s_logger = DBLog.getLogger();
        }
        return s_logger;
    }

    public static DatabaseConnections getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseConnections("IdeConnections", null, null);
        }
        return s_instance;
    }

    public static DatabaseConnections getPrivateInstance(URL url) {
        DefaultContextWrapper wrapper = new DefaultContextWrapper(url);
        DatabaseConnections dc = new DatabaseConnections(url.toString(), wrapper, new CADatabaseFactory(wrapper));
        dc.m_privateStore = true;
        return dc;
    }

    public static void useStandaloneConnectionStore() {
        if (Product.isJDeveloper()) {
            throw new IllegalStateException("The database connection store cannot be overridden in JDeveloper.");
        }
        if (Ide.isRunning() && !DBConnAddin.isStarting()) {
            DatabaseConnections.getLogger().log(Level.SEVERE, DBConnArb.getString(54));
        } else {
            DatabaseContextManager.setContextWrapper(DefaultContextWrapper.getInstance());
            DatabaseProviderHelper.setUTMode((boolean)true);
        }
    }

    static void mav$fireConnectionUpdated(DatabaseConnections databaseConnections, ConnectionsEvent connectionsEvent) {
        databaseConnections.fireConnectionUpdated(connectionsEvent);
    }

    static boolean mav$doDisconnect(DatabaseConnections databaseConnections, String string, DatabaseProvider databaseProvider, boolean bl) {
        return databaseConnections.doDisconnect(string, databaseProvider, bl);
    }

    static DatabaseContextManager.ContextWrapper mav$getWrapper(DatabaseConnections databaseConnections) {
        return databaseConnections.getWrapper();
    }

    static Logger maS$getLogger() {
        return DatabaseConnections.getLogger();
    }

    static void mav$closeDatabase(DatabaseConnections databaseConnections, String string, boolean bl, DatabaseProvider databaseProvider, boolean bl2) {
        databaseConnections.closeDatabase(string, bl, databaseProvider, bl2);
    }

    static void mav$fireConnectionAdded(DatabaseConnections databaseConnections, ConnectionsEvent connectionsEvent) {
        databaseConnections.fireConnectionAdded(connectionsEvent);
    }

    private class ListenerBridge
    implements ObjectChangeListener,
    NamespaceChangeListener {
        private boolean m_listening;

        private void $init$() {
            this.m_listening = true;
        }

        public void namingExceptionThrown(NamingExceptionEvent evt) {
        }

        public void objectChanged(NamingEvent evt) {
            Binding binding;
            if (this.m_listening && (binding = evt.getNewBinding()).getObject() instanceof DatabaseProvider) {
                DatabaseConnections.mav$fireConnectionUpdated(DatabaseConnections.this, new ConnectionsEvent(evt.getOldBinding(), evt.getNewBinding()));
            }
        }

        public void objectAdded(NamingEvent evt) {
            Binding binding;
            if (this.m_listening && (binding = evt.getNewBinding()).getObject() instanceof DatabaseProvider) {
                DatabaseConnections.mav$fireConnectionAdded(DatabaseConnections.this, new ConnectionsEvent(binding));
            }
        }

        public void objectRemoved(NamingEvent evt) {
            Binding binding;
            Object ref;
            if (this.m_listening && (ref = (binding = evt.getOldBinding()).getObject()) instanceof DatabaseProvider) {
                String connName = binding.getName();
                try {
                    if (!DatabaseConnections.mav$doDisconnect(DatabaseConnections.this, connName, (DatabaseProvider)ref, false)) {
                        Context c = DatabaseConnections.mav$getWrapper(DatabaseConnections.this).getDatabaseContext();
                        try {
                            c.bind(connName, ref);
                        }
                        catch (NamingException ne) {
                            DatabaseConnections.maS$getLogger().log(Level.WARNING, "Error encountered replacing connection (disconnect has been vetoed)", ne);
                        }
                    } else if (ref != null) {
                        DatabaseConnections.mav$closeDatabase(DatabaseConnections.this, connName, true, (DatabaseProvider)ref, true);
                    }
                }
                catch (ConnectionException ce) {
                    DatabaseConnections.maS$getLogger().log(Level.WARNING, "Error encountered removing connection", ce);
                }
            }
        }

        public void objectRenamed(NamingEvent evt) {
            Binding binding = evt.getNewBinding();
            if (binding.getObject() instanceof DatabaseProvider) {
                DatabaseConnections.mav$fireConnectionUpdated(DatabaseConnections.this, new ConnectionsEvent(evt.getOldBinding(), evt.getNewBinding()));
            }
        }

        private ListenerBridge() {
            this.$init$();
        }

        static void wa$m_listening(ListenerBridge listenerBridge, boolean bl) {
            listenerBridge.m_listening = bl;
        }

        ListenerBridge(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

