/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.panels.TraversalException;
import oracle.jdevimpl.db.DBConnArb;

public class MissingDBConnValueException
extends TraversalException {
    private MissingDBConnValueException(String message, String title) {
        super(message, title);
    }

    public static void check(String value, String fieldName) throws MissingDBConnValueException {
        if (value == null || value.trim().length() == 0) {
            String s = StringUtils.stripMnemonic((String)fieldName);
            if (s.endsWith(":")) {
                s = s.substring(0, s.lastIndexOf(":"));
            }
            throw new MissingDBConnValueException(DBConnArb.format(98, s), DBConnArb.getString(45));
        }
    }

    public static void check(String value, JLabel label) throws MissingDBConnValueException {
        MissingDBConnValueException.check(value, label.getText());
    }

    public static void check(String value, JRadioButton butt) throws MissingDBConnValueException {
        MissingDBConnValueException.check(value, butt.getText());
    }

    public static void check(String value, JCheckBox cbx) throws MissingDBConnValueException {
        MissingDBConnValueException.check(value, cbx.getText());
    }
}

