/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;

public class ConnectionDetails
extends JPanel {
    private JLabel m_usernameLabel;
    private JLabel m_usernameField;
    private JLabel m_driverLabel;
    private JLabel m_driverField;
    private JLabel m_urlLabel;
    private JLabel m_urlField;

    public ConnectionDetails() {
        this.layoutComponents(this);
    }

    private void layoutComponents(JPanel detailsPanel) {
        detailsPanel.setLayout(new GridBagLayout());
        this.m_usernameLabel = new JLabel();
        this.m_usernameField = new JLabel();
        this.m_usernameLabel.setText(DBConnArb.getString(46));
        this.m_usernameLabel.setEnabled(false);
        this.m_driverLabel = new JLabel();
        this.m_driverField = new JLabel();
        this.m_driverLabel.setText(DBConnArb.getString(39));
        this.m_driverLabel.setEnabled(false);
        this.m_urlLabel = new JLabel();
        this.m_urlField = new JLabel();
        this.m_urlLabel.setText(DBConnArb.getString(64));
        this.m_urlLabel.setEnabled(false);
        Insets i = new Insets(5, 5, 5, 5);
        GridBagConstraints gblabel = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, i, 0, 0);
        GridBagConstraints gbfield = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, i, 0, 0);
        detailsPanel.add((Component)this.m_usernameLabel, gblabel);
        detailsPanel.add((Component)this.m_usernameField, gbfield);
        ++gblabel.gridy;
        ++gbfield.gridy;
        detailsPanel.add((Component)this.m_driverLabel, gblabel);
        detailsPanel.add((Component)this.m_driverField, gbfield);
        ++gblabel.gridy;
        ++gbfield.gridy;
        detailsPanel.add((Component)this.m_urlLabel, gblabel);
        detailsPanel.add((Component)this.m_urlField, gbfield);
    }

    public void setEnabled(boolean boo) {
        super.setEnabled(boo);
        this.m_usernameLabel.setEnabled(boo);
        this.m_driverLabel.setEnabled(boo);
        this.m_urlLabel.setEnabled(boo);
        if (!boo) {
            this.m_usernameField.setText(null);
            this.m_driverField.setText(null);
            this.m_urlField.setText(null);
            this.m_urlField.setToolTipText(null);
        }
    }

    public void populateDetails(DatabaseProvider connPro) {
        this.setEnabled(connPro != null);
        if (connPro != null) {
            this.m_usernameField.setText(connPro.getProperty("user"));
            try {
                this.m_driverField.setText(connPro.getDriverClassName());
            }
            catch (SQLException sqe) {
                this.m_driverField.setText(null);
            }
            try {
                String url = connPro.getConnectionURL();
                this.m_urlField.setText(url);
                this.m_urlField.setToolTipText(url);
            }
            catch (SQLException e) {
                this.m_urlField.setText(null);
                this.m_urlField.setToolTipText(null);
            }
        }
    }
}

