/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.naming.Referenceable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;

public class ConnectionList
extends JPanel {
    private NiceList m_list;
    private final SimpleListModel<String> m_listModel;
    private String m_storeName;
    private boolean m_oracleOnly;
    private final DatabaseConnectionStores m_stores;
    private String m_chosen;
    private Collection<ActionListener> m_listeners;

    private void $init$() {
        this.m_list = new NiceList();
        this.m_listModel = new SimpleListModel();
        this.m_stores = DatabaseConnectionStores.getInstance();
    }

    public ConnectionList(String storeName) {
        this(storeName, false);
    }

    public ConnectionList(String storeName, boolean oracleOnly) {
        this.$init$();
        this.m_storeName = storeName;
        this.m_oracleOnly = oracleOnly;
        this.m_list.setModel(this.m_listModel);
        this.m_list.setFireCheckboxActionOnSelectionChanged(true);
        this.m_list.setSelectionMode(0);
        this.m_list.setVisibleRowCount(5);
        this.m_list.setCellRenderer((ListCellRenderer)((Object)new Renderer()));
        this.m_list.addListActionListener((NiceListActionListener)new 1());
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)this.m_list), "Center");
        this.initList();
    }

    public void addActionListener(ActionListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<ActionListener>();
        }
        this.m_listeners.add(l);
    }

    private void initList() {
        this.m_listModel.removeAll();
        DatabaseConnections conns = this.m_stores.getStore(this.m_storeName);
        if (conns != null) {
            for (String name : new TreeSet<String>(conns.listConnections(this.m_oracleOnly))) {
                this.m_listModel.addElement((Object)name);
            }
        }
    }

    public Component getListComponent() {
        return this.m_list;
    }

    public String getConnectionName() {
        return (String)this.m_list.getSelectedValue();
    }

    public static final String chooseIdeConnection() {
        return ConnectionList.chooseConnection("IdeConnections", DBConnArb.getString(75));
    }

    public static final String chooseConnection(String storeName, String title) {
        ConnectionList panel = new ConnectionList(storeName);
        JEWTDialog dialog = JEWTDialog.createDialog((Component)Ide.getMainWindow(), (String)title, (int)3);
        dialog.setContent((Component)panel);
        if (dialog.runDialog()) {
            return panel.getConnectionName();
        }
        return null;
    }

    static DatabaseConnectionStores ra$m_stores(ConnectionList connectionList) {
        return connectionList.m_stores;
    }

    static String ra$m_storeName(ConnectionList connectionList) {
        return connectionList.m_storeName;
    }

    static String ra$m_chosen(ConnectionList connectionList) {
        return connectionList.m_chosen;
    }

    static SimpleListModel ra$m_listModel(ConnectionList connectionList) {
        return connectionList.m_listModel;
    }

    static void wa$m_chosen(ConnectionList connectionList, String string) {
        connectionList.m_chosen = string;
    }

    static Collection ra$m_listeners(ConnectionList connectionList) {
        return connectionList.m_listeners;
    }

    final class 1
    implements NiceListActionListener {
        public void listActionPerformed(NiceListActionEvent lae) {
            if (lae.getRow() < 0) {
                return;
            }
            if (lae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                String lastChosen = ConnectionList.ra$m_chosen(ConnectionList.this);
                ConnectionList.wa$m_chosen(ConnectionList.this, (String)ConnectionList.ra$m_listModel(ConnectionList.this).getElementAt(lae.getRow()));
                if (ModelUtil.areDifferent((Object)lastChosen, (Object)ConnectionList.ra$m_chosen(ConnectionList.this))) {
                    ConnectionList.ra$m_listModel(ConnectionList.this).changed(lae.getRow());
                    int i = 0;
                    while (i < ConnectionList.ra$m_listModel(ConnectionList.this).getSize()) {
                        String item = (String)ConnectionList.ra$m_listModel(ConnectionList.this).getElementAt(i);
                        if (ModelUtil.areEqual((Object)item, (Object)lastChosen)) {
                            ConnectionList.ra$m_listModel(ConnectionList.this).changed(i);
                        }
                        ++i;
                    }
                    if (ConnectionList.ra$m_listeners(ConnectionList.this) != null) {
                        ActionEvent e = new ActionEvent(ConnectionList.this, 0, null);
                        for (ActionListener l : ConnectionList.ra$m_listeners(ConnectionList.this)) {
                            l.actionPerformed(e);
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Renderer
    extends NiceListRenderer<String> {
        private Map<String, String> m_urls;

        private void $init$() {
            this.m_urls = new HashMap<String, String>();
        }

        Renderer() {
            this.$init$();
            this.setRadioButtonStyle(true);
        }

        protected boolean isItemSelected(String listItem) {
            return ModelUtil.areEqual((Object)listItem, (Object)ConnectionList.ra$m_chosen(ConnectionList.this));
        }

        protected String getTitle(String listItem) {
            return listItem;
        }

        protected String getDescription(String listItem) {
            return this.getURL(listItem);
        }

        private String getURL(String connName) {
            if (this.m_urls.containsKey(connName)) {
                return this.m_urls.get(connName);
            }
            String url = DBConnArb.getString(34);
            DatabaseConnections conns = ConnectionList.ra$m_stores(ConnectionList.this).getStore(ConnectionList.ra$m_storeName(ConnectionList.this));
            if (conns != null) {
                try {
                    Referenceable ref = conns.getReferenceable(connName);
                    if (ref instanceof DatabaseProvider) {
                        try {
                            String username = ((DatabaseProvider)ref).getProperty("user");
                            String connectURL = ((DatabaseProvider)ref).getConnectionURL();
                            url = DBConnArb.format(52, username, connectURL);
                        }
                        catch (SQLException sqe) {}
                    }
                }
                catch (ConnectionException ce) {
                    // empty catch block
                }
            }
            this.m_urls.put(connName, url);
            return url;
        }
    }
}

