/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPicker
extends JPanel {
    private PickerButton m_picker;
    private Collection<ItemListener> m_listeners;

    public ConnectionPicker() {
        this(true);
    }

    protected ConnectionPicker(boolean useNameAsText) {
        this.layoutComponents(useNameAsText);
    }

    private void layoutComponents(boolean useNameAsText) {
        this.removeAll();
        this.m_picker = new PickerButton(useNameAsText);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_picker), "Center");
    }

    private void setPickerName() {
        this.m_picker.setName(this.getName() + "Picker");
    }

    protected Collection<String> listConnections(DatabaseConnections dc) {
        return dc.listConnections();
    }

    public final boolean setSelectedConnection(String storeName, String connName) {
        return PickerButton.mav$setSelectedConnection(this.m_picker, storeName, connName);
    }

    protected void connectionSelected(ConnectionMenuItem cmi) {
    }

    public void resetConnections() {
        this.layoutComponents(PickerButton.ra$m_useNameAsText(this.m_picker));
    }

    public DatabaseProvider getReferenceable() {
        String storeName = this.getStoreName();
        String connName = this.getConnectionName();
        return DatabaseConnectionStores.getReferenceable(storeName, connName);
    }

    public String getConnectionName() {
        ConnectionMenuItem cmi = PickerButton.mav$getSelectedItem(this.m_picker);
        return cmi == null ? null : cmi.getConnectionName();
    }

    public String getStoreName() {
        ConnectionMenuItem cmi = PickerButton.mav$getSelectedItem(this.m_picker);
        return cmi == null ? null : cmi.getStoreName();
    }

    public void addItemListener(ItemListener il) {
        if (this.m_listeners == null) {
            this.m_listeners = new HashSet<ItemListener>();
        }
        this.m_listeners.add(il);
    }

    public void removeItemListener(ItemListener il) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(il);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setPickerName();
    }

    static Collection ra$m_listeners(ConnectionPicker connectionPicker) {
        return connectionPicker.m_listeners;
    }

    protected class StoreMenu
    extends JMenu {
        private String m_storeName;

        public StoreMenu(String storeName) {
            super(DBConnArb.format(0, DatabaseConnectionStores.getInstance().getShortLabel(storeName)));
            this.m_storeName = storeName;
        }

        public String getStoreName() {
            return this.m_storeName;
        }
    }

    protected class ConnectionMenuItem
    extends JMenuItem {
        private String m_storeName;
        private String m_connName;

        public ConnectionMenuItem(String storeName, String connName) {
            super(connName);
            this.m_connName = connName;
            this.m_storeName = storeName;
        }

        public String getStoreName() {
            return this.m_storeName;
        }

        public String getConnectionName() {
            return this.m_connName;
        }
    }

    private static class DummyAction
    extends ToggleAction {
        public DummyAction() {
            super("", null);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class PickerButton
    extends MenuToolButton
    implements ActionListener {
        private ConnectionMenuItem m_selected;
        private boolean m_useNameAsText;

        private void $init$() {
            this.m_useNameAsText = true;
        }

        protected PickerButton(boolean useNameAsText) {
            super((ToggleAction)new DummyAction());
            this.$init$();
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.setText(" ");
            this.m_useNameAsText = useNameAsText;
            this.addPopupMenuListener(new 1());
            MenuElement[] menuElementArray = this.getPopupMenu().getSubElements();
            int n = 0;
            while (n < menuElementArray.length) {
                MenuElement me = menuElementArray[n];
                if (me instanceof ConnectionMenuItem) {
                    this.selectConnection((ConnectionMenuItem)me);
                    break;
                }
                if (me instanceof StoreMenu) {
                    MenuElement[] menuElementArray2 = ((StoreMenu)me).getPopupMenu().getSubElements();
                    int n2 = 0;
                    while (n2 < menuElementArray2.length) {
                        MenuElement meme = menuElementArray2[n2];
                        if (meme instanceof ConnectionMenuItem) {
                            this.selectConnection((ConnectionMenuItem)meme);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }

        protected JPopupMenu createPopupMenu() {
            this._popup = new JPopupMenu();
            this.populateMenu(this._popup);
            return this._popup;
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            JPopupMenu pop = this.getPopupMenu();
            pop.setMinimumSize(new Dimension(width, pop.getMinimumSize().height));
            pop.setPreferredSize(new Dimension(width, pop.getPreferredSize().height));
        }

        private void populateMenu(JPopupMenu menu) {
            DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
            DatabaseConnections dc = stores.getStore("IdeConnections");
            boolean needBar = false;
            if (dc != null) {
                for (String name : ConnectionPicker.this.listConnections(dc)) {
                    ConnectionMenuItem connMI = this.createConnectionMenuItem("IdeConnections", name);
                    connMI.addActionListener(this);
                    menu.add(connMI);
                    needBar = true;
                }
            }
            Collection<String> storeNames = stores.listStores();
            for (String storeName : storeNames) {
                if ("IdeConnections".equals(storeName)) continue;
                StoreMenu storeMI = this.createStoreMenu(storeName);
                DatabaseConnections store = stores.getStore(storeName);
                if (!this.populateMenu(store, storeMI)) continue;
                if (needBar) {
                    menu.add(new JSeparator());
                    needBar = false;
                }
                menu.add(storeMI);
            }
        }

        private boolean populateMenu(DatabaseConnections dc, JMenu menu) {
            boolean added = false;
            Collection<String> conns = ConnectionPicker.this.listConnections(dc);
            for (String name : conns) {
                ConnectionMenuItem connMI = this.createConnectionMenuItem(dc.getStoreName(), name);
                connMI.addActionListener(this);
                menu.add(connMI);
                added = true;
            }
            return added;
        }

        private StoreMenu createStoreMenu(String storeName) {
            return new StoreMenu(storeName);
        }

        private ConnectionMenuItem createConnectionMenuItem(String storeName, String connName) {
            return new ConnectionMenuItem(storeName, connName);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof ConnectionMenuItem) {
                this.selectConnection((ConnectionMenuItem)source);
                MenuToolButton.MenuToolButtonModel model = (MenuToolButton.MenuToolButtonModel)this.getModel();
                model.setSelected(false);
            }
        }

        private String getSelectedText(ConnectionMenuItem connMI) {
            StringBuilder buff = new StringBuilder(connMI.getConnectionName());
            String storeName = connMI.getStoreName();
            if (!"IdeConnections".equals(storeName)) {
                buff.append(" (");
                buff.append(DatabaseConnectionStores.getInstance().getShortLabel(storeName));
                buff.append(")");
            }
            return buff.toString();
        }

        private ConnectionMenuItem getSelectedItem() {
            return this.m_selected;
        }

        private boolean setSelectedConnection(String storeName, String connName) {
            if (ModelUtil.hasLength((String)connName)) {
                ConnectionMenuItem found;
                JPopupMenu menu = this.getPopupMenu();
                if ((storeName == null || "IdeConnections".equals(storeName)) && (found = this.findConnection(menu.getSubElements(), connName)) != null) {
                    this.selectConnection(found);
                    return true;
                }
                MenuElement[] menuElementArray = menu.getSubElements();
                int n = 0;
                while (n < menuElementArray.length) {
                    MenuElement me = menuElementArray[n];
                    if (me instanceof StoreMenu) {
                        ConnectionMenuItem found2;
                        String menuName = ((StoreMenu)me).getStoreName();
                        if ((storeName == null || storeName.equals(menuName)) && (found2 = this.findConnection(((StoreMenu)me).getPopupMenu().getSubElements(), connName)) != null) {
                            this.selectConnection(found2);
                            return true;
                        }
                    }
                    ++n;
                }
            }
            return false;
        }

        private void selectConnection(ConnectionMenuItem cmi) {
            this.m_selected = cmi;
            if (this.m_useNameAsText) {
                this.setText(this.getSelectedText(this.m_selected));
            }
            ConnectionPicker.this.connectionSelected(cmi);
            if (ConnectionPicker.ra$m_listeners(ConnectionPicker.this) != null) {
                for (ItemListener l : ConnectionPicker.ra$m_listeners(ConnectionPicker.this)) {
                    l.itemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 1, cmi, 1));
                }
            }
        }

        private ConnectionMenuItem findConnection(MenuElement[] elems, String connName) {
            MenuElement[] menuElementArray = elems;
            int n = 0;
            while (n < menuElementArray.length) {
                String elemName;
                MenuElement me = menuElementArray[n];
                if (me instanceof ConnectionMenuItem && connName.equals(elemName = ((ConnectionMenuItem)me).getConnectionName())) {
                    return (ConnectionMenuItem)me;
                }
                ++n;
            }
            return null;
        }

        protected ItemListener createButtonItemListener() {
            return new ButtonItemListener2();
        }

        static ConnectionMenuItem mav$getSelectedItem(PickerButton pickerButton) {
            return pickerButton.getSelectedItem();
        }

        static boolean ra$m_useNameAsText(PickerButton pickerButton) {
            return pickerButton.m_useNameAsText;
        }

        static boolean mav$setSelectedConnection(PickerButton pickerButton, String string, String string2) {
            return pickerButton.setSelectedConnection(string, string2);
        }

        final class 1
        implements PopupMenuListener {
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MenuToolButton.MenuToolButtonModel model = (MenuToolButton.MenuToolButtonModel)PickerButton.this.getModel();
                model.setSelected(false);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                MenuToolButton.MenuToolButtonModel model = (MenuToolButton.MenuToolButtonModel)PickerButton.this.getModel();
                model.setSelected(false);
            }
        }

        protected class ButtonItemListener2
        extends MenuToolButton.ButtonItemListener {
            public ButtonItemListener2() {
                super((MenuToolButton)PickerButton.this);
            }

            public void itemStateChanged(ItemEvent e) {
                super.itemStateChanged(e);
            }
        }
    }
}

