/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.migration;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.security.misc.Checksum;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class CMConnectionsReader
extends DefaultHandler
implements LexicalHandler {
    public static final String DEFAULT_FILE = "connections.xml";
    public static final String DEFAULT_PROPERTIES_FILE = "connections.properties";
    public static final String CONNECTION_TAG = "connection";
    private static final String PWD_PROP = "PWD";
    private static final String ORMI_PWD_PROP = "ORMI-PWD";
    public static final String PASSWORD = "password";
    public static final String ORMI_PASSWD = "ormi-password";
    public static final String CONNECTION_NAME = "ConnectionName";
    public static final String CONNECTION_TYPE = "ConnectionType";
    private final String fName;
    private final boolean isAbsolutePath;
    private List _list;
    private Properties _curDesc;
    private String _curKey;
    private StringBuffer _curValue;
    private String _cdata;

    private void $init$() {
        this._list = null;
        this._curDesc = null;
    }

    public CMConnectionsReader() {
        this("/connections.xml", false);
    }

    public CMConnectionsReader(String fName, boolean isAbsolutePath) {
        this.$init$();
        this.fName = fName;
        this.isAbsolutePath = isAbsolutePath;
    }

    public final List read() {
        SAXParser parser = null;
        try {
            this._list = null;
            InputStream is = null;
            try {
                is = this.isAbsolutePath ? new FileInputStream(this.fName) : CMConnectionsReader.getInputStream(this.getClass(), this.fName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is != null) {
                try {
                    try {
                        parser = new SAXParser();
                        parser.setContentHandler((ContentHandler)this);
                        parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
                        parser.parse(is);
                    }
                    catch (SAXException saxEx) {}
                }
                finally {
                    if (parser != null) {
                        parser.reset();
                        parser = null;
                    }
                }
            }
            if (this._list == null || this._list.size() == 0) {
                this._list = this._readPCS();
            } else {
                List listPCS = this._readPCS();
                Iterator iterPCS = listPCS != null ? listPCS.iterator() : Collections.EMPTY_LIST.iterator();
                while (iterPCS.hasNext()) {
                    Properties cDesc = (Properties)iterPCS.next();
                    if (this._listContains(cDesc.getProperty(CONNECTION_NAME))) continue;
                    this._list.add(cDesc);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this._list;
    }

    private static InputStream getInputStream(Class clazz, String fName) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl != null ? cl.getResourceAsStream(fName) : null;
        if (is == null) {
            is = clazz.getResourceAsStream(fName);
        }
        return is;
    }

    private final List _readPCS() {
        List list = null;
        try {
            InputStream is;
            InputStream inputStream = is = this.isAbsolutePath ? new FileInputStream(this.fName) : CMConnectionsReader.getInputStream(this.getClass(), this.fName);
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                list = this.loadConnectionDescriptorsFromProperties(p);
            }
            if (!(list != null && list.size() != 0 || this.isAbsolutePath || (is = CMConnectionsReader.getInputStream(this.getClass(), "/connections.properties")) == null)) {
                Properties p = new Properties();
                p.load(is);
                list = this.loadConnectionDescriptorsFromProperties(p);
            }
        }
        catch (IOException ioEx) {
            List list2 = null;
            return list2;
        }
        return list;
    }

    private final List loadConnectionDescriptorsFromProperties(Properties p) throws IOException {
        ArrayList<Properties> list = null;
        String numConn = p.getProperty("CM_NumConnections");
        if (numConn != null) {
            int numConnections = Integer.parseInt(numConn);
            list = new ArrayList<Properties>(numConnections);
            int i = 1;
            while (i <= numConnections) {
                String pVal = p.getProperty("CM_Connection" + i);
                ByteArrayInputStream pStream = new ByteArrayInputStream(pVal.replace(',', '\n').getBytes());
                Properties cDesc = new Properties();
                cDesc.load(pStream);
                list.add(cDesc);
                ++i;
            }
        }
        return list;
    }

    private final boolean _listContains(String connName) {
        for (Properties c : this._list) {
            if (!c.getProperty(CONNECTION_NAME).equals(connName)) continue;
            return true;
        }
        return false;
    }

    public void startDocument() {
        if (this._list == null) {
            this._list = new ArrayList(10);
        } else {
            this._list.clear();
        }
    }

    public void endDocument() {
        this._curKey = null;
        this._curValue = null;
        this._curDesc = null;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (name.equals(CONNECTION_TAG)) {
            this._curDesc = new Properties();
            this._curKey = null;
            this._curValue = null;
            this._cdata = null;
        } else if (this._curDesc != null) {
            this._curKey = name;
            this._curValue = new StringBuffer();
            this._cdata = null;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (name.equals(CONNECTION_TAG)) {
            if (this._curDesc != null && this._curDesc.getProperty(CONNECTION_NAME) != null) {
                this._list.add(this._curDesc);
            }
            this._curDesc = null;
        } else if (this._curDesc != null && this._curKey != null) {
            String value = this._curValue.toString();
            if (CONNECTION_TYPE.equals(this._curKey) && "IAS".equals(this._curValue.toString())) {
                value = "OC4J";
            } else if ("IAS_HOME".equals(this._curKey)) {
                this._curKey = "OC4J_HOME";
            } else if ("PASSWORD".equals(this._curKey)) {
                if (this._curDesc.getProperty(PASSWORD) != null) {
                    this._curKey = null;
                }
            } else if (PWD_PROP.equals(this._curKey) || ORMI_PWD_PROP.equals(this._curKey)) {
                value = null;
                String string = this._curKey = PWD_PROP.equals(this._curKey) ? PASSWORD : ORMI_PASSWD;
                if (this._cdata != null) {
                    try {
                        byte[] enc = RepConversion.convertHexStringToByte(this._cdata);
                        byte[] decPwd = Checksum.SHA((byte[])enc, null);
                        value = new String(decPwd);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (this._curKey != null) {
                this._curDesc.put(this._curKey, value);
            }
        }
        this._curKey = null;
        this._curValue = null;
    }

    public void characters(char[] ch, int start, int length) {
        if (this._curKey != null) {
            this._curValue.append(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this._cdata = this._curValue.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this._curValue.setLength(0);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    private static class RepConversion {
        public static byte nibbleToHex(byte nibble) {
            return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
        }

        public static String bArray2String(byte[] array) {
            StringBuffer result = new StringBuffer(array.length * 2);
            int i = 0;
            while (i < array.length) {
                result.append((char)RepConversion.nibbleToHex((byte)((array[i] & 0xF0) >> 4)));
                result.append((char)RepConversion.nibbleToHex((byte)(array[i] & 0xF)));
                ++i;
            }
            return result.toString();
        }

        static int convertCharToInt(char charVal) {
            switch (charVal) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            return 48;
        }

        public static byte[] convertHexStringToByte(String refString) {
            byte[] byteArray = new byte[refString.length() / 2];
            int i = 0;
            while (i < refString.length()) {
                int intVal = RepConversion.convertCharToInt(refString.charAt(i));
                Integer newInt = new Integer(0xF0 & intVal << 4);
                byteArray[i / 2] = newInt.byteValue();
                intVal = RepConversion.convertCharToInt(refString.charAt(i + 1));
                newInt = new Integer(0xF & intVal);
                int n = i / 2;
                byteArray[n] = (byte)(byteArray[n] | newInt.byteValue());
                i += 2;
            }
            return byteArray;
        }

        private RepConversion() {
        }
    }
}

