/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.controls.ConnectionDetails;
import oracle.jdevimpl.db.DBConnArb;

abstract class AbstractConnectionPanelUI
extends JPanel
implements ActionListener {
    private boolean m_showDetails;
    private String[] m_subTypes;
    private JWrappedLabel m_promptLabel;
    private JLabel m_connectionsLabel;
    private JButton m_btnNew;
    private JButton m_btnEdit;
    private JPanel m_detailsPanel;
    private final DBUIResourceHelper m_reshelp;

    private void $init$() {
        this.m_showDetails = true;
        this.m_connectionsLabel = new JLabel();
        this.m_btnNew = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.m_btnEdit = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
    }

    protected AbstractConnectionPanelUI(boolean showDetails) {
        this(false, showDetails);
    }

    protected AbstractConnectionPanelUI(boolean oracleOnly, boolean showDetails) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, showDetails);
    }

    protected AbstractConnectionPanelUI(String[] dbSubTypes, boolean showDetails) {
        this.$init$();
        this.m_subTypes = dbSubTypes;
        this.m_showDetails = showDetails;
        this.initialise();
    }

    protected String[] getSubTypes() {
        return this.m_subTypes;
    }

    protected void initialise() {
        this.setLayout(new BorderLayout(0, 15));
        this.setConnectionPrompt(this.getPromptText());
        JPanel center = new JPanel();
        this.layoutComponents(center);
        this.add((Component)center, "Center");
    }

    protected DBUIResourceHelper getResourceHelper() {
        return this.m_reshelp;
    }

    private void layoutComponents(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0);
        panel.add((Component)this.m_connectionsLabel, gbc);
        ++gbc.gridx;
        GridBagConstraints gbcpicker = (GridBagConstraints)gbc.clone();
        gbcpicker.weightx = 1.0;
        gbcpicker.fill = 2;
        ++gbc.gridx;
        this.addButtons(panel, gbc);
        if (this.m_showDetails) {
            this.m_detailsPanel = this.getDetailsPanel();
            GridBagConstraints gbcdetails = new GridBagConstraints(0, ++y, gbc.gridx - 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 24, 0, 24), 0, 0);
            panel.add((Component)this.m_detailsPanel, gbcdetails);
        }
        panel.add(this.getPicker(), gbcpicker);
        this.setConnectionLabel(DBConnArb.getString(89));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addButtons(JPanel panel, GridBagConstraints gbc) {
        gbc.insets.right = 5;
        this.m_btnNew.addActionListener(this);
        this.m_btnNew.setToolTipText(DBConnArb.getString(5));
        this.m_btnNew.setMnemonic(StringUtils.getMnemonicKeyCode((String)DBConnArb.getString(101)));
        this.addButton(panel, this.m_btnNew, gbc, "New");
        ++gbc.gridx;
        this.m_btnEdit.addActionListener(this);
        this.m_btnEdit.setToolTipText(DBConnArb.getString(8));
        this.m_btnEdit.setMnemonic(StringUtils.getMnemonicKeyCode((String)DBConnArb.getString(12)));
        this.addButton(panel, this.m_btnEdit, gbc, "Edit");
        ++gbc.gridx;
    }

    protected void addButton(JPanel panel, JButton button, GridBagConstraints gbc, String name) {
        this.m_reshelp.setName((Component)button, name);
        IconicButtonUI.install((AbstractButton)button);
        panel.add((Component)button, gbc);
    }

    protected JPanel getDetailsPanel() {
        ConnectionDetails detailsPanel = new ConnectionDetails();
        return detailsPanel;
    }

    protected void enableButtons(boolean validConn) {
        if (this.isEnabled()) {
            this.m_btnEdit.setEnabled(validConn);
        }
    }

    public void enableActiveComponents(boolean boo) {
        this.m_btnNew.setEnabled(boo);
        if (boo) {
            this.checkConnection();
        } else {
            this.m_btnEdit.setEnabled(false);
            this.disableDetails();
        }
    }

    public void setEnabled(boolean boo) {
        super.setEnabled(boo);
        if (this.m_promptLabel != null) {
            this.m_promptLabel.setEnabled(boo);
        }
        this.m_connectionsLabel.setEnabled(boo);
        this.enableActiveComponents(boo);
    }

    protected void checkConnection() {
        DatabaseProvider connPro = this.getReferenceable();
        if (connPro != null) {
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
        if (this.m_showDetails) {
            this.populateDetails(connPro);
        }
    }

    protected void disableDetails() {
        if (this.m_showDetails) {
            this.m_detailsPanel.setEnabled(false);
        }
    }

    protected void populateDetails(DatabaseProvider connPro) {
        if (this.m_detailsPanel instanceof ConnectionDetails) {
            ((ConnectionDetails)this.m_detailsPanel).populateDetails(connPro);
        }
    }

    protected String getPromptText() {
        return DBConnArb.getString(88);
    }

    public void setConnectionLabel(String label) {
        ResourceUtils.resLabel((JLabel)this.m_connectionsLabel, (Component)this.getPicker(), (String)label);
        this.validate();
    }

    public void setConnectionPrompt(String prompt) {
        if (ModelUtil.hasLength((String)prompt)) {
            this.m_promptLabel = new JWrappedLabel(prompt);
            this.add((Component)this.m_promptLabel, "North");
        } else if (this.m_promptLabel != null) {
            this.remove((Component)this.m_promptLabel);
            this.m_promptLabel = null;
        }
        this.validate();
    }

    public Component getDefaultFocusComponent() {
        return this.m_btnNew;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_btnNew) {
            this.launchConnectionDialog(false);
        } else if (source == this.m_btnEdit) {
            this.launchConnectionDialog(true);
        }
    }

    protected abstract String getComponentNamePrefix();

    protected abstract DatabaseProvider getReferenceable();

    protected abstract Component getPicker();

    protected abstract void launchConnectionDialog(boolean var1);
}

