/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPanelUI
extends AbstractConnectionPanelUI
implements ItemListener {
    private static final String LAST_CONNECTION_KEY = "ConnectionPanelUI.LAST_CONNECTION_KEY";
    private boolean m_canAddNull;
    private DefaultComboBoxModel m_connectionsModel;
    private JComboBox m_connections;

    public ConnectionPanelUI(boolean showDetails) {
        this(false, showDetails);
    }

    public ConnectionPanelUI(boolean oracleOnly, boolean showDetails) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, showDetails);
    }

    public ConnectionPanelUI(String[] subTypes, boolean showDetails) {
        super(subTypes, showDetails);
        this.getResourceHelper().setName((Component)this.m_connections, "Connection");
        this.resetConnections();
    }

    @Override
    protected String getComponentNamePrefix() {
        return "ConnectionPanelUI";
    }

    @Override
    protected Component getPicker() {
        if (this.m_connections == null) {
            this.m_connectionsModel = new NonNullableComboBoxModel();
            this.m_connections = new JComboBox(this.m_connectionsModel);
        }
        return this.m_connections;
    }

    public String getConnectionName() {
        return (String)this.m_connectionsModel.getSelectedItem();
    }

    public boolean setConnectionName(String name) {
        if (this.m_connectionsModel.getIndexOf(name) != -1) {
            this.m_connectionsModel.setSelectedItem(name);
            return true;
        }
        if (!ModelUtil.hasLength((String)name) && this.m_canAddNull) {
            this.m_connections.setSelectedIndex(-1);
            return true;
        }
        return false;
    }

    protected boolean getCanAddNull() {
        return this.m_canAddNull;
    }

    public void setCanAddNull(boolean boo) {
        if (this.m_canAddNull != boo) {
            this.m_connectionsModel = boo ? new DefaultComboBoxModel() : new NonNullableComboBoxModel();
            this.m_connections = new JComboBox(this.m_connectionsModel);
        }
        this.m_canAddNull = boo;
    }

    protected DatabaseConnections getConnections() {
        return DatabaseConnections.getInstance();
    }

    protected Collection<String> listConnections() {
        DatabaseConnections conns = this.getConnections();
        return conns.listConnections(this.getSubTypes());
    }

    public int resetConnections() {
        this.m_connections.removeItemListener(this);
        String cname = (String)this.m_connectionsModel.getSelectedItem();
        this.m_connectionsModel.removeAllElements();
        Collection<String> connections = this.listConnections();
        if (connections != null) {
            for (String connName : new TreeSet<String>(connections)) {
                this.m_connectionsModel.addElement(connName);
            }
        }
        if (ModelUtil.hasLength((String)cname) && this.m_connectionsModel.getIndexOf(cname) >= 0) {
            this.m_connectionsModel.setSelectedItem(cname);
        } else {
            this.loadSettings();
        }
        this.m_connections.addItemListener(this);
        this.checkConnection();
        return this.m_connectionsModel.getSize();
    }

    @Override
    protected final DatabaseProvider getReferenceable() {
        String currConn = this.getConnectionName();
        DatabaseProvider connPro = null;
        try {
            connPro = currConn == null ? null : (DatabaseProvider)this.getConnections().getReferenceable(currConn);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        return connPro;
    }

    protected String getSettingsKey() {
        return LAST_CONNECTION_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    public void loadSettings() {
        String key = this.getSettingsKey();
        if (key != null) {
            String lastConn = this.getPropertyStorage().getProperties().getString(key);
            this.setConnectionName(lastConn);
        }
    }

    public void saveSettings() {
        String conn;
        String key = this.getSettingsKey();
        if (key != null && ModelUtil.hasLength((String)(conn = this.getConnectionName()))) {
            this.getPropertyStorage().getProperties().putString(key, conn);
        }
    }

    protected String runConnectionDialog(String conn) {
        return DatabaseConnectionEditor.editConnection("IdeConnections", conn);
    }

    @Override
    public void enableActiveComponents(boolean boo) {
        super.enableActiveComponents(boo);
        this.m_connections.setEnabled(boo);
    }

    @Override
    protected void launchConnectionDialog(boolean edit) {
        if (edit) {
            String newConn = this.runConnectionDialog(this.getConnectionName());
            if (this.resetConnections() <= 0 || ModelUtil.hasLength((String)newConn)) {
                // empty if block
            }
            this.setConnectionName(newConn);
        } else {
            String newConn = this.runConnectionDialog(null);
            if (this.resetConnections() <= 0 || ModelUtil.hasLength((String)newConn)) {
                // empty if block
            }
            this.setConnectionName(newConn);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.checkConnection();
    }

    @Override
    public Component getDefaultFocusComponent() {
        if (this.m_connectionsModel.getSize() < 1) {
            return super.getDefaultFocusComponent();
        }
        return this.m_connections;
    }

    public JComboBox getConnCombo() {
        return this.m_connections;
    }

    public void addComboListener(ItemListener itemListener) {
        this.m_connections.addItemListener(itemListener);
    }

    public void removeComboListener(ItemListener itemListener) {
        this.m_connections.removeItemListener(itemListener);
    }

    public static String getConnection(String title, String prompt, String connName, boolean oracleOnly) {
        ConnectionPanelUI panel = new ConnectionPanelUI(oracleOnly, true);
        panel.setConnectionPrompt(prompt);
        return ConnectionPanelUI.getConnection(panel, title, connName);
    }

    protected static String getConnection(ConnectionPanelUI panel, String title, String connName) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_odbselectconnection_html");
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultFocusComponent(), (String)title);
        panel.addComboListener(new 1(panel, dlg));
        if (connName != null) {
            panel.setConnectionName(connName);
        }
        dlg.setOKButtonEnabled(panel.getConnectionName() != null);
        dlg.setMinimumSize(new Dimension(400, 200));
        dlg.setName(panel.getComponentNamePrefix() + "Dialog");
        return WizardLauncher.runDialog((JDialog)dlg) ? panel.getConnectionName() : null;
    }

    static final class 1
    implements ItemListener {
        private final /* synthetic */ ConnectionPanelUI v$panel;
        private final /* synthetic */ JEWTDialog v$dlg;

        public void itemStateChanged(ItemEvent e) {
            boolean sel = this.v$panel.getConnectionName() != null;
            this.v$dlg.setOKButtonEnabled(sel);
        }

        public 1(ConnectionPanelUI connectionPanelUI, JEWTDialog jEWTDialog) {
            this.v$dlg = jEWTDialog;
            this.v$panel = connectionPanelUI;
        }
    }
}

