/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.controls.ConnectionPicker;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;

public class GlobalConnectionPanelUI
extends AbstractConnectionPanelUI {
    private ConnectionPicker m_picker;

    public GlobalConnectionPanelUI(boolean oracleOnly) {
        super(oracleOnly, true);
    }

    public GlobalConnectionPanelUI(String[] subTypes) {
        super(subTypes, true);
    }

    protected String getComponentNamePrefix() {
        return "GlobalConnectionPanelUI";
    }

    protected DatabaseProvider getReferenceable() {
        return this.m_picker == null ? null : this.m_picker.getReferenceable();
    }

    public Component getPicker() {
        if (this.m_picker == null) {
            this.m_picker = new 1();
        }
        this.checkConnection();
        return this.m_picker;
    }

    protected void launchConnectionDialog(boolean edit) {
        if (edit) {
            DatabaseConnectionEditor.editConnection(this.m_picker.getStoreName(), this.m_picker.getConnectionName(), true);
        } else {
            String newConn = DatabaseConnectionEditor.editConnection(this.m_picker.getStoreName(), null, true);
            if (newConn != null) {
                this.m_picker.resetConnections();
                this.m_picker.setSelectedConnection(null, newConn);
            }
        }
    }

    public static ChosenConnection getConnection(String title, String prompt, String storeName, String connName) {
        return GlobalConnectionPanelUI.getConnection(title, prompt, storeName, connName, false);
    }

    public static ChosenConnection getConnection(String title, String prompt, String storeName, String connName, boolean oraOnly) {
        GlobalConnectionPanelUI panel = new GlobalConnectionPanelUI(oraOnly);
        panel.setConnectionPrompt(prompt);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_odbselectconnection_html");
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultFocusComponent(), (String)title);
        ConnectionPicker picker = panel.m_picker;
        picker.addItemListener(new 2(dlg, picker));
        if (connName != null) {
            picker.setSelectedConnection(storeName, connName);
        }
        Dimension dim = new Dimension(400, 200);
        dlg.setMinimumSize(dim);
        dlg.setOKButtonEnabled(picker.getConnectionName() != null);
        dlg.setName(panel.getComponentNamePrefix() + "Dialog");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return new ChosenConnection(picker.getStoreName(), picker.getConnectionName());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 1
    extends ConnectionPicker {
        @Override
        protected void connectionSelected(ConnectionPicker.ConnectionMenuItem cmi) {
            super.connectionSelected(cmi);
            ChosenConnection cc = new ChosenConnection(cmi.getStoreName(), cmi.getConnectionName());
            GlobalConnectionPanelUI.this.populateDetails(cc.getReferenceable());
            GlobalConnectionPanelUI.this.checkConnection();
        }

        @Override
        protected Collection<String> listConnections(DatabaseConnections dc) {
            return dc.listConnections(GlobalConnectionPanelUI.this.getSubTypes());
        }
    }

    static final class 2
    implements ItemListener {
        private final /* synthetic */ JEWTDialog v$dlg;
        private final /* synthetic */ ConnectionPicker v$picker;

        public void itemStateChanged(ItemEvent ie) {
            this.v$dlg.setOKButtonEnabled(this.v$picker.getConnectionName() != null);
        }

        public 2(JEWTDialog jEWTDialog, ConnectionPicker connectionPicker) {
            this.v$picker = connectionPicker;
            this.v$dlg = jEWTDialog;
        }
    }

    public static class ChosenConnection {
        private String m_storeName;
        private String m_connName;

        public ChosenConnection(String storeName, String connName) {
            this.m_storeName = storeName;
            this.m_connName = connName;
        }

        public String getStoreName() {
            return this.m_storeName;
        }

        public String getConnectionName() {
            return this.m_connName;
        }

        public String getQualifiedName() {
            String toEncode = this.m_storeName == null ? this.m_connName : this.m_storeName + "#" + this.m_connName;
            try {
                String string = URLEncoder.encode(toEncode, "utf-8");
                return string;
            }
            catch (UnsupportedEncodingException uee) {
                String string = toEncode;
                return string;
            }
        }

        public DatabaseProvider getReferenceable() {
            return DatabaseConnectionStores.getReferenceable(this.m_storeName, this.m_connName);
        }
    }
}

