/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdevimpl.db.DBConnArb;

public final class OraclePanel
extends DefaultTraversablePanel
implements ActionListener {
    private final JComboBox cmbDriver;
    private final JTextField fldHost;
    private final WholeNumberField fldPort;
    private final JTextField fldSid;
    private final JTextField fldServiceName;
    private final JRadioButton rdbSidSelector;
    private final JRadioButton rdbServiceNameSelector;
    private final ButtonGroup rbgSelectorGroup;
    private final JLabel lblDriver;
    private final JLabel lblHost;
    private final JLabel lblJdbcPort;
    private final String ONE_SPACE;
    private final String[] ORA_DRIVER_TYPES;
    private final JCheckBox chkAdv;
    private final JTextArea taURL;
    private final JScrollPane spURL;
    private DocumentListener DL;

    private void $init$() {
        this.cmbDriver = new JComboBox();
        this.fldHost = new JTextField();
        this.fldPort = new WholeNumberField(4);
        this.fldSid = new JTextField();
        this.fldServiceName = new JTextField();
        this.rdbSidSelector = new JRadioButton();
        this.rdbServiceNameSelector = new JRadioButton();
        this.rbgSelectorGroup = new ButtonGroup();
        this.lblDriver = new JLabel();
        this.lblHost = new JLabel();
        this.lblJdbcPort = new JLabel();
        this.ONE_SPACE = " ";
        this.ORA_DRIVER_TYPES = new String[]{DBConnArb.getString(80), DBConnArb.getString(103)};
        this.chkAdv = new JCheckBox();
        this.taURL = new JTextArea();
        this.spURL = new JScrollPane();
        this.DL = new 1();
    }

    public OraclePanel() {
        this.$init$();
        JLabel lblSid = new JLabel();
        JLabel lblServiceName = new JLabel();
        ResourceUtils.resLabel((JLabel)this.lblDriver, (Component)this.cmbDriver, (String)DBConnArb.getString(79));
        ResourceUtils.resLabel((JLabel)this.lblHost, (Component)this.fldHost, (String)DBConnArb.getString(63));
        ResourceUtils.resLabel((JLabel)this.lblJdbcPort, (Component)this.fldPort, (String)DBConnArb.getString(78));
        ResourceUtils.resLabel((JLabel)lblSid, (Component)this.fldSid, (String)DBConnArb.getString(19));
        lblSid.setVisible(false);
        ResourceUtils.resLabel((JLabel)lblServiceName, (Component)this.fldServiceName, (String)DBConnArb.getString(51));
        lblServiceName.setVisible(false);
        ResourceUtils.resButton((AbstractButton)this.chkAdv, (String)DBConnArb.getString(55));
        this.fldHost.getDocument().addDocumentListener(this.DL);
        this.fldPort.getDocument().addDocumentListener(this.DL);
        this.fldSid.getDocument().addDocumentListener(this.DL);
        this.fldServiceName.getDocument().addDocumentListener(this.DL);
        this.fldHost.setText("localhost");
        this.fldPort.setNumber((Number)new Integer(1521));
        this.fldPort.setColumns(8);
        this.fldSid.setText("XE");
        this.fldServiceName.setText("XE");
        this.rdbSidSelector.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.rdbSidSelector, (String)DBConnArb.getString(62));
        this.rdbSidSelector.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.rdbServiceNameSelector, (String)DBConnArb.getString(65));
        this.rdbServiceNameSelector.addActionListener(this);
        this.rbgSelectorGroup.add(this.rdbSidSelector);
        this.rbgSelectorGroup.add(this.rdbServiceNameSelector);
        this.chkAdv.addActionListener(this);
        this.taURL.setLineWrap(true);
        this.taURL.setText("");
        this.taURL.setRows(6);
        this.spURL.setHorizontalScrollBarPolicy(31);
        this.spURL.setVerticalScrollBarPolicy(20);
        this.spURL.getViewport().add(this.taURL);
        DefaultComboBoxModel<String> driverModel = new DefaultComboBoxModel<String>();
        driverModel.addElement(this.ORA_DRIVER_TYPES[0]);
        driverModel.addElement(this.ORA_DRIVER_TYPES[1]);
        this.cmbDriver.setModel(driverModel);
        this.setLayout(new GridBagLayout());
        Insets in5500 = new Insets(5, 0, 0, 0);
        Insets in5G05 = new Insets(5, 12, 0, 0);
        Insets in5GG05 = new Insets(5, 24, 0, 0);
        this.add(this.chkAdv, this.gbc(0, 0, 5, 1, 0.0, 0.0, 17, 0, in5500));
        this.add(this.lblDriver, this.gbc(0, 1, 2, 1, 0.0, 0.0, 17, 0, in5500));
        this.add(this.cmbDriver, this.gbc(2, 1, 1, 1, 1.0, 0.0, 10, 2, in5G05));
        this.add(this.lblHost, this.gbc(0, 2, 2, 1, 0.0, 0.0, 17, 0, in5500));
        this.add(this.fldHost, this.gbc(2, 2, 1, 1, 1.0, 0.0, 10, 2, in5G05));
        this.add(this.lblJdbcPort, this.gbc(3, 2, 1, 1, 0.0, 0.0, 17, 0, in5GG05));
        this.add((Component)this.fldPort, this.gbc(4, 2, 1, 1, 0.0, 0.0, 10, 2, in5G05));
        this.add(this.rdbSidSelector, this.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 0, in5500));
        this.add(lblSid, this.gbc(2, 4, 1, 1, 0.0, 0.0, 10, 2, in5G05));
        this.add(this.fldSid, this.gbc(2, 4, 1, 1, 1.0, 0.0, 10, 2, in5G05));
        this.add(this.rdbServiceNameSelector, this.gbc(0, 5, 1, 1, 0.0, 0.0, 17, 0, in5500));
        this.add(lblServiceName, this.gbc(2, 5, 1, 1, 0.0, 0.0, 10, 2, in5G05));
        this.add(this.fldServiceName, this.gbc(2, 5, 1, 1, 1.0, 0.0, 10, 2, in5G05));
        this.add(this.spURL, this.gbc(0, 8, 5, 1, 1.0, 1.0, 10, 1, in5500));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 3, 1, 1.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.enableControls();
        this.setHelpID("f1_dbconnection_html");
        String pnlName = "OraclePanel.";
        this.cmbDriver.setName("OraclePanel.Driver");
        this.fldHost.setName("OraclePanel.Host");
        this.fldPort.setName("OraclePanel.Port");
        this.rdbSidSelector.setName("OraclePanel.SID");
        this.rdbServiceNameSelector.setName("OraclePanel.ServiceName");
        this.fldSid.setName("OraclePanel.SIDValue");
        this.fldServiceName.setName("OraclePanel.ServiceNameValue");
        this.chkAdv.setName("OraclePanel.Advanced");
        this.spURL.setName("OraclePanel.AdvancedURL");
    }

    public void onEntry(TraversableContext tc) {
        String host;
        Properties connectionProps = (Properties)tc.get("NewObject");
        String url = connectionProps.getProperty("customUrl");
        if (url != null) {
            if (" ".equals(url)) {
                this.chkAdv.setSelected(true);
                this.taURL.setText("");
            } else if (url.length() > 0) {
                this.chkAdv.setSelected(true);
                this.taURL.setText(url);
            }
        }
        if ((host = connectionProps.getProperty("hostname")) == null) {
            host = "localhost";
        }
        String jdbc_port = connectionProps.getProperty("port");
        String sid = connectionProps.getProperty("sid");
        String dt = connectionProps.getProperty("oraDriverType");
        String serviceName = connectionProps.getProperty("serviceName");
        this.fldHost.setText(host);
        if (jdbc_port != null) {
            this.fldPort.setNumber((Number)new Integer(jdbc_port));
        } else {
            this.fldPort.setNumber((Number)new Integer(1521));
        }
        if (serviceName != null && sid == null) {
            this.rdbServiceNameSelector.setSelected(true);
        } else {
            this.rdbSidSelector.setSelected(true);
        }
        if (sid == null && serviceName == null) {
            sid = "XE";
            serviceName = "XE";
        }
        this.fldSid.setText(sid);
        this.fldServiceName.setText(serviceName);
        if (dt == null) {
            dt = this.ORA_DRIVER_TYPES[0];
        }
        this.cmbDriver.setSelectedItem(dt);
        this.enableControls();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        Properties connectionProps = (Properties)tc.get("NewObject");
        this.validatePanel(tc);
        int driverIndex = this.cmbDriver.getSelectedIndex();
        if (driverIndex < 0) {
            driverIndex = 0;
        }
        String dt = this.ORA_DRIVER_TYPES[driverIndex];
        String host = this.fldHost.getText();
        Number portNum = this.fldPort.getNumber();
        String port = portNum != null ? portNum.toString() : null;
        String sid = this.fldSid.getText();
        String serviceName = this.fldServiceName.getText();
        connectionProps.put("hostname", host);
        connectionProps.put("port", port);
        connectionProps.put("oraDriverType", dt);
        if (this.rdbSidSelector.isSelected()) {
            connectionProps.put("sid", sid);
            connectionProps.remove("serviceName");
        } else {
            connectionProps.put("serviceName", serviceName);
            connectionProps.remove("sid");
        }
        if (this.chkAdv.isVisible() && this.chkAdv.isSelected()) {
            String url = this.taURL.getText();
            if (!ModelUtil.hasLength((String)url)) {
                connectionProps.put("customUrl", " ");
            } else {
                connectionProps.put("customUrl", url.trim());
            }
            MissingDBConnValueException.check(url, DBConnArb.getString(74));
        } else {
            connectionProps.remove("customUrl");
        }
    }

    protected void validatePanel(TraversableContext tc) throws TraversalException {
        String host = this.fldHost.getText();
        Number portNum = this.fldPort.getNumber();
        String port = portNum != null ? portNum.toString() : null;
        String sid = this.fldSid.getText();
        String serviceName = this.fldServiceName.getText();
        MissingDBConnValueException.check(host, this.lblHost);
        MissingDBConnValueException.check(port, this.lblJdbcPort);
        if (port.equals("0")) {
            MissingDBConnValueException.check(null, this.lblJdbcPort);
        }
        if (this.rdbSidSelector.isSelected()) {
            MissingDBConnValueException.check(sid, this.rdbSidSelector);
        }
        if (this.rdbServiceNameSelector.isSelected()) {
            MissingDBConnValueException.check(serviceName, this.rdbServiceNameSelector);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.enableControls();
        if (e.getActionCommand().equals(DBConnArb.getString(65))) {
            this.fldServiceName.requestFocus();
        } else if (e.getActionCommand().equals(DBConnArb.getString(62))) {
            this.fldSid.requestFocus();
        }
    }

    private void enableControls() {
        if (this.chkAdv.isSelected()) {
            this.lblDriver.setVisible(false);
            this.lblHost.setVisible(false);
            this.lblJdbcPort.setVisible(false);
            this.cmbDriver.setVisible(false);
            this.fldHost.setVisible(false);
            this.fldPort.setVisible(false);
            this.fldSid.setVisible(false);
            this.fldServiceName.setVisible(false);
            this.rdbSidSelector.setVisible(false);
            this.rdbServiceNameSelector.setVisible(false);
            this.taURL.setVisible(true);
            this.spURL.setVisible(true);
        } else {
            this.lblDriver.setVisible(true);
            this.lblHost.setVisible(true);
            this.lblJdbcPort.setVisible(true);
            this.cmbDriver.setVisible(true);
            this.fldHost.setVisible(true);
            this.fldPort.setVisible(true);
            this.fldSid.setVisible(true);
            this.fldServiceName.setVisible(true);
            this.rdbSidSelector.setVisible(true);
            this.rdbServiceNameSelector.setVisible(true);
            this.taURL.setVisible(false);
            this.spURL.setVisible(false);
            if (this.rdbSidSelector.isSelected()) {
                this.fldSid.setEnabled(true);
                this.fldServiceName.setEnabled(false);
            } else {
                this.fldSid.setEnabled(false);
                this.fldServiceName.setEnabled(true);
            }
        }
        this.validate();
        this.repaint();
    }

    final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent evt) {
        }

        public void removeUpdate(DocumentEvent evt) {
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }
}

