/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.migration.Migrator;
import oracle.ide.util.Assert;
import oracle.javatools.db.DBLog;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.AbstractDBMigrator;
import oracle.jdevimpl.db.adapter.CMHelper;

public class DBConnMigrator
extends AbstractDBMigrator
implements Migrator,
IdeListener {
    private static final String CM_CONNECTIONS_FILE = "IDEConnections.xml";
    private Map<String, Properties> m_connections;
    private Map<String, Properties> m_connectionDescriptors;
    private static final Map<String, String> s_databaseConnectionType = new HashMap<String, String>();

    private void $init$() {
        this.m_connections = new HashMap<String, Properties>();
        this.m_connectionDescriptors = new HashMap<String, Properties>();
    }

    static {
        s_databaseConnectionType.put("JDBC", "Oracle (JDBC)");
        s_databaseConnectionType.put("JDBC_ODBC", "JDBC_ODBC_NAME");
        s_databaseConnectionType.put("BI_JDBC", "BI (JDBC)");
        s_databaseConnectionType.put("FTP", "FTP");
        s_databaseConnectionType.put("JNDI", "JNDI");
        s_databaseConnectionType.put("ORACLE_LITE", "Oracle Lite");
        s_databaseConnectionType.put("OTHER_JDBC", "Third Party JDBC Driver");
    }

    public DBConnMigrator() {
        this.$init$();
    }

    protected String getExtensionID() {
        return "oracle.jdeveloper.db.connection";
    }

    private File getOldConnectionsFile(File sourceDir) {
        return this.findExtensionFile(sourceDir, new String[]{"oracle.onlinedb", "oracle.j2ee"}, CM_CONNECTIONS_FILE);
    }

    public boolean canMigrate(int category, File sourceDir) {
        return this.getOldConnectionsFile(sourceDir) != null;
    }

    public String[] migrate(File sourceDir, File destDir) {
        String[] result = new String[]{};
        File src = this.getOldConnectionsFile(sourceDir);
        if (src == null) {
            DBLog.log((String)"No database connections found to migrate", (Object[])new Object[0]);
            return result;
        }
        CMConnectionsReader reader = new CMConnectionsReader(src.getAbsolutePath(), true);
        try {
            String[] dbNames = this.getDatabaseConnectionNames(reader);
            int i = 0;
            while (i < dbNames.length) {
                try {
                    Properties cd = this.m_connectionDescriptors.get(dbNames[i]);
                    this.m_connections.put(dbNames[i], cd);
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
        if (this.m_connections.size() > 0) {
            Ide.addIdeListener((IdeListener)this);
        }
        return result;
    }

    public String[] getDatabaseConnectionNames(CMConnectionsReader store) throws IOException {
        this.loadConnectionDescriptors(store);
        ArrayList<String> l = new ArrayList<String>();
        for (Properties d : this.m_connectionDescriptors.values()) {
            String typ;
            String typeName = d.getProperty("ConnectionType");
            if (typeName == null || (typ = s_databaseConnectionType.get(typeName)) == null) continue;
            l.add(d.getProperty("ConnectionName"));
        }
        return l.toArray(new String[l.size()]);
    }

    private void loadConnectionDescriptors(CMConnectionsReader store) throws IOException {
        List cl = store.read();
        if (cl == null) {
            return;
        }
        for (Properties cDesc : cl) {
            this.m_connectionDescriptors.put(cDesc.getProperty("ConnectionName"), cDesc);
        }
    }

    public void addinsLoaded(IdeEvent e) {
        Context context;
        if (this.m_connections.size() > 0 && (context = DatabaseContextManager.getDatabaseContext()) != null) {
            for (String name : this.m_connections.keySet()) {
                try {
                    Properties props = this.m_connections.get(name);
                    Referenceable ref = CMHelper.createReferenceFromDescriptor((Properties)props);
                    context.bind(name, (Object)ref);
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
            }
            try {
                DatabaseContextManager.getContextWrapper().saveDatabaseContext();
            }
            catch (NamingException f) {
                // empty catch block
            }
        }
        Ide.removeIdeListener((IdeListener)this);
    }

    public void mainWindowOpened(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }
}

