/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.panels.ConnectionEditorPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEditor
implements DatabaseConnectionEditor.ConnectionEditor {
    private static Class<? extends DefaultEditor> s_override;
    private StoreChoice m_storeChoice;

    private void $init$() {
        this.m_storeChoice = StoreChoice.CONTEXT;
    }

    public DefaultEditor() {
        this.$init$();
    }

    protected Context getContext() {
        return Context.newIdeContext();
    }

    protected Connections getConnections() {
        return DatabaseConnectionStores.getInstance().getCurrentStore(this.getContext());
    }

    protected String getDefaultConnName() {
        return DBConnArb.getString(56);
    }

    protected String getDefaultSubtype() {
        return "oraJDBC";
    }

    protected Traversable getPanel() {
        return new ConnectionEditorPanel(null);
    }

    protected Component getDefaultFocusComponent(Traversable panel) {
        return ((ConnectionEditorPanel)panel).getDefaultFocusComponent();
    }

    protected String getTitle(boolean edit) {
        return edit ? DBConnArb.getString(37) : DBConnArb.getString(31);
    }

    protected String getHeaderText(boolean edit) {
        return edit ? DBConnArb.getString(58) : DBConnArb.getString(13);
    }

    protected void setupNamespace(Namespace data) {
    }

    public void setStoreChoice(StoreChoice choice) {
        if (choice != null) {
            this.m_storeChoice = choice;
        }
    }

    protected StoreChoice getStoreChoice() {
        return this.m_storeChoice;
    }

    @Override
    public final String launchEditor(String connName) {
        return this.launchEditor(null, connName);
    }

    @Override
    public final String launchEditor(String storeName, String connName) {
        Connections conns = null;
        if (ModelUtil.hasLength((String)storeName)) {
            conns = DatabaseConnectionStores.getInstance().getStore(storeName);
        }
        if (conns == null) {
            conns = this.getConnections();
        }
        return this.launchEditor(connName, conns);
    }

    protected String launchEditor(String connName, Connections conns) {
        Traversable panel = this.getPanel();
        Frame parent = IdeUtil.getMainWindow();
        Component defaultComp = this.getDefaultFocusComponent(panel);
        Properties props = null;
        if (ModelUtil.hasLength((String)connName)) {
            try {
                props = conns.getProperties(connName);
            }
            catch (ConnectionException ce) {
                DBLog.getLogger().log(Level.SEVERE, "Cannot retrieve connection " + connName, ce);
                MessageDialog.error((Component)parent, (Object)ce.getMessage(), (String)this.getTitle(true), null);
                String string = null;
                return string;
            }
        }
        boolean edit = props != null;
        String originalName = edit ? connName : null;
        boolean newConn = false;
        if (props == null) {
            newConn = true;
            props = new Properties();
            props.put("subtype", this.getDefaultSubtype());
            if (!ModelUtil.hasLength((String)connName)) {
                connName = DBUtil.getUniqueName(conns.listConnections(), (String)this.getDefaultConnName());
            }
        }
        Namespace data = new Namespace();
        data.put("ConnectionsInstanceKey", (Object)conns);
        data.put("ConnectionNameKey", (Object)connName);
        data.put("ConnectionOrigNameKey", (Object)originalName);
        data.put("NewObject", (Object)props);
        data.put(StoreChoice.class.getName(), (Object)this.getStoreChoice());
        this.setupNamespace(data);
        TDialogLauncher launcher = new TDialogLauncher((Component)parent, this.getTitle(edit), panel, data);
        DialogHeader header = new DialogHeader(this.getHeaderText(edit), OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/database.png")));
        launcher.setDialogHeader(header);
        launcher.setInitialSize(560, 560);
        JEWTDialog dialog = launcher.initDialog();
        dialog.setInitialFocus(defaultComp);
        dialog.addVetoableChangeListener((VetoableChangeListener)new CommitListener(data, null));
        dialog.setName(newConn ? "CreateDatabaseConnectionDialog" : "EditDatabaseConnectionDialog");
        if (launcher.showDialog()) {
            return (String)data.get("ConnectionNameKey");
        }
        return null;
    }

    protected void doCommit(Connections conns, String originalName, String newName, Properties props, Namespace data) throws ConnectionException {
        if (originalName != null) {
            conns.updateConnection(originalName, newName, props);
        } else {
            conns.addConnection(newName, props);
        }
    }

    static void overrideDefaultEditor(Class<? extends DefaultEditor> clz) {
        s_override = clz;
    }

    public static DefaultEditor createDefaultEditor() {
        if (s_override != null) {
            try {
                DefaultEditor defaultEditor = s_override.newInstance();
                return defaultEditor;
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.SEVERE, "cannot create db connection editor", e);
            }
        }
        return new DefaultEditor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StoreChoice
    extends Enum<StoreChoice> {
        private static final /* synthetic */ StoreChoice[] $v;
        public static final /* enum */ StoreChoice NONE;
        public static final /* enum */ StoreChoice CONTEXT;
        public static final /* enum */ StoreChoice ALL;

        public static StoreChoice valueOf(String string) {
            return Enum.valueOf(StoreChoice.class, string);
        }

        public static final StoreChoice[] values() {
            return (StoreChoice[])$v.clone();
        }

        static {
            StoreChoice[] storeChoiceArray = new StoreChoice[3];
            storeChoiceArray[2] = ALL = new StoreChoice("ALL", 2);
            storeChoiceArray[1] = CONTEXT = new StoreChoice("CONTEXT", 1);
            storeChoiceArray[0] = NONE = new StoreChoice("NONE", 0);
            $v = storeChoiceArray;
        }

        private StoreChoice(String string2, int n2) {
        }
    }

    private class CommitListener
    implements VetoableChangeListener {
        private Namespace data;

        private CommitListener(Namespace d) {
            this.data = d;
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                String newName = (String)this.data.get("ConnectionNameKey");
                Properties props = (Properties)this.data.get("NewObject");
                DatabaseConnections conns = (DatabaseConnections)this.data.get("ConnectionsInstanceKey");
                String originalName = (String)this.data.get("ConnectionOrigNameKey");
                try {
                    DefaultEditor.this.doCommit(conns, originalName, newName, props, this.data);
                }
                catch (ConnectionException ce) {
                    MessageDialog.error((Component)IdeUtil.getMainWindow(), (Object)ce.getMessage(), (String)DefaultEditor.this.getTitle(originalName != null), null);
                    throw new PropertyVetoException(ce.getMessage(), evt);
                }
            }
        }

        CommitListener(Namespace namespace, 1 var3_3) {
            this(namespace);
        }

        public final class 1 {
        }
    }
}

