/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.db.ConnectionTypeUIRegistry;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class DefaultPasswordPrompter
implements PasswordPrompter {
    private Map<Properties, String> m_passwords;

    private void $init$() {
        this.m_passwords = new HashMap<Properties, String>();
    }

    public DefaultPasswordPrompter() {
        this.$init$();
    }

    private Properties createCacheVersion(Properties props) {
        Properties cache = (Properties)props.clone();
        cache.remove("password");
        cache.remove("SavePassword");
        cache.remove("DeployPassword");
        return cache;
    }

    public void cache(Properties props) {
        Properties cacheProps = this.createCacheVersion(props);
        this.m_passwords.put(cacheProps, props.getProperty("password"));
    }

    public void disconnect(Properties props) {
        Properties cacheProps = this.createCacheVersion(props);
        this.m_passwords.remove(cacheProps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection promptForPassword(Properties props, ConnectionCreator c) throws SQLException {
        Connection connection;
        Properties cacheProps = this.createCacheVersion(props);
        if (this.m_passwords.containsKey(cacheProps)) {
            props.setProperty("password", this.m_passwords.get(cacheProps));
            try {
                return c.getConnection(props);
            }
            catch (SQLException sqe) {
                // empty catch block
            }
        }
        String subtype = props.getProperty("subtype");
        String userKey = ConnectionTypeUIRegistry.getUsernameKey(subtype);
        String passKey = ConnectionTypeUIRegistry.getPasswordKey(subtype);
        int tries = 0;
        Connection conn = null;
        JEWTDialog dialog = null;
        try {
            while (tries < 3) {
                if (conn != null) {
                    return conn;
                }
                ++tries;
                if (dialog == null) {
                    dialog = JEWTDialog.createDialog((Component)SwingUtils.getToplevelWindow(), (String)DBConnArb.getString(6), (int)3);
                }
                PasswordPanel ppanel = new PasswordPanel(userKey, passKey, null);
                dialog.setContent((Component)ppanel);
                dialog.setInitialFocus((Component)PasswordPanel.ra$m_txtPass(ppanel));
                PasswordPanel.mav$initFrom(ppanel, props);
                Holder dialogResult = new Holder();
                JEWTDialog d = dialog;
                boolean dialogOK = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(new 1(this, dialogResult, d));
                    dialogOK = (Boolean)dialogResult.get();
                } else {
                    dialogOK = d.runDialog();
                }
                if (!dialogOK) {
                    connection = null;
                    return connection;
                }
                PasswordPanel.mav$commitTo(ppanel, props);
                this.m_passwords.put(cacheProps, props.getProperty("password"));
                try {
                    conn = c.getConnection(props);
                }
                catch (SQLException sqe) {
                    if (tries > 3) throw sqe;
                    SQLErrorDialog.showErrorDialog((Component)Ide.getMainWindow(), (String)DBConnArb.getString(6), (SQLException)sqe);
                }
            }
            return conn;
        }
        catch (SQLException sqe) {
            throw sqe;
        }
        catch (Exception e) {
            FeedbackManager.reportException((String)"Database Password Prompter", (Throwable)e);
            return conn;
        }
        finally {
            if (dialog == null) return connection;
            dialog.dispose();
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Holder v$dialogResult;
        private final /* synthetic */ JEWTDialog v$d;
        final /* synthetic */ DefaultPasswordPrompter this$0;

        public void run() {
            this.v$dialogResult.set((Object)this.v$d.runDialog());
        }

        public 1(DefaultPasswordPrompter defaultPasswordPrompter, Holder holder, JEWTDialog jEWTDialog) {
            this.v$d = jEWTDialog;
            this.v$dialogResult = holder;
            this.this$0 = defaultPasswordPrompter;
        }
    }

    private class PasswordPanel
    extends JPanel {
        private String m_userKey;
        private String m_passKey;
        private JLabel m_lblUser;
        private JTextField m_txtUser;
        private JLabel m_lblPass;
        private JPasswordField m_txtPass;

        private PasswordPanel(String userKey, String passKey) {
            this.m_userKey = userKey;
            this.m_passKey = passKey;
            this.layoutComponents();
        }

        private void layoutComponents() {
            HelpUtils.setHelpID((JComponent)this, (String)"f1_connection_info_html");
            int y = 0;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbcLabels = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
            GridBagConstraints gbcFields = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                this.m_lblUser = new JLabel();
                this.m_txtUser = new JTextField();
                ResourceUtils.resLabel((JLabel)this.m_lblUser, (Component)this.m_txtUser, (String)DBConnArb.getString(70));
                gbcLabels.gridy = y;
                gbcFields.gridy = y++;
                this.add((Component)this.m_lblUser, gbcLabels);
                this.add((Component)this.m_txtUser, gbcFields);
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                this.m_lblPass = new JLabel();
                this.m_txtPass = new JPasswordField();
                ResourceUtils.resLabel((JLabel)this.m_lblPass, (Component)this.m_txtPass, (String)DBConnArb.getString(66));
                gbcLabels.gridy = y;
                gbcFields.gridy = y;
                this.add((Component)this.m_lblPass, gbcLabels);
                this.add((Component)this.m_txtPass, gbcFields);
            }
        }

        private void initFrom(Properties props) {
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                this.m_txtUser.setText(props.getProperty(this.m_userKey));
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                this.m_txtPass.setText(props.getProperty(this.m_passKey));
            }
        }

        private void commitTo(Properties props) {
            boolean saveableChange = false;
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                props.setProperty(this.m_userKey, this.m_txtUser.getText());
                saveableChange = true;
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                char[] pass = this.m_txtPass.getPassword();
                props.setProperty(this.m_passKey, new String(pass));
                int i = 0;
                while (i < pass.length) {
                    pass[i] = '\u0000';
                    ++i;
                }
                this.m_txtPass.setText(null);
            }
            if (saveableChange) {
                try {
                    DatabaseConnections.getInstance().saveConnections();
                }
                catch (Exception e) {
                    DBLog.getLogger().log(Level.WARNING, "Password prompter couldn't save connections", e);
                }
            }
        }

        PasswordPanel(String string, String string2, 1 var4_4) {
            this(string, string2);
        }

        static JPasswordField ra$m_txtPass(PasswordPanel passwordPanel) {
            return passwordPanel.m_txtPass;
        }

        static void mav$initFrom(PasswordPanel passwordPanel, Properties properties) {
            passwordPanel.initFrom(properties);
        }

        static void mav$commitTo(PasswordPanel passwordPanel, Properties properties) {
            passwordPanel.commitTo(properties);
        }

        public final class 1 {
        }
    }
}

