/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBLog;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;

public class DefaultContextWrapper
implements DatabaseContextManager.ContextWrapper {
    private static final String INITIAL_CONTEXT_FACTORY = "oracle.adf.share.jndi.InitialContextFactoryImpl";
    private static final String CONNECTIONS_FILE_NAME = "connections.xml";
    private static DefaultContextWrapper s_instance;
    private AdfJndiContext m_context;
    private URL m_url;
    private Level m_logLevel;

    private void $init$() {
        this.m_logLevel = Level.SEVERE;
    }

    public static DefaultContextWrapper getInstance() {
        if (s_instance == null) {
            if (Product.isJDeveloper()) {
                DBLog.getLogger().log(Level.SEVERE, "default context should not be created in JDeveloper as rescat context should be used.");
            }
            s_instance = new DefaultContextWrapper();
        }
        return s_instance;
    }

    private DefaultContextWrapper() {
        this.$init$();
        ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
        URL dirURL = er.getSystemDirectory("oracle.jdeveloper.db.connection");
        URL fileURL = URLFactory.newURL((URL)dirURL, (String)CONNECTIONS_FILE_NAME);
        if (!URLFileSystem.exists((URL)dirURL)) {
            URLFileSystem.mkdirs((URL)fileURL);
        }
        this.m_url = fileURL;
    }

    public DefaultContextWrapper(URL url) {
        this.$init$();
        this.m_url = url;
        this.m_logLevel = Level.FINE;
    }

    public Context getDatabaseContext() {
        if (this.m_context == null && this.m_url != null) {
            try {
                this.m_context = DefaultContextWrapper.newContext(this.m_url);
            }
            catch (NamingException nme) {
                String msg = "failed to create naming Context for db connections at url: " + this.m_url.toExternalForm();
                DBLog.getLogger().log(this.m_logLevel, msg, nme);
            }
        }
        return this.m_context;
    }

    public void saveDatabaseContext() throws NamingException {
        if (this.m_context != null) {
            this.m_context.save();
        }
    }

    public void reset(URL url) {
        this.m_url = url;
        this.m_context = null;
    }

    private static AdfJndiContext newContext(URL url) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", url.getPath());
        return new AdfInitialContext(env);
    }
}

