/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.Referenceable;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.ide.db.DBIcons;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBLog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionTypeUIRegistry;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.panels.ConnectionEditorPanel;

public class ManageConnectionsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ListCellRenderer {
    private DefaultListModel m_connectionListModel;
    private JList m_connectionsList;
    private DefaultListCellRenderer _delegate;
    private ListButtons m_listButtons;
    private ConnectionEditorPanel m_connTypePanel;
    private TraversableContext m_childContext;
    private int m_currentListSelection;
    private Connections m_connectionsInstance;
    private HashMap<String, ConnectionDetail> m_connectionDetails;

    private void $init$() {
        this.m_connectionListModel = new DefaultListModel();
        this.m_connectionsList = new 1(this.m_connectionListModel);
        this._delegate = new DefaultListCellRenderer();
        this.m_listButtons = new ListButtons(this.m_connectionsList, (ListButtons.Helper)new ButtonsHelper(null));
        this.m_connTypePanel = new ConnectionEditorPanel(this);
        this.m_childContext = new TraversableContext(new Namespace(), 0);
        this.m_currentListSelection = -1;
        this.m_connectionDetails = new HashMap();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)this._delegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String connName = (String)value;
        this.useConnectionDetail(connName);
        ConnectionDetail cd = this.m_connectionDetails.get(connName);
        if (cd == null || ConnectionDetail.ra$m_origName(cd) == null || !ConnectionDetail.ra$m_origName(cd).equals(ConnectionDetail.ra$m_updName(cd)) || !ConnectionDetail.ra$m_origProps(cd).equals(ConnectionDetail.ra$m_updProps(cd))) {
            Font f = label.getFont();
            f = new Font(f.getFamily(), 2, f.getSize());
            label.setFont(f);
        }
        return label;
    }

    private void initialiseConnectionDetail() {
        this.m_connectionsList.removeListSelectionListener(this);
        this.m_connectionListModel.removeAllElements();
        this.m_connectionDetails.clear();
        for (String connName : this.m_connectionsInstance.listConnections()) {
            ConnectionDetail cd = new ConnectionDetail(null);
            ConnectionDetail.wa$m_origName(cd, connName);
            ConnectionDetail.wa$m_updName(cd, connName);
            ConnectionDetail.wa$m_origProps(cd, null);
            ConnectionDetail.wa$m_updProps(cd, null);
            ConnectionDetail.wa$m_used(cd, false);
            this.m_connectionDetails.put(connName, cd);
            this.m_connectionListModel.addElement(connName);
        }
        this.m_connectionsList.addListSelectionListener(this);
    }

    private void useConnectionDetail(String connName) {
        ConnectionDetail cd = this.m_connectionDetails.get(connName);
        if (!ConnectionDetail.ra$m_used(cd)) {
            Referenceable ref = null;
            try {
                ref = this.m_connectionsInstance.getReferenceable(connName);
            }
            catch (ConnectionException e) {
                // empty catch block
            }
            if (ref != null) {
                ConnectionDetail.wa$m_origProps(cd, ((DatabaseProvider)ref).getProperties());
            } else {
                ConnectionDetail.wa$m_origProps(cd, new Properties());
            }
            ConnectionDetail.wa$m_updProps(cd, (Properties)ConnectionDetail.ra$m_origProps(cd).clone());
            ConnectionDetail.wa$m_used(cd, true);
        }
    }

    private void newConnectionDetail() {
        Properties newProps = new Properties();
        newProps.put("subtype", "oraJDBC");
        boolean nameUnique = false;
        int suffix = 1;
        String basename = "Connection";
        String name = basename + suffix;
        while (!nameUnique) {
            boolean found = false;
            for (String key : this.m_connectionDetails.keySet()) {
                ConnectionDetail cd = this.m_connectionDetails.get(key);
                if (!ConnectionDetail.ra$m_updName(cd).equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                nameUnique = true;
                continue;
            }
            name = basename + ++suffix;
        }
        ConnectionDetail cd = new ConnectionDetail(null);
        ConnectionDetail.wa$m_origName(cd, null);
        ConnectionDetail.wa$m_updName(cd, name);
        ConnectionDetail.wa$m_origProps(cd, null);
        ConnectionDetail.wa$m_updProps(cd, newProps);
        ConnectionDetail.wa$m_used(cd, true);
        this.m_connectionDetails.put(name, cd);
        this.m_connectionsList.removeListSelectionListener(this);
        this.m_connectionListModel.addElement(name);
        this.m_connectionsList.addListSelectionListener(this);
        this.m_connectionsList.setSelectedValue(name, true);
    }

    private void removeSelectedConnection() {
        int selIdx = this.m_connectionsList.getSelectedIndex();
        String connName = (String)this.m_connectionsList.getSelectedValue();
        this.m_connectionDetails.remove(connName);
        this.m_connectionsList.removeListSelectionListener(this);
        this.m_connectionListModel.removeElement(connName);
        this.m_connectionsList.addListSelectionListener(this);
        this.m_currentListSelection = -1;
        if (this.m_connectionListModel.size() == 0) {
            this.m_childContext.remove("ConnectionNameKey");
            this.m_childContext.remove("OriginalObject");
            this.m_childContext.remove("NewObject");
            this.m_connTypePanel.onEntry(this.m_childContext);
        } else if (selIdx >= this.m_connectionListModel.size()) {
            this.m_connectionsList.setSelectedIndex(selIdx - 1);
        } else {
            this.m_connectionsList.setSelectedIndex(selIdx);
        }
    }

    private void setupChildContext(String connName) {
        ConnectionDetail cd = this.m_connectionDetails.get(connName);
        this.m_childContext.remove("ConnectionNameKey");
        this.m_childContext.put("ConnectionNameKey", (Object)connName);
        this.m_childContext.remove("OriginalObject");
        this.m_childContext.put("OriginalObject", (Object)ConnectionDetail.ra$m_origProps(cd));
        this.m_childContext.remove("NewObject");
        this.m_childContext.put("NewObject", (Object)ConnectionDetail.ra$m_updProps(cd));
        this.m_childContext.remove("ConnectionsInstanceKey");
        this.m_childContext.put("ConnectionsInstanceKey", (Object)this.m_connectionsInstance);
    }

    public ManageConnectionsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JScrollPane scrConnections = new JScrollPane();
        scrConnections.setVerticalScrollBarPolicy(20);
        this.m_connectionsList.setSelectionMode(0);
        this.m_connectionsList.setCellRenderer(this);
        this.m_connectionsList.addListSelectionListener(this);
        scrConnections.getViewport().add((Component)this.m_connectionsList, null);
        JPanel pnlList = new JPanel(new GridBagLayout());
        pnlList.add((Component)scrConnections, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add(Box.createHorizontalStrut(120), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)this.m_listButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlList.add((Component)((Object)this.m_connTypePanel), new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(0, 0));
        this.add(pnlList, "Center");
        this.setHelpID("f1_dbconnection_html");
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_connectionsInstance = (Connections)dataContext.get("ConnectionsInstanceKey");
        this.initialiseConnectionDetail();
        String connName = (String)dataContext.get("ConnectionNameKey");
        if (connName == null) {
            this.newConnectionDetail();
        } else {
            this.m_connectionsList.setSelectedValue(connName, true);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.saveCurrentConnectionDetails();
        Collection<String> currentList = this.m_connectionsInstance.listConnections();
        for (Object object : currentList) {
            String connName = (String)object;
            ConnectionDetail cd = this.m_connectionDetails.get(connName);
            if (cd == null) {
                try {
                    this.m_connectionsInstance.removeConnection(connName);
                    continue;
                }
                catch (ConnectionException e) {
                    DBLog.getLogger().log(Level.WARNING, "error removing connection " + connName, e);
                    throw new TraversalException(e.getMessage());
                }
            }
            if (ConnectionDetail.ra$m_origProps(cd).equals(ConnectionDetail.ra$m_updProps(cd))) continue;
            try {
                this.m_connectionsInstance.updateConnection(connName, null, ConnectionDetail.ra$m_updProps(cd));
            }
            catch (ConnectionException e) {
                DBLog.getLogger().log(Level.WARNING, "error updating connection " + connName, e);
                throw new TraversalException(e.getMessage());
            }
        }
        for (String connName : this.m_connectionDetails.keySet()) {
            if (currentList.contains(connName)) continue;
            ConnectionDetail cd = this.m_connectionDetails.get(connName);
            try {
                this.m_connectionsInstance.addConnection(connName, ConnectionDetail.ra$m_updProps(cd));
            }
            catch (ConnectionException e) {
                DBLog.getLogger().log(Level.WARNING, "error adding connection " + connName, e);
                throw new TraversalException(e.getMessage());
            }
        }
        try {
            this.m_connectionsInstance.saveConnections();
        }
        catch (ConnectionException e) {
            DBLog.getLogger().log(Level.WARNING, "error saving connections", e);
            throw new TraversalException(e.getMessage());
        }
        dataContext.put("ConnectionNameKey", this.m_connectionsList.getSelectedValue());
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.currentSelectionOK()) {
            return;
        }
        if (this.m_currentListSelection != this.m_connectionsList.getSelectedIndex()) {
            String connName = (String)this.m_connectionsList.getSelectedValue();
            this.useConnectionDetail(connName);
            this.setupChildContext(connName);
            this.m_connTypePanel.onEntry(this.m_childContext);
            this.m_currentListSelection = this.m_connectionsList.getSelectedIndex();
        }
    }

    void saveCurrentConnectionDetails() throws TraversalException {
        if (this.m_currentListSelection != -1) {
            this.m_connTypePanel.onExit(this.m_childContext);
            String currName = (String)this.m_connectionListModel.get(this.m_currentListSelection);
            String newName = (String)this.m_childContext.get("ConnectionNameKey");
            if (!currName.equals(newName)) {
                if (!ModelUtil.hasLength((String)newName)) {
                    MessageDialog.error((Component)((Object)this), (Object)DBConnArb.getString(26), null, null);
                    throw new TraversalException(DBConnArb.getString(26));
                }
                if (this.m_connectionDetails.containsKey(newName)) {
                    MessageDialog.error((Component)((Object)this), (Object)DBConnArb.format(83, newName), null, null);
                    throw new TraversalException(DBConnArb.format(83, newName));
                }
                ConnectionDetail cd = this.m_connectionDetails.get(currName);
                this.m_connectionDetails.remove(currName);
                this.m_connectionDetails.put(newName, cd);
                ConnectionDetail.wa$m_updName(cd, newName);
                this.m_connectionsList.removeListSelectionListener(this);
                int i = this.m_connectionListModel.indexOf(currName);
                this.m_connectionListModel.setElementAt(newName, i);
                this.m_connectionsList.addListSelectionListener(this);
            }
        }
    }

    private boolean currentSelectionOK() {
        try {
            this.saveCurrentConnectionDetails();
            boolean bl = true;
            return bl;
        }
        catch (TraversalException e) {
            e.showMessageDialog((Component)((Object)this));
            this.m_connectionsList.removeListSelectionListener(this);
            this.m_connectionsList.setSelectedIndex(this.m_currentListSelection);
            this.m_connectionsList.addListSelectionListener(this);
            boolean bl = false;
            return bl;
        }
    }

    public Component getDefaultFocusComponent() {
        return this.m_connTypePanel.getDefaultFocusComponent();
    }

    public static final String manageConnections(Connections conns) {
        ManageConnectionsPanel panel = new ManageConnectionsPanel();
        Component defaultComp = panel.getDefaultFocusComponent();
        Namespace data = new Namespace();
        data.put("ConnectionsInstanceKey", (Object)conns);
        Collection<String> allconns = conns.listConnections();
        if (allconns.size() > 0) {
            data.put("ConnectionNameKey", (Object)allconns.iterator().next());
        }
        Frame parent = IdeUtil.getMainWindow();
        TDialogLauncher launcher = new TDialogLauncher((Component)parent, DBConnArb.getString(71), (Traversable)panel, data, (DialogRunnerCallback)new SizeKeeperCallback("edit.object"));
        DialogHeader header = new DialogHeader(DBConnArb.getString(18), DBIcons.getImage((int)33));
        launcher.setDialogHeader(header);
        launcher.initDialog().setInitialFocus(defaultComp);
        launcher.showDialog();
        return (String)data.get("ConnectionNameKey");
    }

    static JList ra$m_connectionsList(ManageConnectionsPanel manageConnectionsPanel) {
        return manageConnectionsPanel.m_connectionsList;
    }

    static DefaultListModel ra$m_connectionListModel(ManageConnectionsPanel manageConnectionsPanel) {
        return manageConnectionsPanel.m_connectionListModel;
    }

    static void mav$removeSelectedConnection(ManageConnectionsPanel manageConnectionsPanel) {
        manageConnectionsPanel.removeSelectedConnection();
    }

    static boolean mav$currentSelectionOK(ManageConnectionsPanel manageConnectionsPanel) {
        return manageConnectionsPanel.currentSelectionOK();
    }

    static void mav$newConnectionDetail(ManageConnectionsPanel manageConnectionsPanel) {
        manageConnectionsPanel.newConnectionDetail();
    }

    static HashMap ra$m_connectionDetails(ManageConnectionsPanel manageConnectionsPanel) {
        return manageConnectionsPanel.m_connectionDetails;
    }

    final class 1
    extends JList {
        public String getToolTipText(MouseEvent e) {
            int row = this.locationToIndex(e.getPoint());
            if (row != this.getSelectedIndex()) {
                String connName = this.getModel().getElementAt(row).toString();
                ConnectionDetail cd = (ConnectionDetail)ManageConnectionsPanel.ra$m_connectionDetails(ManageConnectionsPanel.this).get(connName);
                if (cd != null) {
                    String connType = (String)ConnectionDetail.ra$m_updProps(cd).get("subtype");
                    ConnectionTypeUIRegistry.ConnectionTooltipProvider ttp = ConnectionTypeUIRegistry.getTooltipProvider(connType);
                    return ttp.getTooltip(ConnectionDetail.ra$m_updProps(cd));
                }
            }
            return null;
        }

        public 1(ListModel listModel) {
            super(listModel);
        }
    }

    private static class ConnectionDetail {
        private String m_origName;
        private String m_updName;
        private Properties m_origProps;
        private Properties m_updProps;
        private boolean m_used;

        private ConnectionDetail() {
        }

        static void wa$m_updName(ConnectionDetail connectionDetail, String string) {
            connectionDetail.m_updName = string;
        }

        static Properties ra$m_origProps(ConnectionDetail connectionDetail) {
            return connectionDetail.m_origProps;
        }

        static Properties ra$m_updProps(ConnectionDetail connectionDetail) {
            return connectionDetail.m_updProps;
        }

        static String ra$m_updName(ConnectionDetail connectionDetail) {
            return connectionDetail.m_updName;
        }

        ConnectionDetail(1 var1_1) {
            this();
        }

        static void wa$m_origName(ConnectionDetail connectionDetail, String string) {
            connectionDetail.m_origName = string;
        }

        static void wa$m_origProps(ConnectionDetail connectionDetail, Properties properties) {
            connectionDetail.m_origProps = properties;
        }

        static void wa$m_updProps(ConnectionDetail connectionDetail, Properties properties) {
            connectionDetail.m_updProps = properties;
        }

        static void wa$m_used(ConnectionDetail connectionDetail, boolean bl) {
            connectionDetail.m_used = bl;
        }

        static boolean ra$m_used(ConnectionDetail connectionDetail) {
            return connectionDetail.m_used;
        }

        static String ra$m_origName(ConnectionDetail connectionDetail) {
            return connectionDetail.m_origName;
        }

        public final class 1 {
        }
    }

    private class ButtonsHelper
    extends ListButtons.HelperAdapter {
        public void addToList() {
            if (ManageConnectionsPanel.mav$currentSelectionOK(ManageConnectionsPanel.this)) {
                ManageConnectionsPanel.mav$newConnectionDetail(ManageConnectionsPanel.this);
            }
        }

        public void removeFromList() {
            ManageConnectionsPanel.mav$removeSelectedConnection(ManageConnectionsPanel.this);
        }

        public boolean includeReorderButtons() {
            return false;
        }

        public boolean canRemove() {
            return !ManageConnectionsPanel.ra$m_connectionsList(ManageConnectionsPanel.this).isSelectionEmpty() && ManageConnectionsPanel.ra$m_connectionListModel(ManageConnectionsPanel.this).size() > 0;
        }

        public boolean canRemove(Object val) {
            return this.canRemove();
        }

        private ButtonsHelper() {
        }

        ButtonsHelper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

