/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.Color;
import javax.swing.UIManager;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.ModelUtil;

public abstract class IdeUIManager {
    private static final String UI_MANAGER_NAME = "ide/ui-manager";
    private static Color COLOR_UNSELECTED_TAB;
    private static Color COLOR_SELECTED_FOCUSED_TAB;
    private static Color COLOR_HIGHLIGHTED_TAB;
    private static Color DISABLED_TEXT_COLOR;
    private static Color ACTIVE_TITLE_COLOR;
    private static Color ACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    private static Color ACTIVE_TITLE_GRADIENT_DARK_COLOR;
    private static Color ACTIVE_TITLE_FOREGROUND_COLOR;
    private static Color ACTIVE_TITLE_BUTTON_COLOR;
    private static Color INACTIVE_TITLE_COLOR;
    private static Color INACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    private static Color INACTIVE_TITLE_GRADIENT_DARK_COLOR;
    private static Color INACTIVE_TITLE_FOREGROUND_COLOR;
    private static Color INACTIVE_TITLE_BUTTON_COLOR;
    private static Color UNSELECTED_TITLE_COLOR;
    private static Color UNSELECTED_TITLE_FOREGROUND_COLOR;
    private static Color UNSELECTED_TITLE_BUTTON_COLOR;
    private static final int GRADIENT_LIGHT_BIAS = 40;
    private static final int GRADIENT_DARK_BIAS = 20;
    public static final String STATUS_BAR_UICLASSID = "oracle.ide.controls.StatusBarControlUI";
    public static final String TREE_INACTIVE_SELECTION_FOREGROUND_KEY = "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground";
    public static final String TREE_INACTIVE_SELECTION_BACKGROUND_KEY = "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground";
    public static final String FILEVIEW_ARCHIVE_ICON = "FileView.archiveIcon";
    public static final String DIRTY_FONT = "Oracle.dirtyFont";

    protected IdeUIManager() {
    }

    public static IdeUIManager getUIManager() {
        return (IdeUIManager)Names.lookup(Names.newInitialContext(), UI_MANAGER_NAME);
    }

    public static void setUIManager(IdeUIManager uiManager) {
        Names.bind(Names.newInitialContext(), UI_MANAGER_NAME, uiManager);
    }

    public abstract void setLookAndFeel(String var1, String var2);

    public abstract ThemeInfo[] getInstalledThemes(String var1);

    public abstract ThemeInfo getCurrentTheme(String var1);

    public abstract ThemeInfo getDefaultTheme(String var1);

    public static Color getUnselectedTabColor() {
        if (COLOR_UNSELECTED_TAB == null) {
            int b;
            int g;
            Color selectedFocused = IdeUIManager.getSelectedFocusedTabColor();
            int r = selectedFocused.getRed();
            COLOR_UNSELECTED_TAB = (r + (g = selectedFocused.getGreen()) + (b = selectedFocused.getBlue())) / 3 > 127 ? new Color(r * 247 / 255, g * 247 / 255, b * 239 / 255) : new Color(Math.min(r * 255 / 247, 255), Math.min(g * 255 / 247, 255), Math.min(b * 255 / 247, 255));
        }
        return COLOR_UNSELECTED_TAB;
    }

    public static Color getSelectedFocusedTabColor() {
        if (COLOR_SELECTED_FOCUSED_TAB == null) {
            Color color = UIManager.getColor("EditorPane.background");
            COLOR_SELECTED_FOCUSED_TAB = color != null ? color : Color.WHITE;
        }
        return COLOR_SELECTED_FOCUSED_TAB;
    }

    public static Color getDisabledTextColor() {
        if (DISABLED_TEXT_COLOR == null) {
            Color color = UIManager.getLookAndFeelDefaults().getColor("textInactiveText");
            DISABLED_TEXT_COLOR = color != null ? color : Color.LIGHT_GRAY;
        }
        return DISABLED_TEXT_COLOR;
    }

    public static Color getHighlightedTabColor() {
        if (COLOR_HIGHLIGHTED_TAB == null) {
            COLOR_HIGHLIGHTED_TAB = new Color(229, 124, 10);
        }
        return COLOR_HIGHLIGHTED_TAB;
    }

    public static Color getActiveTitleColor() {
        if (ACTIVE_TITLE_COLOR == null) {
            ACTIVE_TITLE_COLOR = UIManager.getColor("InternalFrame.activeTitleBackground");
        }
        return ACTIVE_TITLE_COLOR;
    }

    public static Color getActiveTitleGradientLightColor() {
        if (ACTIVE_TITLE_GRADIENT_LIGHT_COLOR == null) {
            Color titleColor = IdeUIManager.getActiveTitleColor();
            ACTIVE_TITLE_GRADIENT_LIGHT_COLOR = IdeUIManager.getGradientLightColor(titleColor);
        }
        return ACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    }

    public static Color getActiveTitleGradientDarkColor() {
        if (ACTIVE_TITLE_GRADIENT_DARK_COLOR == null) {
            Color titleColor = IdeUIManager.getActiveTitleColor();
            Color lightColor = IdeUIManager.getActiveTitleGradientLightColor();
            ACTIVE_TITLE_GRADIENT_DARK_COLOR = IdeUIManager.getGradientDarkColor(titleColor, lightColor);
        }
        return ACTIVE_TITLE_GRADIENT_DARK_COLOR;
    }

    public static Color getInactiveTitleColor() {
        if (INACTIVE_TITLE_COLOR == null) {
            INACTIVE_TITLE_COLOR = UIManager.getColor("Panel.background");
        }
        return INACTIVE_TITLE_COLOR;
    }

    public static Color getInactiveTitleGradientLightColor() {
        if (INACTIVE_TITLE_GRADIENT_LIGHT_COLOR == null) {
            Color titleColor = IdeUIManager.getInactiveTitleColor();
            INACTIVE_TITLE_GRADIENT_LIGHT_COLOR = IdeUIManager.getGradientLightColor(titleColor);
        }
        return INACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    }

    public static Color getInactiveTitleGradientDarkColor() {
        if (INACTIVE_TITLE_GRADIENT_DARK_COLOR == null) {
            Color titleColor = IdeUIManager.getInactiveTitleColor();
            Color lightColor = IdeUIManager.getInactiveTitleGradientLightColor();
            INACTIVE_TITLE_GRADIENT_DARK_COLOR = IdeUIManager.getGradientDarkColor(titleColor, lightColor);
        }
        return INACTIVE_TITLE_GRADIENT_DARK_COLOR;
    }

    public static Color getInactiveTitleForegroundColor() {
        if (INACTIVE_TITLE_FOREGROUND_COLOR == null) {
            INACTIVE_TITLE_FOREGROUND_COLOR = UIManager.getColor("Label.foreground");
        }
        return INACTIVE_TITLE_FOREGROUND_COLOR;
    }

    public static Color getUnselectedTitleColor() {
        if (UNSELECTED_TITLE_COLOR == null) {
            Color c = IdeUIManager.getInactiveTitleColor();
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            UNSELECTED_TITLE_COLOR = new Color(Math.min(r + 24, 255), Math.min(g + 24, 255), Math.min(b + 24, 255));
        }
        return UNSELECTED_TITLE_COLOR;
    }

    public static Color getUnselectedTitleForegroundColor() {
        if (UNSELECTED_TITLE_FOREGROUND_COLOR == null) {
            UNSELECTED_TITLE_FOREGROUND_COLOR = IdeUIManager.getInactiveTitleForegroundColor();
        }
        return UNSELECTED_TITLE_FOREGROUND_COLOR;
    }

    private static Color getButtonColor(Color foreground) {
        return new Color(foreground.getRed(), foreground.getGreen(), foreground.getBlue(), foreground.getAlpha() * 9 / 10);
    }

    private static Color getGradientLightColor(Color baseColor) {
        int bias = 40;
        int r = baseColor.getRed();
        int g = baseColor.getGreen();
        int b = baseColor.getBlue();
        int min = Math.min(r, Math.min(g, b));
        int min2 = Math.min(min + 40, 255);
        if (r + 40 < 256) {
            min2 = r + 40;
            min = Math.max(min, r);
        }
        if (g + 40 < 256) {
            min2 = Math.max(min2, g + 40);
            min = Math.max(min, g);
        }
        if (b + 40 < 256) {
            min2 = Math.max(min2, b + 40);
            min = Math.max(min, b);
        }
        float factor = (float)min2 / (float)min / 255.0f;
        return new Color(Math.min((float)r * factor, 1.0f), Math.min((float)g * factor, 1.0f), Math.min((float)b * factor, 1.0f));
    }

    public static Color getActiveTitleForegroundColor() {
        if (ACTIVE_TITLE_FOREGROUND_COLOR == null) {
            ACTIVE_TITLE_FOREGROUND_COLOR = UIManager.getColor("InternalFrame.activeTitleForeground");
        }
        return ACTIVE_TITLE_FOREGROUND_COLOR;
    }

    public static Color getActiveTitleButtonColor() {
        if (ACTIVE_TITLE_BUTTON_COLOR == null) {
            Color activeTitleForegroundColor = IdeUIManager.getActiveTitleForegroundColor();
            ACTIVE_TITLE_BUTTON_COLOR = IdeUIManager.getButtonColor(activeTitleForegroundColor);
        }
        return ACTIVE_TITLE_BUTTON_COLOR;
    }

    public static Color getInactiveTitleButtonColor() {
        if (INACTIVE_TITLE_BUTTON_COLOR == null) {
            INACTIVE_TITLE_BUTTON_COLOR = IdeUIManager.getButtonColor(IdeUIManager.getInactiveTitleForegroundColor());
        }
        return INACTIVE_TITLE_BUTTON_COLOR;
    }

    public static Color getUnselectedTitleButtonColor() {
        if (UNSELECTED_TITLE_BUTTON_COLOR == null) {
            UNSELECTED_TITLE_BUTTON_COLOR = IdeUIManager.getButtonColor(IdeUIManager.getUnselectedTitleForegroundColor());
        }
        return UNSELECTED_TITLE_BUTTON_COLOR;
    }

    private static Color getGradientDarkColor(Color baseColor, Color lightColor) {
        float factor = 0.5f;
        int r = baseColor.getRed();
        int g = baseColor.getGreen();
        int b = baseColor.getBlue();
        int rNew = r - (int)(0.5f * (float)(lightColor.getRed() - r));
        int gNew = g - (int)(0.5f * (float)(lightColor.getGreen() - g));
        int bNew = b - (int)(0.5f * (float)(lightColor.getBlue() - b));
        return new Color(Math.max(rNew, 0), Math.max(gNew, 0), Math.max(bNew, 0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ThemeInfo
    implements Comparable {
        private final String _name;
        private final String _className;

        public ThemeInfo(String name, String className) {
            this._name = name;
            this._className = className;
        }

        public String getName() {
            return this._name;
        }

        public String getClassName() {
            return this._className;
        }

        public int compareTo(Object o) {
            ThemeInfo otherTheme = (ThemeInfo)o;
            return this.getName().compareTo(otherTheme.getName());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThemeInfo)) {
                return false;
            }
            ThemeInfo otherInfo = (ThemeInfo)o;
            return ModelUtil.areEqual(this.getName(), otherInfo.getName()) && ModelUtil.areEqual(this.getClassName(), otherInfo.getClassName());
        }

        public int hashCode() {
            int result = 17;
            result = result * 37 + this.getName().hashCode();
            result = result * 37 + this.getClassName().hashCode();
            return result;
        }

        public String toString() {
            return this.getName();
        }
    }
}

