/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;

public class URLFileSystemHelperDecorator
extends URLFileSystemHelper {
    protected URLFileSystemHelper _helper;

    protected URLFileSystemHelperDecorator(URLFileSystemHelper helper) {
        if (helper == null) {
            throw new NullPointerException("the decorated helper cannot be null");
        }
        this._helper = helper;
    }

    public URLFileSystemHelper getHelper() {
        return this._helper;
    }

    public void insertNextDecorator(URLFileSystemHelperDecorator decorator) {
        if (this._helper == null) {
            throw new IllegalStateException("Cannot insert next decorator when the current decorator has a null helper");
        }
        if (decorator != null) {
            URLFileSystemHelper curHelper = this._helper;
            this._helper = decorator;
            decorator._helper = curHelper;
        }
    }

    public URL canonicalize(URL url) {
        return this._helper.canonicalize(url);
    }

    public boolean canRead(URL url) {
        return this._helper.canRead(url);
    }

    public boolean canWrite(URL url) {
        return this._helper.canWrite(url);
    }

    public boolean canCreate(URL url) {
        return this._helper.canCreate(url);
    }

    public boolean canDelete(URL url) {
        return this._helper.canDelete(url);
    }

    public boolean isValid(URL url) {
        return this._helper.isValid(url);
    }

    public URL convertSuffix(URL url, String oldSuffix, String newSuffix) {
        return this._helper.convertSuffix(url, oldSuffix, newSuffix);
    }

    public void delete(URL url) throws IOException {
        this._helper.delete(url);
    }

    public URL ensureSuffix(URL url, String suffix) {
        return this._helper.ensureSuffix(url, suffix);
    }

    public boolean equals(URL url1, URL url2) {
        return this._helper.equals(url1, url2);
    }

    public boolean exists(URL url) {
        return this._helper.exists(url);
    }

    public Icon getDefaultIcon(URL url) {
        return this._helper.getDefaultIcon(url);
    }

    public String getFileName(URL url) {
        return this._helper.getFileName(url);
    }

    public long getLength(URL url) {
        return this._helper.getLength(url);
    }

    public String getName(URL url) {
        return this._helper.getName(url);
    }

    public URL getParent(URL url) {
        return this._helper.getParent(url);
    }

    public String getPath(URL url) {
        return this._helper.getPath(url);
    }

    public String getPathNoExt(URL url) {
        return this._helper.getPathNoExt(url);
    }

    public String getPlatformPathName(URL url) {
        return this._helper.getPlatformPathName(url);
    }

    public String getSuffix(URL url) {
        return this._helper.getSuffix(url);
    }

    public String getSystemDisplayName(URL url) {
        return this._helper.getSystemDisplayName(url);
    }

    public Icon getSystemIcon(URL url) {
        return this._helper.getSystemIcon(url);
    }

    public boolean hasSuffix(URL url, String suffix) {
        return this._helper.hasSuffix(url, suffix);
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        return this._helper.isBaseURLFor(url1, url2);
    }

    public boolean isDirectory(URL url) {
        return this._helper.isDirectory(url);
    }

    public boolean isDirectoryPath(URL url) {
        return this._helper.isDirectoryPath(url);
    }

    public boolean isHidden(URL url) {
        return this._helper.isHidden(url);
    }

    public boolean isReadOnly(URL url) {
        return this._helper.isReadOnly(url);
    }

    public boolean isRegularFile(URL url) {
        return this._helper.isRegularFile(url);
    }

    public long lastModified(URL url) {
        return this._helper.lastModified(url);
    }

    public URL[] list(URL url) {
        return this._helper.list(url);
    }

    public URL[] list(URL url, URLFilter filter) {
        return this._helper.list(url, filter);
    }

    public URL[] listRoots() {
        return this._helper.listRoots();
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        return this._helper.ls(url);
    }

    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        return this._helper.ls(url, filter);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url) {
        return this._helper.lsCached(url);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url, URLFilter filter) {
        return this._helper.lsCached(url, filter);
    }

    public boolean mkdir(URL url) {
        return this._helper.mkdir(url);
    }

    public boolean mkdirs(URL url) {
        return this._helper.mkdirs(url);
    }

    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return this._helper.createTempFile(prefix, suffix, directory);
    }

    public InputStream openInputStream(URL url) throws IOException {
        return this._helper.openInputStream(url);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        return this._helper.openOutputStream(url);
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
        this._helper.rename(oldURL, newURL);
    }

    public boolean setLastModified(URL url, long time) {
        return this._helper.setLastModified(url, time);
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        return this._helper.setReadOnly(url, readOnly);
    }

    public String toDisplayString(URL url) {
        return this._helper.toDisplayString(url);
    }

    public String toEncodedString(URL url) {
        return this._helper.toEncodedString(url);
    }

    public String toRelativeSpec(URL url, URL base) {
        return this._helper.toRelativeSpec(url, base);
    }

    public String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        return this._helper.toRelativeSpec(url, base, mustConsumeBase);
    }

    public URL getBaseParent(URL url, String relativeSpec) {
        return this._helper.getBaseParent(url, relativeSpec);
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        return this._helper.createReader(url, encoding);
    }

    public void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        this._helper.addURLFileSystemListener(rootURL, listener);
    }

    public void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        this._helper.removeURLFileSystemListener(rootURL, listener);
    }
}

