/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Encodings;
import oracle.javatools.net.EncoderUtils;

public final class URLTempFile {
    private final URL _url;
    private Long _timestamp;
    private File _file;
    private boolean _tempWasCreated;

    public URLTempFile(URL url) {
        this._url = url;
    }

    public File getFile() {
        this.maybeRefresh();
        return this._file;
    }

    public boolean tempWasCreated() {
        return this._tempWasCreated;
    }

    protected void finalize() {
        this.deleteTempFile();
    }

    private static String pad(String s, int length, int c) {
        int diff = length - s.length();
        if (diff <= 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        int i = 0;
        while (i < diff) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private void maybeRefresh() {
        if (this._url == null) {
            return;
        }
        long curTimestamp = URLFileSystem.lastModified(this._url);
        if (this._timestamp != null && this._timestamp == curTimestamp) {
            return;
        }
        String protocol = this._url.getProtocol();
        if (protocol.equalsIgnoreCase("file")) {
            if (this._file == null) {
                String path = this._url.getPath();
                try {
                    path = EncoderUtils.decodeString(path, Encodings.getDefaultEncoding());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this._file = new File(path);
                this._tempWasCreated = false;
            }
            this._timestamp = new Long(curTimestamp);
            return;
        }
        this.deleteTempFile();
        this._file = null;
        this._tempWasCreated = false;
        try {
            String name = URLTempFile.pad(URLFileSystem.getName(this._url), 3, 120);
            String suffix = URLFileSystem.getSuffix(this._url);
            File file = File.createTempFile(name, suffix);
            file.deleteOnExit();
            URLFileSystem.copy(this._url, file);
            this._timestamp = new Long(curTimestamp);
            this._file = file;
            this._tempWasCreated = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteTempFile() {
        try {
            if (this._tempWasCreated && this._file != null && this._file.exists()) {
                this._file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

