/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import oracle.ide.util.Assert;

class HogTracker {
    private final int HOG_TIME;
    private static final String INDENT = "  ";
    private long _t0;
    private long _ti;
    private long _hogTime;
    private Object _hog;

    private void $init$() {
        this.HOG_TIME = 32;
        this._hogTime = 32;
    }

    public HogTracker() {
        this.$init$();
        this._t0 = System.nanoTime();
    }

    public void reset() {
        this._t0 = System.nanoTime();
        this._ti = 0L;
        this._hogTime = 32;
        this._hog = null;
    }

    public void mark() {
        this._ti = System.nanoTime();
    }

    public void check(Object hog) {
        long t1 = (System.nanoTime() - this._ti) / 1000000L;
        if (this._hogTime < t1) {
            this._hogTime = t1;
            this._hog = hog;
        }
    }

    public void report() {
        if (this.getHog() != null) {
            Assert.printTiming(this.getHogTime(), this.getHog().getClass().getName(), INDENT);
        }
    }

    public void reportTotal(String msg) {
        Assert.printTiming(this.getElapsedTime(), msg, null);
    }

    public long getElapsedTime() {
        return (System.nanoTime() - this._t0) / 1000000L;
    }

    public Object getHog() {
        return this._hog;
    }

    public long getHogTime() {
        return this._hogTime;
    }
}

