/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;

final class ArrayTextBuffer
extends AbstractTextBuffer {
    private static final int INITIAL_BUFFER_SIZE = 64;
    private static final int MINIMUM_INCREMENT = 16;
    private static final int MAXIMUM_INCREMENT = 512;
    private static final float INCREMENT_RATE = 0.2f;
    private static final int MAXIMUM_OVERHEAD = 2048;
    private char[] arrayBuffer = new char[64];
    private int dataSize = 0;

    ArrayTextBuffer(ReadWriteLock lockToUse) {
        super(lockToUse);
    }

    public int getLength() {
        return this.dataSize;
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        if (offset >= this.dataSize) {
            throw new IndexOutOfBoundsException("getChar out of bounds:  dataSize: " + this.dataSize + " offset: " + offset);
        }
        return this.arrayBuffer[offset];
    }

    protected char[] getCharsImpl(int offset, int length) throws IndexOutOfBoundsException {
        this.checkOffsets(offset, length);
        char[] data = new char[length];
        System.arraycopy(this.arrayBuffer, offset, data, 0, length);
        return data;
    }

    protected String getStringImpl(int offset, int length) throws IndexOutOfBoundsException {
        this.checkOffsets(offset, length);
        return new String(this.arrayBuffer, offset, length);
    }

    protected void getTextImpl(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        this.checkOffsets(offset, length);
        segment.array = this.arrayBuffer;
        segment.offset = offset;
        segment.count = length;
    }

    protected void insertImpl(int offset, char[] data, int dataOffset, int dataLength) {
        if (offset > this.dataSize) {
            throw new IndexOutOfBoundsException("insertImpl out ofbounds:  dataSize: " + this.dataSize + " offset: " + offset);
        }
        int oldSize = this.arrayBuffer.length;
        int userDataSize = dataLength;
        char[] newArrayBuffer = this.arrayBuffer;
        if (this.dataSize + userDataSize > oldSize) {
            int newSize = this.dataSize + userDataSize;
            int increment = (int)((float)newSize * 0.2f);
            increment = Math.min(512, increment);
            increment = Math.max(16, increment);
            newArrayBuffer = new char[newSize += increment];
            System.arraycopy(this.arrayBuffer, 0, newArrayBuffer, 0, offset);
        }
        System.arraycopy(this.arrayBuffer, offset, newArrayBuffer, offset + userDataSize, this.dataSize - offset);
        System.arraycopy(data, dataOffset, newArrayBuffer, offset, userDataSize);
        this.arrayBuffer = newArrayBuffer;
        this.dataSize += userDataSize;
    }

    protected void removeImpl(int offset, int count) {
        this.checkOffsets(offset, count);
        int oldSize = this.arrayBuffer.length;
        int newDataSize = this.dataSize - count;
        char[] newArrayBuffer = this.arrayBuffer;
        if (oldSize - newDataSize > 2048) {
            int newSize = newDataSize;
            int increment = (int)((float)newSize * 0.2f);
            increment = Math.min(512, increment);
            increment = Math.max(16, increment);
            newArrayBuffer = new char[newSize += increment];
            System.arraycopy(this.arrayBuffer, 0, newArrayBuffer, 0, offset);
        }
        System.arraycopy(this.arrayBuffer, offset + count, newArrayBuffer, offset, this.dataSize - (offset + count));
        this.arrayBuffer = newArrayBuffer;
        this.dataSize -= count;
    }

    private void checkOffsets(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.dataSize) {
            throw new IndexOutOfBoundsException("out of bounds: dataSize: " + this.dataSize + " offset: " + offset + " length: " + length);
        }
    }
}

