/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

public final class CharArrayReadTextBuffer
implements ReadTextBuffer {
    private char[] dataSource;

    public CharArrayReadTextBuffer(char[] dataSource) {
        this.dataSource = dataSource;
    }

    public int getLength() {
        return this.dataSource.length;
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        return this.dataSource[offset];
    }

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        char[] buffer = new char[length];
        System.arraycopy(this.dataSource, offset, buffer, 0, length);
        return buffer;
    }

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        return new String(this.dataSource, offset, length);
    }

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this.getChars(offset, length);
        segment.offset = 0;
        segment.count = length;
    }

    public void readLock() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public void readUnlock() {
    }

    public int getLockStatus() {
        return -1;
    }
}

