/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.text.Segment;
import oracle.javatools.buffer.TextBuffer;

final class DigestHash {
    private byte[] _digestHash;
    private int _hashCode;

    private DigestHash(byte[] digestHash) {
        this._digestHash = digestHash;
        this._hashCode = -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DigestHash computeDigestHash(TextBuffer buffer) {
        buffer.readLock();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (digest == null) return null;
            int CHAR_FETCH_SIZE = 128;
            int BYTE_FETCH_SIZE = 256;
            byte[] byteData = new byte[256];
            Segment segment = new Segment();
            int charsLeft = buffer.getLength();
            int pos = 0;
            block7: while (true) {
                if (charsLeft <= 0) {
                    DigestHash digestHash = new DigestHash(digest.digest());
                    return digestHash;
                }
                int charsToFetch = Math.min(128, charsLeft);
                buffer.getText(pos, charsToFetch, segment);
                int segmentSize = segment.count;
                int segmentStart = segment.offset;
                int segmentEnd = segmentStart + segmentSize;
                char[] segmentData = segment.array;
                int writePos = 0;
                int i = segmentStart;
                while (true) {
                    if (i >= segmentEnd) {
                        digest.update(byteData, 0, writePos);
                        charsLeft -= charsToFetch;
                        pos += charsToFetch;
                        continue block7;
                    }
                    char c = segmentData[i];
                    byteData[writePos++] = (byte)(c & 0xFF);
                    byteData[writePos++] = (byte)(c >>> 8 & 0xFF);
                    ++i;
                }
                break;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("  Warning: MD5 digest unavailable: " + e.getMessage());
            return null;
        }
        finally {
            buffer.readUnlock();
        }
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int hashValue = 0;
            int length = this._digestHash.length;
            int i = 0;
            while (i < length) {
                hashValue = hashValue * 19 + this._digestHash[i];
                ++i;
            }
            this._hashCode = hashValue;
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DigestHash) {
            return DigestHash.equals(this._digestHash, ((DigestHash)obj)._digestHash);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int length = this._digestHash.length;
        int i = 0;
        while (i < length) {
            buffer.append(Character.forDigit(this._digestHash[i] >> 4 & 0xF, 16));
            buffer.append(Character.forDigit(this._digestHash[i] >> 0 & 0xF, 16));
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        int len1 = data1.length;
        int len2 = data2.length;
        if (len1 != len2) {
            return false;
        }
        int i = 0;
        while (i < len1) {
            if (data1[i] != data2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

