/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.util.CopyOnWriteList;

public class ForwardingTextBufferListener
implements TextBufferListener {
    private TextBuffer buffer;
    private CopyOnWriteList listeners;

    private void $init$() {
        this.listeners = new CopyOnWriteList();
    }

    public ForwardingTextBufferListener(TextBuffer buffer) {
        this.$init$();
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextBufferListener(TextBufferListener listener) {
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            Object[] list = this.listeners.getItems();
            int i = list.length;
            while (i-- > 0) {
                WeakReference reference = (WeakReference)list[i];
                if (listener != reference.get()) continue;
                return;
            }
            this.listeners.add(new WeakReference<TextBufferListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextBufferListener(TextBufferListener listener) {
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            Object[] list = this.listeners.getItems();
            int i = list.length;
            while (i-- > 0) {
                WeakReference reference = (WeakReference)list[i];
                if (listener != reference.get()) continue;
                this.listeners.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pack() {
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            Object[] list = this.listeners.getItems();
            int i = list.length;
            while (i-- > 0) {
                WeakReference reference = (WeakReference)list[i];
                if (reference.get() != null) continue;
                this.listeners.remove(i);
            }
        }
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        boolean pack = false;
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            WeakReference reference = (WeakReference)i.next();
            TextBufferListener listener = (TextBufferListener)reference.get();
            if (listener != null) {
                listener.attributeUpdate(this.buffer, attribute);
                continue;
            }
            pack = true;
        }
        if (pack) {
            this.pack();
        }
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        boolean pack = false;
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            WeakReference reference = (WeakReference)i.next();
            TextBufferListener listener = (TextBufferListener)reference.get();
            if (listener != null) {
                listener.insertUpdate(this.buffer, offset, count, insertedData);
                continue;
            }
            pack = true;
        }
        if (pack) {
            this.pack();
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        boolean pack = false;
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            WeakReference reference = (WeakReference)i.next();
            TextBufferListener listener = (TextBufferListener)reference.get();
            if (listener != null) {
                listener.removeUpdate(this.buffer, offset, count, removedData);
                continue;
            }
            pack = true;
        }
        if (pack) {
            this.pack();
        }
    }
}

