/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.awt.EventQueue;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Version;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadWriteLock {
    private static final Logger LOGGER;
    public static final int DEFAULT_WAIT_INTERVAL = 2000;
    public static final int DEFAULT_DEADLOCK_INTERVAL = 20000;
    public static final int DEFAULT_HISTORY_LIMIT;
    public static final EnumSet<Options> DEFAULT_OPTIONS;
    private final Object internalLock;
    private volatile Object name;
    private Map<Thread, ThreadState> readers;
    private Thread writeThread;
    private ThreadState writeState;
    private CopyOnWriteArrayList<WriteLockRequestListener> writeRequestListeners;
    private final boolean collectHistory;
    private final int historyLimit;
    private final boolean logUpgrades;
    private final boolean logDeadlocks;
    private final boolean logDialogs;
    private final int waitInterval;
    private final int deadlockInterval;
    private boolean deadlockReported;
    private static final int PUBLIC_LOCK_METHOD_INDEX = 2;
    private static final int DUMP_THREADS_DELTA_INDEX = 2;
    private Set<Thread> blockedThreads;
    private volatile Log eventLog;
    private static final Set<String> apiMethods;

    static {
        int limit;
        LOGGER = Logger.getLogger("oracle.javatools.lock");
        String value = System.getProperty("oracle.javatools.lock.history.limit");
        if (value != null) {
            try {
                limit = Integer.parseInt(value);
                if (limit <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                limit = 100;
                LOGGER.log(Level.WARNING, "Value ''{0}'' of property \"oracle.javatools.lock.history.limit\" not valid: expected positive integer", new Object[]{value});
            }
        } else {
            limit = 100;
        }
        DEFAULT_HISTORY_LIMIT = limit;
        String text = System.getProperty("oracle.javatools.lock");
        DEFAULT_OPTIONS = text != null ? ReadWriteLock.parseOptions(text) : (Version.DEBUG_BUILD == 0 ? EnumSet.of(Options.DEADLOCKS, Options.UPGRADES, Options.HISTORY) : EnumSet.of(Options.DEADLOCKS, Options.UPGRADES, Options.HISTORY, Options.NESTED_HISTORY));
        apiMethods = Collections.synchronizedSet(new HashSet());
    }

    private void $init$() {
        this.internalLock = new Object();
        this.readers = new ArrayMap<Thread, ThreadState>();
        this.writeRequestListeners = new CopyOnWriteArrayList();
    }

    private void invariants() {
        if (this.blockedThreads.isEmpty()) {
            this.deadlockReported = false;
        }
    }

    public ReadWriteLock() {
        this(null);
    }

    public ReadWriteLock(String name) {
        this(name, DEFAULT_OPTIONS, 2000, 20000, DEFAULT_HISTORY_LIMIT);
    }

    public ReadWriteLock(String name, EnumSet<Options> options, int waitInterval, int deadlockInterval, int historyLimit) {
        this.$init$();
        this.setName(name);
        if (options == null) {
            options = DEFAULT_OPTIONS;
        }
        this.logDeadlocks = options.contains((Object)Options.DEADLOCKS);
        this.logDialogs = options.contains((Object)Options.DIALOGS);
        this.logUpgrades = options.contains((Object)Options.UPGRADES);
        this.collectHistory = options.contains((Object)Options.HISTORY) || options.contains((Object)Options.NESTED_HISTORY);
        this.historyLimit = options.contains((Object)Options.NESTED_HISTORY) ? historyLimit : 0;
        this.waitInterval = waitInterval;
        this.deadlockInterval = deadlockInterval;
        this.blockedThreads = new HashSet<Thread>();
    }

    public final void setName(String name) {
        this.name = name != null ? name : Integer.valueOf(System.identityHashCode(this));
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public void readLock() {
        this.readLockInternal(true);
    }

    public boolean tryReadLock() {
        return this.readLockInternal(false);
    }

    public void readUnlock() {
        this.readUnlockInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        Object object = this.internalLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (thread != this.writeThread && !this.readers.containsKey(thread)) {
                throw new IllegalMonitorStateException("no lock of " + this + " held from " + thread);
            }
            this.writeRequestListeners.add(listener);
            boolean bl = this.blockedThreads.isEmpty() ^ true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        Object object = this.internalLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (thread != this.writeThread && !this.readers.containsKey(thread)) {
                throw new IllegalMonitorStateException("no lock of " + this + " held from " + thread);
            }
            this.writeRequestListeners.remove(listener);
        }
    }

    public void writeLock() {
        this.writeLockInternal(true, null);
    }

    public boolean tryWriteLock() {
        return this.writeLockInternal(false, null);
    }

    public void writeUnlock() {
        this.writeUnlockInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLockFromReadLock() {
        ThreadState state;
        Thread thread = Thread.currentThread();
        int readCount = 0;
        Object object = this.internalLock;
        synchronized (object) {
            this.invariants();
            state = this.readers.get(thread);
            if (state != null && thread != this.writeThread) {
                this.logEvent(Event.READ_UNLOCK_UPGRADE);
                readCount = ThreadState.ra$readCount(state);
                ThreadState.wa$readCount(state, 0);
                this.readers.remove(thread);
                this.notifyBlockedThreads();
            }
            this.invariants();
        }
        this.writeLockInternal(true, state);
        if (readCount > 0) {
            Object object2 = this.internalLock;
            synchronized (object2) {
                state = this.writeState;
                this.readers.put(thread, state);
                ThreadState.wa$readCount(state, readCount);
                this.logEvent(Event.READ_LOCK_UPGRADE);
                this.invariants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadLockHeld() {
        Object object = this.internalLock;
        synchronized (object) {
            boolean bl = this.readers.containsKey(Thread.currentThread());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteLockHeld() {
        Object object = this.internalLock;
        synchronized (object) {
            boolean bl = this.writeThread == Thread.currentThread();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockHeld() {
        Object object = this.internalLock;
        synchronized (object) {
            boolean bl = this.isReadLockHeld() || this.isWriteLockHeld();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadHoldCount() {
        Object object = this.internalLock;
        synchronized (object) {
            ThreadState state = this.readers.get(Thread.currentThread());
            int n = state != null ? ThreadState.ra$readCount(state) : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWriteHoldCount() {
        Object object = this.internalLock;
        synchronized (object) {
            int n = this.writeThread == Thread.currentThread() ? ThreadState.ra$writeCount(this.writeState) : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendSnapshot(StringBuilder buffer) {
        Object object = this.internalLock;
        synchronized (object) {
            if (this.writeThread != null) {
                this.appendThreadState(buffer, this.writeThread, false, this.writeThread.getStackTrace());
            }
            for (ThreadState state : this.readers.values()) {
                Thread thread = ThreadState.ra$thread(state);
                if (thread == this.writeThread) continue;
                this.appendThreadState(buffer, thread, false, thread.getStackTrace());
            }
            for (Thread thread : this.blockedThreads) {
                if (thread == this.writeThread || this.readers.containsKey(thread)) continue;
                this.appendThreadState(buffer, thread, false, thread.getStackTrace());
            }
        }
    }

    public String toString() {
        return "lock '" + this.name + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readLockInternal(boolean block) {
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            boolean acquired;
            this.logEvent(Event.READ_LOCK_REQUEST);
            this.invariants();
            long start = 0L;
            int nominalElapsed = 0;
            while (true) {
                if (this.writeThread == null || this.writeThread == thread) {
                    ThreadState state = this.readers.get(thread);
                    if (state == null) {
                        state = thread == this.writeThread ? this.writeState : new ThreadState(thread, this.collectHistory);
                        this.readers.put(thread, state);
                    }
                    ThreadState threadState = state;
                    ThreadState.wa$readCount(threadState, ThreadState.ra$readCount(threadState) + 1);
                    this.traceReadLock(state);
                    acquired = true;
                    this.logEvent(Event.READ_LOCK_GRANT);
                    break;
                }
                if (!block) {
                    acquired = false;
                    this.logEvent(Event.READ_LOCK_DENIAL);
                    break;
                }
                if (start == 0L) {
                    start = System.currentTimeMillis();
                } else {
                    this.traceDeadlock(start, nominalElapsed);
                }
                this.block(this.waitInterval);
                nominalElapsed += this.waitInterval;
            }
            this.invariants();
            boolean bl = acquired;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUnlockInternal() {
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            this.invariants();
            ThreadState state = this.readers.get(thread);
            if (state == null) {
                throw new IllegalMonitorStateException("read lock of " + this + " not held from " + thread);
            }
            this.traceReadUnlock(state);
            ThreadState threadState = state;
            int n = ThreadState.ra$readCount(threadState) - 1;
            ThreadState.wa$readCount(threadState, n);
            if (n == 0) {
                this.readers.remove(thread);
                this.notifyBlockedThreads();
            }
            this.logEvent(Event.READ_UNLOCK);
            this.invariants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLockInternal(boolean block, ThreadState upgrade) {
        if (block) {
            for (WriteLockRequestListener listener : this.writeRequestListeners) {
                try {
                    if (this.eventLog != null) {
                        this.eventLog.trace("WRITE_LOCK_REQUEST_NOTIFY for {0}: {1}", this, (Object)listener);
                    }
                    listener.writeRequested(this);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "unexpected exception invoked write request listener " + listener, e);
                }
            }
        }
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            boolean acquired;
            this.logEvent(Event.WRITE_LOCK_REQUEST);
            this.invariants();
            this.traceUpgrade();
            long start = 0L;
            int nominalElapsed = 0;
            while (true) {
                ThreadState state = this.readers.get(thread);
                if (this.writeThread == thread || this.writeThread == null && this.readers.isEmpty() || this.writeThread == null && state != null && this.readers.size() == 1) {
                    if (this.writeThread == null) {
                        this.writeThread = thread;
                        if (state == null) {
                            state = upgrade != null ? upgrade : new ThreadState(thread, this.collectHistory);
                        }
                        this.writeState = state;
                    }
                    ThreadState threadState = this.writeState;
                    ThreadState.wa$writeCount(threadState, ThreadState.ra$writeCount(threadState) + 1);
                    this.traceWriteLock(this.writeState);
                    acquired = true;
                    this.logEvent(Event.WRITE_LOCK_GRANT);
                    break;
                }
                if (!block) {
                    acquired = false;
                    this.logEvent(Event.WRITE_LOCK_DENIAL);
                    break;
                }
                if (start == 0L) {
                    start = System.currentTimeMillis();
                } else {
                    this.traceDeadlock(start, nominalElapsed);
                }
                this.block(this.waitInterval);
                nominalElapsed += this.waitInterval;
            }
            this.invariants();
            boolean bl = acquired;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlockInternal() {
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            this.invariants();
            if (this.writeThread == null || this.writeThread != thread) {
                throw new IllegalMonitorStateException("write lock of " + this + " not held from " + thread);
            }
            this.traceWriteUnlock(this.writeState);
            ThreadState threadState = this.writeState;
            int n = ThreadState.ra$writeCount(threadState) - 1;
            ThreadState.wa$writeCount(threadState, n);
            if (n == 0) {
                this.writeThread = null;
                this.writeState = null;
                this.internalLock.notifyAll();
            }
            this.logEvent(Event.WRITE_UNLOCK);
            this.invariants();
        }
    }

    private void block(int interval) {
        Thread thread = Thread.currentThread();
        this.blockedThreads.add(thread);
        try {
            try {
                this.internalLock.wait(interval);
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            this.blockedThreads.remove(thread);
        }
    }

    private void notifyBlockedThreads() {
        if (this.writeThread == null && !this.blockedThreads.isEmpty()) {
            switch (this.readers.size()) {
                case 0: {
                    this.internalLock.notify();
                    break;
                }
                case 1: {
                    this.internalLock.notifyAll();
                    break;
                }
            }
        }
    }

    private void traceUpgrade() {
        Thread thread;
        if (this.logUpgrades && (thread = Thread.currentThread()) != this.writeThread && this.readers.containsKey(thread)) {
            IllegalMonitorStateException exception = new IllegalMonitorStateException("lock " + this.name + " upgraded");
            int depth = 3;
            StackTraceElement[] trace = exception.getStackTrace();
            while (depth < trace.length) {
                StackTraceElement element = trace[depth];
                String methodName = element.getMethodName();
                if (!"writeLock".equals(methodName) && !apiMethods.contains(element.getClassName() + ":" + methodName)) break;
                ++depth;
            }
            StringBuilder buffer = new StringBuilder();
            this.appendThreadState(buffer, thread, false, trace);
            LOGGER.log(Level.SEVERE, "lock upgrade; lock ''{0}'' upgraded on thread ''{1}'':{2}", new Object[]{this.name, thread.getName(), buffer, new FeedbackLogOptions((Throwable)exception, depth)});
        }
    }

    private void traceDeadlock(long start, int nominalElapsed) {
        int actualElapsed;
        int elapsed;
        if (this.logDeadlocks && !this.deadlockReported && (elapsed = Math.min(nominalElapsed, actualElapsed = (int)(System.currentTimeMillis() - start))) > this.deadlockInterval) {
            String see;
            StringBuilder buffer = new StringBuilder();
            Thread currentThread = Thread.currentThread();
            this.appendThreadState(buffer, currentThread, true, new Throwable().getStackTrace());
            for (Thread thread : this.blockedThreads) {
                if (thread == currentThread || thread == this.writeThread || this.readers.containsKey(thread)) continue;
                this.appendThreadState(buffer, thread, false, thread.getStackTrace());
            }
            boolean allThreadsRunnable = true;
            if (this.writeThread != null) {
                StackTraceElement[] trace = this.writeThread.getStackTrace();
                if (this.suppressBecauseShowingDialog(trace)) {
                    this.deadlockReported = true;
                    return;
                }
                this.appendThreadState(buffer, this.writeThread, false, trace);
                allThreadsRunnable &= this.writeThread.getState() == Thread.State.RUNNABLE;
            }
            for (ThreadState state : this.readers.values()) {
                Thread thread = ThreadState.ra$thread(state);
                if (thread == currentThread || thread == this.writeThread) continue;
                StackTraceElement[] trace = thread.getStackTrace();
                if (this.suppressBecauseShowingDialog(trace)) {
                    this.deadlockReported = true;
                    return;
                }
                this.appendThreadState(buffer, thread, false, trace);
                allThreadsRunnable &= thread.getState() == Thread.State.RUNNABLE;
            }
            File file = ReadWriteLock.logFile(allThreadsRunnable);
            boolean needThreadDump = true;
            if (file != null) {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] threads = null;
                Boolean synchronizer = false;
                Method getMethod = null;
                Method lockedMonitorsMethod = null;
                Method lockedStackDepth = null;
                Method lockedSynchronizersMethod = null;
                Method deadlockedThreadsMethod = null;
                try {
                    try {
                        Method monitorMethod = ThreadMXBean.class.getMethod("isObjectMonitorUsageSupported", new Class[0]);
                        Boolean monitor = (Boolean)monitorMethod.invoke((Object)bean, new Object[0]);
                        Method synchronizerMethod = ThreadMXBean.class.getMethod("isSynchronizerUsageSupported", new Class[0]);
                        synchronizer = (Boolean)synchronizerMethod.invoke((Object)bean, new Object[0]);
                        getMethod = ThreadMXBean.class.getMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
                        lockedMonitorsMethod = ThreadInfo.class.getMethod("getLockedMonitors", new Class[0]);
                        Class<?> monitorInfo = Class.forName("java.lang.management.MonitorInfo");
                        lockedStackDepth = monitorInfo.getMethod("getLockedStackDepth", new Class[0]);
                        lockedSynchronizersMethod = ThreadInfo.class.getMethod("getLockedSynchronizers", new Class[0]);
                        deadlockedThreadsMethod = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
                        threads = (ThreadInfo[])getMethod.invoke((Object)bean, bean.getAllThreadIds(), monitor, synchronizer);
                        needThreadDump = false;
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (InvocationTargetException e) {
                    }
                    catch (ClassNotFoundException e) {}
                }
                finally {
                    if (threads == null) {
                        threads = bean.getThreadInfo(bean.getAllThreadIds(), Integer.MAX_VALUE);
                    }
                }
                PrintWriter writer = null;
                try {
                    try {
                        writer = new PrintWriter(file);
                        writer.print("Thread '");
                        writer.print(currentThread.getName());
                        writer.print("' blocked on lock '");
                        writer.print(this.getName());
                        writer.print("' for more than ");
                        writer.print(this.deadlockInterval);
                        writer.println("ms");
                        writer.println();
                        writer.print("Oracle ");
                        writer.print(Version.NAME_SHORT);
                        writer.print(" ");
                        writer.print(Version.VER);
                        writer.print(" ");
                        writer.print(Version.BUILD_NUM);
                        writer.print(" (");
                        writer.print(Version.BUILD_LABEL);
                        writer.println(")");
                        writer.print(System.getProperty("java.vendor"));
                        writer.print(" Java ");
                        writer.println(System.getProperty("java.runtime.version"));
                        writer.print("Diagnostic options: ");
                        writer.println(DEFAULT_OPTIONS);
                        writer.println();
                        Diagnostics.writeBanner(writer, "Lock Diagnostic");
                        int i0 = 0;
                        int i1 = buffer.indexOf("\n");
                        while (i1 >= 0) {
                            writer.append(buffer, i0, i1);
                            writer.println();
                            i0 = i1 + 1;
                            i1 = buffer.indexOf("\n", i0);
                        }
                        writer.append(buffer, i0, buffer.length());
                        writer.println();
                        Diagnostics.writeBanner(writer, "Thread Dump");
                        ThreadInfo[] threadInfoArray = threads;
                        int n = 0;
                        while (n < threadInfoArray.length) {
                            Object[] locks;
                            ThreadInfo thread = threadInfoArray[n];
                            writer.println();
                            writer.print("\"");
                            writer.print(thread.getThreadName());
                            writer.print("\" id=");
                            writer.print(thread.getThreadId());
                            writer.print(" ");
                            writer.print((Object)thread.getThreadState());
                            String lockName = thread.getLockName();
                            if (lockName != null) {
                                writer.print(" on ");
                                writer.print(lockName);
                            }
                            if (thread.getLockOwnerName() != null) {
                                writer.print(" owned by \"");
                                writer.print(thread.getLockOwnerName());
                                writer.print("\" id=");
                                writer.print(thread.getLockOwnerId());
                            }
                            if (thread.isSuspended()) {
                                writer.print(" (suspended)");
                            }
                            if (thread.isInNative()) {
                                writer.print(" (in native)");
                            }
                            writer.println();
                            StackTraceElement[] stackTrace = thread.getStackTrace();
                            int i = 0;
                            while (i < stackTrace.length) {
                                writer.print("\tat ");
                                writer.println(stackTrace[i]);
                                if (i == 0 && lockName != null) {
                                    Thread.State ts = thread.getThreadState();
                                    switch (1.$sm$java$lang$Thread$State[ts.ordinal()]) {
                                        case 1: {
                                            writer.print("\t-  blocked on ");
                                            writer.println(lockName);
                                            break;
                                        }
                                        case 2: {
                                            writer.print("\t-  waiting on ");
                                            writer.println(lockName);
                                            break;
                                        }
                                        case 3: {
                                            writer.print("\t-  waiting on ");
                                            writer.println(lockName);
                                            break;
                                        }
                                    }
                                }
                                if (lockedMonitorsMethod != null) {
                                    try {
                                        Object[] objectArray = (Object[])lockedMonitorsMethod.invoke((Object)thread, new Object[0]);
                                        int n2 = 0;
                                        while (n2 < objectArray.length) {
                                            Object monitor = objectArray[n2];
                                            if ((Integer)lockedStackDepth.invoke(monitor, new Object[0]) == i) {
                                                writer.print("\t-  locked ");
                                                writer.println(monitor);
                                            }
                                            ++n2;
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                    }
                                    catch (IllegalArgumentException e) {
                                    }
                                    catch (InvocationTargetException e) {
                                        // empty catch block
                                    }
                                }
                                ++i;
                            }
                            if (lockedSynchronizersMethod != null && (locks = (Object[])lockedSynchronizersMethod.invoke((Object)thread, new Object[0])).length > 0) {
                                writer.println();
                                writer.println("\tLocked synchronizers:");
                                Object[] objectArray = locks;
                                int n3 = 0;
                                while (n3 < objectArray.length) {
                                    Object lock = objectArray[n3];
                                    writer.println("\t- ");
                                    writer.println(lock);
                                    ++n3;
                                }
                            }
                            ++n;
                        }
                        writer.println();
                        long[] ids = synchronizer != false && deadlockedThreadsMethod != null ? (long[])deadlockedThreadsMethod.invoke((Object)bean, new Object[0]) : bean.findMonitorDeadlockedThreads();
                        if (ids != null) {
                            ThreadInfo[] deadlockedThreads = getMethod != null ? (ThreadInfo[])getMethod.invoke((Object)ids, true, true) : bean.getThreadInfo(ids);
                            if (deadlockedThreads != null) {
                                writer.println("Found deadlock:");
                                ThreadInfo[] threadInfoArray2 = deadlockedThreads;
                                int n4 = 0;
                                while (n4 < threadInfoArray2.length) {
                                    ThreadInfo thread = threadInfoArray2[n4];
                                    writer.print("\t\"");
                                    writer.print(thread.getThreadName());
                                    writer.print("\" id=");
                                    writer.print(thread.getThreadId());
                                    writer.print(" ");
                                    writer.print((Object)thread.getThreadState());
                                    String lockName = thread.getLockName();
                                    if (lockName != null) {
                                        writer.print(" on ");
                                        writer.print(lockName);
                                    }
                                    if (thread.getLockOwnerName() != null) {
                                        writer.print(" owned by \"");
                                        writer.print(thread.getLockOwnerName());
                                        writer.print("\" id=");
                                        writer.print(thread.getLockOwnerId());
                                    }
                                    if (thread.isSuspended()) {
                                        writer.print(" (suspended)");
                                    }
                                    if (thread.isInNative()) {
                                        writer.print(" (in native)");
                                    }
                                    writer.println();
                                    ++n4;
                                }
                            }
                            writer.println();
                        }
                        Diagnostics.writeBanner(writer, "System Configuration");
                        writer.println();
                        Diagnostics.writeSystemConfiguration(writer);
                    }
                    catch (Throwable e) {}
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                see = "See full log at \"" + file.getAbsolutePath() + "\"\n";
                if (needThreadDump) {
                    see = see + "[To file bug, also include thread dump if possible.]\n";
                }
            } else {
                see = "";
            }
            LOGGER.log(Level.SEVERE, "lock {0}; thread ''{1}'' blocked on lock ''{2}'' for more than {3}ms:\n{4}\n{5}\n", new Object[]{allThreadsRunnable ? "starvation" : "deadlock", currentThread.getName(), this.name, this.deadlockInterval, buffer, see});
            this.deadlockReported = true;
        }
    }

    private static File logFile(boolean allThreadsRunnable) {
        return Diagnostics.newFile(allThreadsRunnable ? "STARVATION" : "DEADLOCK", String.valueOf(Thread.currentThread().getId()));
    }

    private boolean suppressBecauseShowingDialog(StackTraceElement[] trace) {
        if (this.logDialogs) {
            return false;
        }
        if (trace.length == 0) {
            return false;
        }
        StackTraceElement[] stackTraceElementArray = trace;
        int n = 0;
        while (n < stackTraceElementArray.length) {
            StackTraceElement element = stackTraceElementArray[n];
            if ("java.awt.Dialog".equals(element.getClassName()) && "show".equals(element.getMethodName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void traceReadLock(ThreadState state) {
        ThreadState threadState = state;
        int n = ThreadState.ra$historySize(threadState);
        ThreadState.wa$historySize(threadState, n + 1);
        if (n < this.historyLimit || this.collectHistory && ThreadState.ra$readCount(state) == 1) {
            ThreadState.ra$history(state).add(new Throwable("readLock"));
        }
    }

    private void traceReadUnlock(ThreadState state) {
        ThreadState threadState = state;
        int n = ThreadState.ra$historySize(threadState);
        ThreadState.wa$historySize(threadState, n + 1);
        if (n < this.historyLimit || this.collectHistory && ThreadState.ra$readCount(state) == 1) {
            ThreadState.ra$history(state).add(new Throwable("readUnlock"));
        }
    }

    private void traceWriteLock(ThreadState state) {
        ThreadState threadState = state;
        int n = ThreadState.ra$historySize(threadState);
        ThreadState.wa$historySize(threadState, n + 1);
        if (n < this.historyLimit || this.collectHistory && ThreadState.ra$writeCount(state) == 1) {
            ThreadState.ra$history(state).add(new Throwable("writeLock"));
        }
    }

    private void traceWriteUnlock(ThreadState state) {
        ThreadState threadState = state;
        int n = ThreadState.ra$historySize(threadState);
        ThreadState.wa$historySize(threadState, n + 1);
        if (n < this.historyLimit || this.collectHistory && ThreadState.ra$writeCount(state) == 1) {
            ThreadState.ra$history(state).add(new Throwable("writeUnlock"));
        }
    }

    private void appendThreadState(StringBuilder buffer, Thread thread, boolean blocked, StackTraceElement[] currentTrace) {
        ThreadState state = this.readers.get(thread);
        if (thread == this.writeThread) {
            state = this.writeState;
        }
        int readCount = 0;
        int writeCount = 0;
        ArrayList<StackTraceElement[]> unpairedCalls = new ArrayList<StackTraceElement[]>();
        int methodPairs = 0;
        int classPairs = 0;
        int discardedSize = 0;
        if (state != null) {
            readCount = ThreadState.ra$readCount(state);
            writeCount = ThreadState.ra$writeCount(state);
            if (ThreadState.ra$history(state) != null && !ThreadState.ra$history(state).isEmpty()) {
                discardedSize = ThreadState.ra$historySize(state) - ThreadState.ra$history(state).size();
                List history = ThreadState.ra$history(state);
                for (Throwable call : history) {
                    StackTraceElement[] thisTrace = call.getStackTrace();
                    if (unpairedCalls.isEmpty()) {
                        unpairedCalls.add(thisTrace);
                        continue;
                    }
                    String thisType = thisTrace[2].getMethodName();
                    if (thisType.endsWith("Lock")) {
                        unpairedCalls.add(thisTrace);
                        continue;
                    }
                    StackTraceElement[] lastTrace = (StackTraceElement[])unpairedCalls.get(unpairedCalls.size() - 1);
                    String lastType = lastTrace[2].getMethodName();
                    if (!lastType.regionMatches(0, thisType, 0, 4)) continue;
                    StackTraceElement thisCaller = thisTrace[3];
                    StackTraceElement lastCaller = lastTrace[3];
                    if (thisCaller.getClassName().equals(lastCaller.getClassName())) {
                        unpairedCalls.remove(unpairedCalls.size() - 1);
                        if (thisCaller.getMethodName().equals(lastCaller.getMethodName())) {
                            ++methodPairs;
                            continue;
                        }
                        ++classPairs;
                        continue;
                    }
                    unpairedCalls.add(thisTrace);
                }
            }
        }
        buffer.append("\n\"");
        buffer.append(thread.getName());
        buffer.append("\" ");
        if (blocked || this.blockedThreads.contains(thread)) {
            buffer.append("blocked, ");
        }
        this.appendCounted(buffer, readCount, " read", ", ");
        this.appendCounted(buffer, writeCount, " write", "");
        if (this.collectHistory) {
            int pairedSize = 2 * classPairs + 2 * methodPairs;
            int unpairedSize = unpairedCalls.size();
            int calls = unpairedSize + pairedSize;
            if (calls > 0) {
                buffer.append(", ");
                if (pairedSize == 0 && discardedSize == 0) {
                    this.appendCounted(buffer, unpairedSize, " unpaired history trace", "");
                } else {
                    this.appendCounted(buffer, calls, " history trace", "");
                    if (discardedSize > 0) {
                        buffer.append(" (");
                        buffer.append(discardedSize);
                        buffer.append(" discarded)");
                    }
                    buffer.append(", ");
                    if (unpairedSize == 0) {
                        buffer.append("none");
                    } else {
                        buffer.append(unpairedSize);
                    }
                    buffer.append(" unpaired");
                }
            }
        } else {
            buffer.append(", no history collected");
        }
        if (currentTrace != null) {
            buffer.append(":\n");
            this.appendStackTrace(buffer, currentTrace);
        } else {
            buffer.append("\n");
        }
        int count = 0;
        for (StackTraceElement[] trace : unpairedCalls) {
            buffer.append("\nUnpaired history trace ");
            buffer.append(++count);
            buffer.append(" for \"");
            buffer.append(thread.getName());
            buffer.append("\"\n");
            this.appendStackTrace(buffer, trace);
        }
    }

    private void appendStackTrace(StringBuilder buffer, StackTraceElement[] trace) {
        int i = 0;
        if (trace.length > 0) {
            String type = trace[0].getClassName();
            String method = trace[0].getMethodName();
            if (type.equals("oracle.javatools.buffer.ReadWriteLock") && method.startsWith("trace")) {
                i = 2;
            } else if (type.equals("java.lang.Thread") && method.equals("dumpThreads")) {
                i = 2;
            }
        }
        while (i < trace.length) {
            buffer.append("\tat ");
            buffer.append(trace[i]);
            buffer.append('\n');
            ++i;
        }
    }

    private void appendCounted(StringBuilder buffer, int count, String head, String tail) {
        if (count == 0) {
            buffer.append("no");
        } else {
            buffer.append(count);
        }
        buffer.append(head);
        if (count == 0 || count > 1) {
            buffer.append('s');
        }
        buffer.append(tail);
    }

    /*
     * Unable to fully structure code
     */
    private static EnumSet<Options> parseOptions(String text) {
        if (text != null) {
            options = EnumSet.noneOf(Options.class);
            var8_2 = text.split(",");
            var9_3 = 0;
            while (var9_3 < var8_2.length) {
                block16: {
                    token = var8_2[var9_3];
                    option = token.trim().toUpperCase();
                    if (!"".equals(option)) {
                        try {
                            options.add(Options.valueOf(option));
                            break block16;
                        }
                        catch (Exception e) {
                            if ("ALL".equals(option)) {
                                options = EnumSet.allOf(Options.class);
                                break block16;
                            }
                            if ("NONE".equals(option)) {
                                options = EnumSet.noneOf(Options.class);
                                break block16;
                            }
                            if ("TRUE".equals(option)) {
                                options = EnumSet.allOf(Options.class);
                                break block16;
                            }
                            expectedOptions = new StringBuilder();
                            var10_9 = (Options[])Options.class.getEnumConstants();
                            var11_10 = 0;
                            ** while (var11_10 < var10_9.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            constant = var10_9[var11_10];
                            expectedOptions.append("'");
                            expectedOptions.append(constant.toString().toLowerCase());
                            expectedOptions.append("', ");
                            ++var11_10;
                            continue;
                        }
lbl36:
                        // 1 sources

                        expectedOptions.append("or 'all'");
                        ReadWriteLock.LOGGER.log(Level.WARNING, "option ''{0}'' from property \"oracle.javatools.lock\" not recognized: expected {1}", new Object[]{token.trim(), expectedOptions});
                    }
                }
                ++var9_3;
            }
            for (Options option : options) {
                switch (1.$sm$oracle$javatools$buffer$ReadWriteLock$Options[option.ordinal()]) {
                    case 1: {
                        ReadWriteLock.LOGGER.log(Level.CONFIG, "deadlock logging enabled");
                        break;
                    }
                    case 2: {
                        ReadWriteLock.LOGGER.log(Level.CONFIG, "upgrade logging enabled");
                        break;
                    }
                    case 3: {
                        ReadWriteLock.LOGGER.log(Level.CONFIG, "history logging enabled");
                        break;
                    }
                }
            }
        } else {
            options = EnumSet.allOf(Options.class);
        }
        return options;
    }

    public void setEventLog(Log log) {
        if (log == this.eventLog) {
            return;
        }
        if (this.eventLog != null) {
            this.eventLog.trace("stop logging lock events for {0}", this);
        }
        if (log != null && log.isEnabled()) {
            StringBuilder buffer = new StringBuilder();
            this.appendSummaryThreadState(buffer, this.writeState);
            for (ThreadState state : this.readers.values()) {
                if (state == this.writeState) continue;
                this.appendSummaryThreadState(buffer, state);
            }
            if (buffer.length() == 0) {
                buffer.append(", no locked threads");
            }
            log.trace("start logging lock events for {0}{1}", this, (Object)buffer);
            this.eventLog = log;
        } else {
            this.eventLog = null;
        }
    }

    private void logEvent(Event event) {
        if (this.eventLog == null) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        switch (1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[event.ordinal()]) {
            case 1: {
                if (this.writeThread == currentThread) {
                    return;
                }
                if (this.readers.containsKey(currentThread)) {
                    return;
                }
                if (!EventQueue.isDispatchThread()) break;
                return;
            }
            case 2: {
                if (this.writeThread == currentThread) {
                    return;
                }
                if (ThreadState.ra$readCount(this.readers.get(currentThread)) > 1) {
                    return;
                }
                if (!EventQueue.isDispatchThread()) break;
                return;
            }
            case 3: {
                break;
            }
            case 4: {
                if (this.writeThread == currentThread) {
                    return;
                }
                if (this.readers.containsKey(currentThread)) {
                    return;
                }
                if (!EventQueue.isDispatchThread()) break;
                return;
            }
            case 5: {
                if (this.writeThread != currentThread) break;
                return;
            }
            case 6: {
                if (ThreadState.ra$writeCount(this.writeState) <= 1) break;
                return;
            }
            case 7: {
                break;
            }
            case 8: {
                if (this.writeThread == null) break;
                return;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
        }
        StringBuilder buffer = new StringBuilder();
        this.appendSummaryThreadState(buffer, currentThread);
        this.eventLog.trace("{0} for {1}{2}", (Object)event, (Object)this, (Object)buffer);
    }

    private void appendSummaryThreadState(StringBuilder buffer, Thread currentThread) {
        ThreadState currentState = null;
        if (currentThread != null) {
            currentState = currentThread == this.writeThread ? this.writeState : this.readers.get(currentThread);
            buffer.append("; ");
            if (currentState != null) {
                if (this.blockedThreads.contains(ThreadState.ra$thread(currentState))) {
                    buffer.append("blocked, ");
                }
                this.appendCounted(buffer, ThreadState.ra$readCount(currentState), " read", ", ");
                this.appendCounted(buffer, ThreadState.ra$writeCount(currentState), " write", "");
            } else {
                buffer.append("no reads, no writes");
            }
        }
        boolean other = false;
        if (this.writeState != null && this.writeState != currentState) {
            other = true;
            buffer.append("; other locked threads:");
            this.appendSummaryThreadState(buffer, this.writeState);
        }
        for (ThreadState state : this.readers.values()) {
            if (state == currentState || state == this.writeState) continue;
            if (!other) {
                buffer.append("; other locked threads:");
                other = true;
            }
            this.appendSummaryThreadState(buffer, state);
        }
    }

    private void appendSummaryThreadState(StringBuilder buffer, ThreadState state) {
        if (state == null) {
            return;
        }
        buffer.append("\n                                                        ");
        buffer.append(ThreadState.ra$thread(state));
        buffer.append(": ");
        if (this.blockedThreads.contains(ThreadState.ra$thread(state))) {
            buffer.append("blocked, ");
        }
        this.appendCounted(buffer, ThreadState.ra$readCount(state), " read", ", ");
        this.appendCounted(buffer, ThreadState.ra$writeCount(state), " write", "");
    }

    public static void registerApiMethod(String className, String methodName) {
        apiMethods.add(className + ":" + methodName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Options
    extends Enum<Options> {
        private static final /* synthetic */ Options[] $v;
        public static final /* enum */ Options DEADLOCKS;
        public static final /* enum */ Options UPGRADES;
        public static final /* enum */ Options HISTORY;
        public static final /* enum */ Options NESTED_HISTORY;
        public static final /* enum */ Options DIALOGS;

        public static Options valueOf(String string) {
            return Enum.valueOf(Options.class, string);
        }

        public static final Options[] values() {
            return (Options[])$v.clone();
        }

        static {
            Options[] optionsArray = new Options[5];
            optionsArray[4] = DIALOGS = new Options("DIALOGS", 4);
            optionsArray[3] = NESTED_HISTORY = new Options("NESTED_HISTORY", 3);
            optionsArray[2] = HISTORY = new Options("HISTORY", 2);
            optionsArray[1] = UPGRADES = new Options("UPGRADES", 1);
            optionsArray[0] = DEADLOCKS = new Options("DEADLOCKS", 0);
            $v = optionsArray;
        }

        private Options(String string2, int n2) {
        }
    }

    private static class ThreadState {
        private Thread thread;
        private int readCount;
        private int writeCount;
        private List<Throwable> history;
        private int historySize;

        public ThreadState(Thread thread, boolean collectHistory) {
            this.thread = thread;
            if (collectHistory) {
                this.history = new ArrayList<Throwable>();
            }
        }

        static Thread ra$thread(ThreadState threadState) {
            return threadState.thread;
        }

        static int ra$readCount(ThreadState threadState) {
            return threadState.readCount;
        }

        static int ra$writeCount(ThreadState threadState) {
            return threadState.writeCount;
        }

        static List ra$history(ThreadState threadState) {
            return threadState.history;
        }

        static int ra$historySize(ThreadState threadState) {
            return threadState.historySize;
        }

        static void wa$historySize(ThreadState threadState, int n) {
            threadState.historySize = n;
        }

        static void wa$writeCount(ThreadState threadState, int n) {
            threadState.writeCount = n;
        }

        static void wa$readCount(ThreadState threadState, int n) {
            threadState.readCount = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Event
    extends Enum<Event> {
        private static final /* synthetic */ Event[] $v;
        public static final /* enum */ Event READ_LOCK_REQUEST;
        public static final /* enum */ Event READ_LOCK_GRANT;
        public static final /* enum */ Event READ_LOCK_DENIAL;
        public static final /* enum */ Event READ_UNLOCK;
        public static final /* enum */ Event WRITE_LOCK_REQUEST;
        public static final /* enum */ Event WRITE_LOCK_GRANT;
        public static final /* enum */ Event WRITE_LOCK_DENIAL;
        public static final /* enum */ Event WRITE_UNLOCK;
        public static final /* enum */ Event READ_LOCK_UPGRADE;
        public static final /* enum */ Event READ_UNLOCK_UPGRADE;

        public static Event valueOf(String string) {
            return Enum.valueOf(Event.class, string);
        }

        public static final Event[] values() {
            return (Event[])$v.clone();
        }

        static {
            Event[] eventArray = new Event[10];
            eventArray[9] = READ_UNLOCK_UPGRADE = new Event("READ_UNLOCK_UPGRADE", 9);
            eventArray[8] = READ_LOCK_UPGRADE = new Event("READ_LOCK_UPGRADE", 8);
            eventArray[7] = WRITE_UNLOCK = new Event("WRITE_UNLOCK", 7);
            eventArray[6] = WRITE_LOCK_DENIAL = new Event("WRITE_LOCK_DENIAL", 6);
            eventArray[5] = WRITE_LOCK_GRANT = new Event("WRITE_LOCK_GRANT", 5);
            eventArray[4] = WRITE_LOCK_REQUEST = new Event("WRITE_LOCK_REQUEST", 4);
            eventArray[3] = READ_UNLOCK = new Event("READ_UNLOCK", 3);
            eventArray[2] = READ_LOCK_DENIAL = new Event("READ_LOCK_DENIAL", 2);
            eventArray[1] = READ_LOCK_GRANT = new Event("READ_LOCK_GRANT", 1);
            eventArray[0] = READ_LOCK_REQUEST = new Event("READ_LOCK_REQUEST", 0);
            $v = eventArray;
        }

        private Event(String string2, int n2) {
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$buffer$ReadWriteLock$Event;
        static final /* synthetic */ int[] $sm$oracle$javatools$buffer$ReadWriteLock$Options;
        static final /* synthetic */ int[] $sm$java$lang$Thread$State;

        static {
            int[] nArray = new int[Thread.State.values().length];
            $sm$java$lang$Thread$State = nArray;
            try {
                nArray[Thread.State.BLOCKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$java$lang$Thread$State[Thread.State.WAITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$java$lang$Thread$State[Thread.State.TIMED_WAITING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            int[] nArray2 = new int[Options.values().length];
            $sm$oracle$javatools$buffer$ReadWriteLock$Options = nArray2;
            try {
                nArray2[Options.DEADLOCKS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Options[Options.UPGRADES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Options[Options.HISTORY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            int[] nArray3 = new int[Event.values().length];
            $sm$oracle$javatools$buffer$ReadWriteLock$Event = nArray3;
            try {
                nArray3[Event.READ_LOCK_REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.READ_LOCK_GRANT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.READ_LOCK_DENIAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.READ_UNLOCK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.WRITE_LOCK_REQUEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.WRITE_LOCK_GRANT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.WRITE_LOCK_DENIAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.WRITE_UNLOCK.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.READ_LOCK_UPGRADE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$buffer$ReadWriteLock$Event[Event.READ_UNLOCK_UPGRADE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

