/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

final class TextBufferReader
extends Reader {
    private ReadTextBuffer textBuffer;
    private int readOffset;
    private int markOffset;
    private Segment scratchSegment;
    private Exception acquireLocation;
    private static final boolean DEBUG_DEADLOCK;

    TextBufferReader(ReadTextBuffer textBuffer, int startOffset) {
        textBuffer.readLock();
        this.textBuffer = textBuffer;
        this.readOffset = startOffset;
        this.markOffset = 0;
        this.scratchSegment = new Segment();
        if (DEBUG_DEADLOCK) {
            this.acquireLocation = new Exception("TextBufferReader acquire location");
        }
    }

    private void verifyOpen() throws IOException {
        if (this.textBuffer == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            int bufferLength = this.textBuffer.getLength();
            if (this.readOffset >= bufferLength) {
                int n = -1;
                return n;
            }
            char c = this.textBuffer.getChar(this.readOffset++);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            int bufferLength = this.textBuffer.getLength();
            if (this.readOffset >= bufferLength) {
                int n = -1;
                return n;
            }
            int charsLeft = bufferLength - this.readOffset;
            int charsToRead = Math.min(charsLeft, length);
            if (charsToRead > 0) {
                Segment segment = this.scratchSegment;
                this.textBuffer.getText(this.readOffset, charsToRead, segment);
                System.arraycopy(segment.array, segment.offset, buffer, offset, charsToRead);
                this.readOffset += charsToRead;
            }
            int n = charsToRead;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long charsToSkip) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            charsToSkip = Math.max(0L, charsToSkip);
            int bufferLength = this.textBuffer.getLength();
            int charsLeft = Math.max(0, bufferLength - this.readOffset);
            charsToSkip = Math.min(charsToSkip, (long)charsLeft);
            this.readOffset = (int)((long)this.readOffset + charsToSkip);
            long l = charsToSkip;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean dataLeft;
            this.verifyOpen();
            boolean bl = dataLeft = this.readOffset < this.textBuffer.getLength();
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            this.markOffset = this.readOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            this.readOffset = this.markOffset;
        }
    }

    public void close() {
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal() {
        Object object = this.lock;
        synchronized (object) {
            if (this.textBuffer != null) {
                this.textBuffer.readUnlock();
                this.textBuffer = null;
                this.scratchSegment.array = null;
                this.scratchSegment = null;
                this.acquireLocation = null;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected void finalize() throws Throwable {
        boolean closeOccurred = this.closeInternal();
        if (closeOccurred) {
            System.out.println("Warning: TextBufferReader closed by finalizer");
            if (this.acquireLocation != null) {
                this.acquireLocation.printStackTrace(System.out);
                this.acquireLocation = null;
            }
        }
    }

    static {
        String property = System.getProperty("buffer.deadlock.detection");
        DEBUG_DEADLOCK = "true".equalsIgnoreCase(property);
        if (DEBUG_DEADLOCK) {
            System.out.println("TextBuffer reader orphaning detection enabled");
        }
    }
}

